/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.db;

import com.xdja.basecode.db.Column;
import com.xdja.basecode.db.DBConnectionPool;
import com.xdja.basecode.db.Table;
import com.xdja.basecode.util.HelpFunction;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class DBUtil {
    private static final Logger log4j = LoggerFactory.getLogger(DBUtil.class);
    private static final BASE64Encoder encoder = new BASE64Encoder();
    private static DBConnectionPool pool = DBConnectionPool.getInstance();
    private static HashMap<String, DBUtil> dbMap = new HashMap();
    private String dsID = null;
    private static Pattern CASE_INSENSITIVE_PATTERN_SELECT = Pattern.compile("select\\b", 2);
    private static Pattern CASE_INSENSITIVE_PATTERN_FROM = Pattern.compile("from\\b", 2);

    private DBUtil(String id) {
        this.dsID = id;
    }

    public static DBUtil getInstance(String dataSourceID) {
        if (HelpFunction.isEmpty(dataSourceID)) {
            log4j.warn("\u63d0\u4f9b\u7684\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return null;
        }
        String id = dataSourceID.toLowerCase();
        DBUtil db = dbMap.get(id);
        if (db == null) {
            db = new DBUtil(id);
            dbMap.put(id, db);
        }
        return db;
    }

    public ArrayList<HashMap<String, String>> query(String sql) throws Exception {
        return this.query(sql, null, null, 1, 1000);
    }

    public static ArrayList<HashMap<String, String>> query(Connection conn, String sql) throws Exception {
        return DBUtil.query(conn, true, sql, null, null, 1, 1000);
    }

    public static ArrayList<HashMap<String, String>> query(Connection conn, String sql, int pageNum, int pageSize) throws Exception {
        return DBUtil.query(conn, true, sql, null, null, pageNum, pageSize);
    }

    public ArrayList<HashMap<String, String>> query(String sql, int pageNum, int pageSize) throws Exception {
        return this.query(sql, null, null, pageNum, pageSize);
    }

    public ArrayList<HashMap<String, String>> query(String sql, String dateFormat) throws Exception {
        return this.query(sql, null, dateFormat, 1, 1000);
    }

    public ArrayList<HashMap<String, String>> query(String sql, Object[] params) throws Exception {
        return this.query(sql, params, null, 1, 1000);
    }

    public ArrayList<HashMap<String, String>> query(String sql, Object[] params, int pageNum, int pageSize) throws Exception {
        return this.query(sql, params, null, pageNum, pageSize);
    }

    public ArrayList<HashMap<String, String>> query(String sql, Object[] params, String dateFormat) throws Exception {
        return this.query(sql, params, dateFormat, 1, 1000);
    }

    public ArrayList<HashMap<String, String>> query(String sql, Object[] params, String dateFormat, int pageNum, int pageSize) throws Exception {
        if (log4j.isDebugEnabled()) {
            log4j.debug("...\u5f85\u6267\u884c sql= {}", (Object)sql);
        }
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("...\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new Exception("[91002]: \u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 1;
        }
        StringBuffer querySql = new StringBuffer();
        int p1 = 1;
        int p2 = 1;
        DatabaseTypes dbType = pool.getDBType(this.dsID);
        if (dbType == null) {
            throw new Exception("[91003]: \u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        Connection con = pool.getConnection(this.dsID);
        if (dbType == DatabaseTypes.Oracle) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            querySql.append("select * from(select a.*,rownum r from(");
            querySql.append(sql);
            querySql.append(") a where rownum <=?)b where r >?");
        } else if (dbType == DatabaseTypes.MySql) {
            p1 = pageNum * pageSize - pageSize;
            p2 = pageSize;
            querySql.append(sql);
            querySql.append(" limit ?,?");
        } else if (dbType == DatabaseTypes.SqlServer) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            if (DBUtil.isSqlServer2000(con)) {
                querySql.append(sql);
            } else {
                querySql.append(DBUtil.getNoSql2KQuerySql(sql, p2, p1));
            }
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        try {
            pst = con.prepareStatement(querySql.toString());
            if (params != null && params.length > 0) {
                for (int x = 0; x < params.length; ++x) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("...\u53c2\u6570 {} =[{}]", (Object)(x + 1), params[x]);
                    }
                    pst.setObject(x + 1, params[x]);
                }
                if (dbType != DatabaseTypes.SqlServer) {
                    pst.setInt(params.length + 1, p1);
                    pst.setInt(params.length + 2, p2);
                }
            } else if (dbType != DatabaseTypes.SqlServer) {
                pst.setInt(1, p1);
                pst.setInt(2, p2);
            }
            rs = pst.executeQuery();
            while (rs.next()) {
                HashMap<String, String> row = DBUtil.getRow(rs, dateFormat);
                rows.add(row);
                row = null;
            }
            pool.closeAll(rs, pst, con);
        }
        catch (Exception e) {
            try {
                log4j.error("...\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25[" + sql + "]:" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                pool.closeAll(rs, pst, con);
                throw throwable;
            }
        }
        return rows;
    }

    public static ArrayList<HashMap<String, String>> query(Connection con, boolean usedAutoClose, String sql, Object[] params, String dateFormat, int pageNum, int pageSize) throws Exception {
        if (log4j.isDebugEnabled()) {
            log4j.debug("...\u5f85\u6267\u884c sql= {}", (Object)sql);
        }
        if (con == null) {
            log4j.error("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
            throw new Exception("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
        }
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("...\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new Exception("[91002]: \u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 1;
        }
        StringBuffer querySql = new StringBuffer();
        int p1 = 1;
        int p2 = 1;
        DatabaseTypes type = null;
        type = DBUtil.getDbType(con);
        if (type == null) {
            throw new Exception("[91003]: \u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        if (type == DatabaseTypes.Oracle) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            querySql.append("select * from(select a.*,rownum r from(");
            querySql.append(sql);
            querySql.append(") a where rownum <=?)b where r >?");
        } else if (type == DatabaseTypes.MySql) {
            p1 = pageNum * pageSize - pageSize;
            p2 = pageSize;
            querySql.append(sql);
            querySql.append(" limit ?,?");
        } else if (type == DatabaseTypes.SqlServer) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            if (DBUtil.isSqlServer2000(con)) {
                querySql.append(sql);
            } else {
                querySql.append(DBUtil.getNoSql2KQuerySql(sql, p2, p1));
            }
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        try {
            pst = con.prepareStatement(querySql.toString());
            if (params != null && params.length > 0) {
                for (int x = 0; x < params.length; ++x) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("...\u53c2\u6570 {} ={}", (Object)(x + 1), params[x]);
                    }
                    pst.setObject(x + 1, params[x]);
                }
                if (type != DatabaseTypes.SqlServer) {
                    pst.setInt(params.length + 1, p1);
                    pst.setInt(params.length + 2, p2);
                }
            } else if (type != DatabaseTypes.SqlServer) {
                pst.setInt(1, p1);
                pst.setInt(2, p2);
            }
            rs = pst.executeQuery();
            while (rs.next()) {
                HashMap<String, String> row = DBUtil.getRow(rs, dateFormat);
                rows.add(row);
                row = null;
            }
            if (usedAutoClose) {
                pool.closeAll(rs, pst, con);
            } else {
                pool.closeAll(rs, pst, null);
            }
        }
        catch (Exception e) {
            try {
                log4j.error("...\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25[" + sql + "]:" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                if (usedAutoClose) {
                    pool.closeAll(rs, pst, con);
                } else {
                    pool.closeAll(rs, pst, null);
                }
                throw throwable;
            }
        }
        return rows;
    }

    public static ArrayList<HashMap<String, String>> query(Connection con, String sql, Object[] params, HashMap<String, String> dateFormat, int pageNum, int pageSize, boolean usedAutoClose) throws Exception {
        if (log4j.isDebugEnabled()) {
            log4j.debug("...\u5f85\u6267\u884c sql= {}", (Object)sql);
        }
        if (con == null) {
            log4j.error("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
            throw new Exception("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
        }
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("...\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new Exception("[91002]: \u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 1;
        }
        StringBuffer querySql = new StringBuffer();
        int p1 = 1;
        int p2 = 1;
        DatabaseTypes type = null;
        type = DBUtil.getDbType(con);
        if (type == null) {
            throw new Exception("[91003]: \u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        if (type == DatabaseTypes.Oracle) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            querySql.append("select * from(select a.*,rownum r from(");
            querySql.append(sql);
            querySql.append(") a where rownum <=?)b where r >?");
        } else if (type == DatabaseTypes.MySql) {
            p1 = pageNum * pageSize - pageSize;
            p2 = pageSize;
            querySql.append(sql);
            querySql.append(" limit ?,?");
        } else if (type == DatabaseTypes.SqlServer) {
            p1 = pageNum * pageSize;
            p2 = p1 - pageSize;
            if (DBUtil.isSqlServer2000(con)) {
                querySql.append(sql);
            } else {
                querySql.append(DBUtil.getNoSql2KQuerySql(sql, p2, p1));
            }
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        try {
            pst = con.prepareStatement(querySql.toString());
            if (params != null && params.length > 0) {
                for (int x = 0; x < params.length; ++x) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("...\u53c2\u6570 {} =[{}]", (Object)(x + 1), params[x]);
                    }
                    pst.setObject(x + 1, params[x]);
                }
                if (type != DatabaseTypes.SqlServer) {
                    pst.setInt(params.length + 1, p1);
                    pst.setInt(params.length + 2, p2);
                }
            } else if (type != DatabaseTypes.SqlServer) {
                pst.setInt(1, p1);
                pst.setInt(2, p2);
            }
            rs = pst.executeQuery();
            while (rs.next()) {
                HashMap<String, String> row = DBUtil.getRow(rs, dateFormat);
                rows.add(row);
                row = null;
            }
            if (usedAutoClose) {
                pool.closeAll(rs, pst, con);
            } else {
                pool.closeAll(rs, pst, null);
            }
        }
        catch (Exception e) {
            try {
                log4j.error("...\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25[" + sql + "]:" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                if (usedAutoClose) {
                    pool.closeAll(rs, pst, con);
                } else {
                    pool.closeAll(rs, pst, null);
                }
                throw throwable;
            }
        }
        return rows;
    }

    public ArrayList<HashMap<String, String>> queryData(String querySql, int startRowIndex, int pageSize) throws Exception {
        if (startRowIndex <= 0) {
            startRowIndex = 1;
        }
        if (pageSize <= 0) {
            pageSize = 1;
        }
        int pageNum = 1;
        if (startRowIndex > 1) {
            pageNum = startRowIndex / pageSize + 1;
        }
        return this.query(querySql, null, null, pageNum, pageSize);
    }

    public boolean executeSql(String sql) throws SQLException {
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        Connection con = pool.getConnection(this.dsID);
        if (con == null) {
            return false;
        }
        Statement st = null;
        try {
            st = con.createStatement();
            boolean bl = st.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            pool.closeAll(null, st, con);
        }
    }

    public static boolean executeSql(Connection con, String sql) throws SQLException {
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(sql);
        return DBUtil.executeUpdate(con, sqls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeUpdate(String sql) {
        if (HelpFunction.isEmpty(sql)) {
            log4j.warn("\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        Connection con = pool.getConnection(this.dsID);
        if (con == null) {
            return false;
        }
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement(sql);
            pst.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log4j.error("...\u6267\u884c\u8bed\u53e5\u5931\u8d25[" + sql + "]\uff1a" + e.getMessage());
        }
        finally {
            pool.closeAll(null, pst, con);
        }
        return false;
    }

    public boolean executeUpdate(String sql, Object[] parameters) throws SQLException {
        if (HelpFunction.isEmpty(sql)) {
            return false;
        }
        if (HelpFunction.isEmpty(parameters)) {
            return false;
        }
        ArrayList<String> sqls = new ArrayList<String>(1);
        sqls.add(sql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        params.add(parameters);
        return DBUtil.executeUpdate(pool.getConnection(this.dsID), sqls, params);
    }

    public boolean executeUpdate(ArrayList<String> sqls) throws SQLException {
        return DBUtil.executeUpdate(pool.getConnection(this.dsID), sqls);
    }

    public static boolean executeUpdate(Connection con, ArrayList<String> sqls) throws SQLException {
        return DBUtil.executeUpdate(con, sqls, null);
    }

    public static boolean executeUpdate(Connection con, ArrayList<String> sqls, ArrayList<Object[]> parameters) throws SQLException {
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u8fdb\u5165executeUpdate()");
        }
        if (sqls == null || sqls.size() == 0) {
            log4j.warn("...\u8bed\u53e5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (con == null) {
            return false;
        }
        PreparedStatement pst = null;
        try {
            int x;
            for (x = 0; x < sqls.size(); ++x) {
                String sql = sqls.get(x);
                pst = con.prepareStatement(sql);
                if (HelpFunction.isEmpty(parameters)) {
                    pst.addBatch();
                } else {
                    Object[] pms = parameters.get(x);
                    if (HelpFunction.isEmpty(pms)) {
                        pst.addBatch();
                    } else {
                        if (log4j.isDebugEnabled()) {
                            log4j.debug("\u53c2\u6570\u4e0d\u4e3a\u7a7a");
                        }
                        for (int y = 0; y < pms.length; ++y) {
                            int pidx = y + 1;
                            if (pms[y] == null) {
                                pst.setNull(pidx, 0);
                                continue;
                            }
                            pst.setObject(pidx, pms[y]);
                        }
                        pst.addBatch();
                    }
                }
                pst.executeBatch();
            }
            x = 1;
            return x != 0;
        }
        catch (SQLException e) {
            log4j.error("...\u6267\u884c\u8bed\u53e5\u7ec4\u65f6\u5f02\u5e38\uff1a" + e.getErrorCode() + "," + e.getMessage());
            throw e;
        }
        finally {
            pool.closeAll(null, pst, con);
        }
    }

    public boolean executeBatchUpdate(ArrayList<String> sqls) throws SQLException {
        if (sqls == null || sqls.size() == 0) {
            log4j.warn("...\u8bed\u53e5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        return DBUtil.executeBatchUpdate(pool.getConnection(this.dsID), sqls, null);
    }

    public boolean executeBatchUpdate(String sql, Object[][] parameters) throws SQLException {
        return DBUtil.executeBatchUpdate(pool.getConnection(this.dsID), sql, parameters);
    }

    public boolean executeBatchUpdate(ArrayList<String> sqls, ArrayList<Object[]> params) throws SQLException {
        return DBUtil.executeBatchUpdate(pool.getConnection(this.dsID), sqls, params);
    }

    public static boolean executeBatchUpdate(Connection con, ArrayList<String> sqls) throws SQLException {
        return DBUtil.executeBatchUpdate(con, sqls, null);
    }

    public static boolean executeBatchUpdate(Connection con, String sql, Object[][] parameters) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>(1);
        sqls.add(sql);
        ArrayList<Object[][]> params = new ArrayList<Object[][]>();
        params.add(parameters);
        return DBUtil.executeBatchUpdateWithOneToMore(con, sqls, params);
    }

    public static boolean executeBatchUpdate(Connection con, ArrayList<String> sqls, ArrayList<Object[]> params) throws SQLException {
        if (HelpFunction.isEmpty(sqls)) {
            log4j.warn("...\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        PreparedStatement pst = null;
        try {
            int x;
            if (con == null) {
                boolean bl = false;
                return bl;
            }
            con.setAutoCommit(false);
            for (x = 0; x < sqls.size(); ++x) {
                pst = con.prepareStatement(sqls.get(x));
                if (HelpFunction.isEmpty(params)) {
                    pst.addBatch();
                } else {
                    Object[] pms = params.get(x);
                    if (HelpFunction.isEmpty(pms)) {
                        pst.addBatch();
                    } else {
                        for (int y = 0; y < pms.length; ++y) {
                            int pidx = y + 1;
                            if (pms[y] == null) {
                                pst.setNull(pidx, 0);
                                continue;
                            }
                            pst.setObject(pidx, pms[y]);
                        }
                        pst.addBatch();
                    }
                }
                pst.executeBatch();
            }
            con.commit();
            x = 1;
            pool.closeAll(null, pst, con);
            return x != 0;
        }
        catch (SQLException e) {
            log4j.error("...\u6279\u91cf\u6267\u884c\u8bed\u53e5\u5931\u8d25\uff1a" + e.getMessage());
            if (con != null) {
                try {
                    con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            pool.closeAll(null, pst, con);
        }
    }

    public boolean executeBatchUpdateWithOneToMore(ArrayList<String> sqls, ArrayList<Object[][]> params) throws SQLException {
        if (HelpFunction.isEmpty(sqls)) {
            log4j.warn("...\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        return DBUtil.executeBatchUpdateWithOneToMore(pool.getConnection(this.dsID), sqls, params);
    }

    public static boolean executeBatchUpdateWithOneToMore(Connection con, ArrayList<String> sqls, ArrayList<Object[][]> params) throws SQLException {
        if (HelpFunction.isEmpty(sqls)) {
            log4j.warn("...\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        PreparedStatement pst = null;
        try {
            int x;
            con.setAutoCommit(false);
            for (x = 0; x < sqls.size(); ++x) {
                pst = con.prepareStatement(sqls.get(x));
                if (HelpFunction.isEmpty(params)) {
                    pst.addBatch();
                } else {
                    Object[][] parr = params.get(x);
                    if (HelpFunction.isEmpty((Object[])parr)) {
                        pst.addBatch();
                    } else {
                        for (Object[] pms : parr) {
                            if (HelpFunction.isEmpty(pms)) {
                                pst.addBatch();
                                continue;
                            }
                            for (int y = 0; y < pms.length; ++y) {
                                int pidx = y + 1;
                                if (pms[y] == null) {
                                    pst.setNull(pidx, 0);
                                    continue;
                                }
                                pst.setObject(pidx, pms[y]);
                            }
                            pst.addBatch();
                        }
                    }
                }
                pst.executeBatch();
            }
            con.commit();
            x = 1;
            pool.closeAll(null, pst, con);
            return x != 0;
        }
        catch (SQLException e) {
            try {
                log4j.error("...\u6279\u91cf\u6267\u884c\u8bed\u53e5\u5931\u8d25\uff1a" + e.getMessage());
                if (con != null) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                pool.closeAll(null, pst, con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDBConnection(int dbType, String ip, int port, String dbName, String userName, String password) {
        Connection con = null;
        try {
            Class.forName(DBConnectionPool.getDriverClass(dbType));
            String url = DBConnectionPool.getDBLinkUrl(dbType, ip, port, dbName, true, "utf8");
            if ("systest".equals(password)) {
                password = System.getProperty("password");
            }
            if ((con = DriverManager.getConnection(url, userName, password)) != null) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug("...\u53c2\u6570\u6b63\u786e\uff0c\u53ef\u4ee5\u6b63\u5e38\u8fde\u63a5\u3002");
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log4j.error("...\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDBConnection(int dbType, String ip, int port, String dbName, String userName, String password, boolean useUnicode, String charset) {
        Connection con = null;
        try {
            Class.forName(DBConnectionPool.getDriverClass(dbType));
            String url = DBConnectionPool.getDBLinkUrl(dbType, ip, port, dbName, useUnicode, charset);
            con = DriverManager.getConnection(url, userName, password);
            if (con != null) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug("...\u53c2\u6570\u6b63\u786e\uff0c\u53ef\u4ee5\u6b63\u5e38\u8fde\u63a5\u3002");
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log4j.error("...\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBTables() {
        String sql = this.getQueryAllTablesSql();
        Connection con = null;
        Statement smt = null;
        ResultSet rs = null;
        StringBuilder xml = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>");
        xml.append("<root>");
        try {
            con = pool.getConnection(this.dsID);
            smt = con.createStatement();
            rs = smt.executeQuery(sql);
            while (rs.next()) {
                xml.append("<table name='" + rs.getString("table_name"));
                xml.append("' desc='");
                if (HelpFunction.isEmpty(rs.getString("comments"))) {
                    xml.append(rs.getString("table_name"));
                } else {
                    xml.append(rs.getString("comments"));
                }
                xml.append("'/>");
            }
            pool.closeAll(rs, smt, con);
        }
        catch (Exception e) {
            try {
                log4j.error("\u83b7\u53d6\u5168\u90e8\u8868\u540d\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
                pool.closeAll(rs, smt, con);
            }
            catch (Throwable throwable) {
                pool.closeAll(rs, smt, con);
                throw throwable;
            }
        }
        xml.append("</root>");
        return xml.toString();
    }

    public Table getTableStructure(String name) throws SQLException {
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u8fdb\u5165 getTableStructure()...name={}", (Object)name);
        }
        return DBUtil.getTableOrViewStructure(pool.getConnection(this.dsID), name);
    }

    public static Table getTableOrViewStructure(Connection conn, String name) throws SQLException {
        Table table;
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u83b7\u53d6 {} \u6570\u636e\u7ed3\u6784", (Object)name);
        }
        if (conn == null) {
            log4j.error("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
            return null;
        }
        if (HelpFunction.isEmpty(name)) {
            log4j.error("\u8868\u6216\u89c6\u56fe\u540d\u4e3a\u7a7a");
            return null;
        }
        Table table2 = DBUtil.checkTableOrViewExist(conn, name, false);
        if (table2 == null) {
            log4j.error("\u8868\u6216\u89c6\u56fe\u3010" + name + "\u3011\u4e0d\u5b58\u5728");
            return null;
        }
        DatabaseTypes type = DBUtil.getDbType(conn);
        String sql = "select * from " + name + " where 1=2";
        StringBuilder getDefaultComment = new StringBuilder();
        boolean sqlServer2000Great = false;
        if (DatabaseTypes.Oracle == type) {
            getDefaultComment.append("select a.column_name,b.comments column_comment,a.DATA_DEFAULT column_default ");
            getDefaultComment.append(" from user_tab_columns a,user_col_comments b ");
            getDefaultComment.append(" where a.TABLE_NAME=b.table_name and a.COLUMN_NAME=b.column_name ");
            getDefaultComment.append(" and a.TABLE_NAME=upper(?) and a.COLUMN_NAME=upper(?)");
        } else if (DatabaseTypes.MySql == type) {
            try {
                getDefaultComment.append("select column_name,column_comment,column_default ");
                getDefaultComment.append(" from information_schema.columns where lower(table_schema)=lower('" + conn.getCatalog() + "') ");
                getDefaultComment.append(" and lower(table_name)=lower(?) and lower(column_name)=lower(?)");
            }
            catch (Exception e) {
                log4j.error("\u83b7\u53d6 MySql \u6570\u636e\u5e93\u540d\u65f6\u9519\u8bef\uff1a" + e.getMessage());
                return null;
            }
        } else if (DatabaseTypes.SqlServer == type) {
            if (DBUtil.isSqlServer2000(conn)) {
                getDefaultComment.append("select c.name column_name,p.value column_comment,'' column_default ");
                getDefaultComment.append(" from syscolumns c left join sysobjects s on c.id=s.id ");
                getDefaultComment.append(" left join sysproperties p on c.colid=p.smallid ");
                getDefaultComment.append(" where lower(s.name)=lower(?) and lower(c.name)=lower(?)");
            } else {
                sqlServer2000Great = true;
                getDefaultComment.append("select b.name column_name,c.value column_comment,d.definition column_default from ( ");
                getDefaultComment.append("select a.object_id,a.name,a.column_id from sys.columns a ");
                getDefaultComment.append(" where a.object_id=( select object_id from sys.objects ");
                getDefaultComment.append(" where (type_desc='USER_TABLE' or type_desc='VIEW') and LOWER(name)=LOWER(?))) b ");
                getDefaultComment.append(" left join sys.extended_properties c on c.major_id=b.object_id and c.minor_id=b.column_id ");
                getDefaultComment.append(" left join sys.default_constraints d on b.object_id=d.parent_object_id and b.column_id=d.parent_column_id ");
                getDefaultComment.append(" where lower(b.name)=lower(?)");
                getDefaultComment.append(" order by b.name");
            }
        }
        PreparedStatement psmt = null;
        ResultSet rs = null;
        PreparedStatement psmt2 = null;
        ResultSet rs2 = null;
        try {
            psmt = conn.prepareStatement(sql);
            psmt2 = conn.prepareStatement(getDefaultComment.toString());
            rs = psmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            if (log4j.isDebugEnabled()) {
                log4j.debug("\u603b\u5217\u6570\uff1a{}", (Object)cols);
            }
            for (int x = 1; x <= cols; ++x) {
                Column col = new Column();
                col.setAutoIncrement(rsmd.isAutoIncrement(x));
                col.setName(rsmd.getColumnName(x));
                col.setType(rsmd.getColumnType(x));
                col.setTypeName(rsmd.getColumnTypeName(x));
                col.setPrecision(rsmd.getPrecision(x));
                col.setScale(rsmd.getScale(x));
                col.setLength(col.getPrecision());
                col.setNull(rsmd.isNullable(x) == 1);
                psmt2.setString(1, name);
                psmt2.setString(2, col.getName());
                rs2 = psmt2.executeQuery();
                if (rs2.next()) {
                    col.setDesc(rs2.getString("column_comment"));
                    col.setDefValue(rs2.getString("column_default"));
                }
                rs2.close();
                rs2 = null;
                if (HelpFunction.isEmpty(col.getDesc())) {
                    col.setDesc(col.getName());
                }
                if (!HelpFunction.isEmpty(col.getDefValue()) && sqlServer2000Great) {
                    if (col.getDefValue().startsWith("((")) {
                        col.setDefValue(col.getDefValue().substring(2, col.getDefValue().length() - 2));
                    } else if (col.getDefValue().startsWith("('")) {
                        col.setDefValue(col.getDefValue().substring(1, col.getDefValue().length() - 1));
                    }
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug("name={},desc={},default={}", new Object[]{col.getName(), col.getDesc(), col.getDefValue()});
                }
                table2.getColumns().add(col);
            }
            table = table2;
        }
        catch (SQLException e) {
            try {
                log4j.error("\u83b7\u53d6\u8868\u6216\u89c6\u56fe[" + name + "]\u7ed3\u6784\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DBUtil.closeAll(rs2, psmt2, null);
                DBUtil.closeAll(rs, psmt, conn);
                throw throwable;
            }
        }
        DBUtil.closeAll(rs2, psmt2, null);
        DBUtil.closeAll(rs, psmt, conn);
        return table;
    }

    public static Table getTableOrViewStructure(Connection conn, String owner, String name) throws SQLException {
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u83b7\u53d6 {} \u6570\u636e\u7ed3\u6784", (Object)name);
        }
        if (conn == null) {
            log4j.error("[60005]: \u8c03\u7528\u8d44\u6e90\u65f6\uff0c\u540e\u7aef\u670d\u52a1\u65e0\u6cd5\u8fde\u63a5\uff0c\u8be5\u8d44\u6e90\u7684\u540e\u7aef\u670d\u52a1\u4e3a\u6570\u636e\u5e93\u3002");
            return null;
        }
        if (HelpFunction.isEmpty(name)) {
            log4j.error("\u8868\u6216\u89c6\u56fe\u540d\u4e3a\u7a7a");
            return null;
        }
        Table table = DBUtil.checkTableOrViewExist(conn, owner, name, false);
        if (table == null) {
            log4j.error("\u8868\u6216\u89c6\u56fe\u3010" + name + "\u3011\u4e0d\u5b58\u5728");
            return null;
        }
        DatabaseTypes type = DBUtil.getDbType(conn);
        boolean sqlServer2000Great = !DBUtil.isSqlServer2000(conn);
        String getFieldsInfo = DBUtil.getFieldsCommentSql(type, owner, sqlServer2000Great);
        DBUtil.fillTableFields(conn, owner, table, sqlServer2000Great, getFieldsInfo);
        return table;
    }

    private static void fillTableFields(Connection conn, String owner, Table table, boolean sqlServer2000Great, String getFieldsInfo) throws SQLException {
        String sql = "select * from " + owner + "." + table.getName() + " where 1=2";
        PreparedStatement psmt = null;
        ResultSet rs = null;
        PreparedStatement psmt2 = null;
        ResultSet rs2 = null;
        try {
            psmt = conn.prepareStatement(sql);
            psmt2 = conn.prepareStatement(getFieldsInfo);
            rs = psmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            if (log4j.isDebugEnabled()) {
                log4j.debug("\u603b\u5217\u6570\uff1a{}", (Object)cols);
            }
            for (int x = 1; x <= cols; ++x) {
                Column col = new Column();
                col.setAutoIncrement(rsmd.isAutoIncrement(x));
                col.setName(rsmd.getColumnName(x));
                col.setType(rsmd.getColumnType(x));
                col.setTypeName(rsmd.getColumnTypeName(x));
                col.setPrecision(rsmd.getPrecision(x));
                col.setScale(rsmd.getScale(x));
                col.setLength(col.getPrecision());
                col.setNull(rsmd.isNullable(x) == 1);
                psmt2.setString(1, owner);
                psmt2.setString(2, table.getName());
                psmt2.setString(3, col.getName());
                rs2 = psmt2.executeQuery();
                if (rs2.next()) {
                    col.setDesc(rs2.getString("column_comment"));
                    col.setDefValue(rs2.getString("column_default"));
                }
                rs2.close();
                rs2 = null;
                if (HelpFunction.isEmpty(col.getDesc())) {
                    col.setDesc(col.getName());
                }
                if (!HelpFunction.isEmpty(col.getDefValue()) && sqlServer2000Great) {
                    if (col.getDefValue().startsWith("((")) {
                        col.setDefValue(col.getDefValue().substring(2, col.getDefValue().length() - 2));
                    } else if (col.getDefValue().startsWith("('")) {
                        col.setDefValue(col.getDefValue().substring(1, col.getDefValue().length() - 1));
                    }
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug("name={},desc={},default={}", new Object[]{col.getName(), col.getDesc(), col.getDefValue()});
                }
                table.getColumns().add(col);
            }
        }
        catch (SQLException e) {
            try {
                log4j.error("\u83b7\u53d6\u8868\u6216\u89c6\u56fe[" + table.getName() + "]\u7ed3\u6784\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DBUtil.closeAll(rs2, psmt2, null);
                DBUtil.closeAll(rs, psmt, conn);
                throw throwable;
            }
        }
        DBUtil.closeAll(rs2, psmt2, null);
        DBUtil.closeAll(rs, psmt, conn);
    }

    private static String getFieldsCommentSql(DatabaseTypes type, String owner, boolean sqlServer2000Great) {
        StringBuilder getDefaultComment = new StringBuilder();
        if (DatabaseTypes.Oracle == type) {
            getDefaultComment.append("select a.column_name,nvl(b.comments,a.column_name) column_comment,a.data_default column_default");
            getDefaultComment.append(" from all_tab_columns a,all_col_comments b ");
            getDefaultComment.append(" where a.owner=b.owner and a.table_name=b.table_name and a.column_name=b.column_name ");
            getDefaultComment.append(" and a.owner=upper(?) and a.TABLE_NAME=upper(?) and a.COLUMN_NAME=upper(?)");
        } else if (DatabaseTypes.MySql == type) {
            getDefaultComment.append("select column_name,column_comment,column_default ");
            getDefaultComment.append(" from information_schema.columns where lower(table_schema)=lower(?) ");
            getDefaultComment.append(" and lower(table_name)=lower(?) and lower(column_name)=lower(?)");
        } else if (DatabaseTypes.SqlServer == type) {
            if (sqlServer2000Great) {
                getDefaultComment.append("select b.name column_name,c.value column_comment,d.definition column_default from ( ");
                getDefaultComment.append("select a.object_id,a.name,a.column_id from sys.columns a ");
                getDefaultComment.append(" where a.object_id=( select object_id from sys.objects ");
                getDefaultComment.append(" where (type_desc='USER_TABLE' or type_desc='VIEW') and LOWER(name)=LOWER(?))) b ");
                getDefaultComment.append(" left join sys.extended_properties c on c.major_id=b.object_id and c.minor_id=b.column_id ");
                getDefaultComment.append(" left join sys.default_constraints d on b.object_id=d.parent_object_id and b.column_id=d.parent_column_id ");
                getDefaultComment.append(" where lower(b.name)=lower(?)");
                getDefaultComment.append(" order by b.name");
            } else {
                getDefaultComment.append("select c.name column_name,p.value column_comment,'' column_default ");
                getDefaultComment.append(" from syscolumns c left join sysobjects s on c.id=s.id ");
                getDefaultComment.append(" left join sysproperties p on c.colid=p.smallid ");
                getDefaultComment.append(" where lower(s.name)=lower(?) and lower(c.name)=lower(?)");
            }
        }
        return getDefaultComment.toString();
    }

    public static List<Table> getTablesAndViews(Connection conn, ObjectTypes type) throws SQLException {
        if (conn == null) {
            log4j.error("\u6570\u636e\u5e93\u8fde\u63a5\u4e3a null");
            return null;
        }
        ArrayList<Table> list = new ArrayList<Table>();
        String sql = DBUtil.getQueryAllTablesSql(conn, type, false);
        if (sql == null) {
            return list;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement(sql);
            rs = pst.executeQuery();
            while (rs.next()) {
                Table table = new Table();
                table.setName(rs.getString("table_name"));
                table.setDesc(rs.getString("comments"));
                table.setType(DBUtil.getTableType(rs.getString("table_type")));
                if (HelpFunction.isEmpty(table.getDesc())) {
                    table.setDesc(table.getName());
                }
                list.add(table);
            }
        }
        catch (SQLException e) {
            try {
                log4j.error("\u67e5\u8be2\u8868\u6216\u89c6\u56fe\u9519\u8bef\uff1a" + e.getErrorCode() + "," + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DBUtil.closeAll(rs, pst, conn);
                throw throwable;
            }
        }
        DBUtil.closeAll(rs, pst, conn);
        return list;
    }

    public static List<Table> getTablesAndViews(Connection conn, ObjectTypes type, String owner) throws SQLException {
        if (conn == null) {
            log4j.error("\u6570\u636e\u5e93\u8fde\u63a5\u4e3a null");
            return null;
        }
        ArrayList<Table> list = new ArrayList<Table>();
        String sql = DBUtil.getQueryAllTablesSql(conn, type, owner, false);
        if (sql == null) {
            return list;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement(sql);
            pst.setString(1, owner);
            rs = pst.executeQuery();
            while (rs.next()) {
                Table table = new Table();
                table.setName(rs.getString("table_name"));
                table.setDesc(rs.getString("comments"));
                table.setType(DBUtil.getTableType(rs.getString("table_type")));
                if (HelpFunction.isEmpty(table.getDesc())) {
                    table.setDesc(table.getName());
                }
                list.add(table);
            }
        }
        catch (SQLException e) {
            try {
                log4j.error("\u67e5\u8be2\u8868\u6216\u89c6\u56fe\u9519\u8bef\uff1a" + e.getErrorCode() + "," + e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                DBUtil.closeAll(rs, pst, conn);
                throw throwable;
            }
        }
        DBUtil.closeAll(rs, pst, conn);
        return list;
    }

    public static Table checkTableOrViewExist(Connection conn, String name, boolean closeConn) throws SQLException {
        ResultSet rs;
        PreparedStatement pst;
        block16: {
            Table table;
            if (log4j.isDebugEnabled()) {
                log4j.debug("\u8fdb\u5165 checkTableOrViewExist()...\u8868\u540d={}", (Object)name);
            }
            if (conn == null) {
                log4j.error("\u8fde\u63a5\u4e3a\u7a7a");
                return null;
            }
            DatabaseTypes type = DBUtil.getDbType(conn);
            if (type == null) {
                return null;
            }
            StringBuilder sql = new StringBuilder();
            if (type == DatabaseTypes.Oracle) {
                sql.append("select table_name,");
                sql.append("nvl(comments,case table_type when 'TABLE' then '\u8868'||table_name when 'VIEW' then '\u89c6\u56fe'||table_name else table_name end) comments,");
                sql.append("table_type from user_tab_comments where table_name=upper(?)");
            } else if (type == DatabaseTypes.MySql) {
                sql.append("select table_name,table_comment as comments,table_type ");
                sql.append(" from information_schema.tables ");
                sql.append(" where upper(table_name)=upper(?) ");
                sql.append(" and table_schema='" + conn.getCatalog() + "'");
            } else if (type == DatabaseTypes.SqlServer) {
                if (DBUtil.isSqlServer2000(conn)) {
                    sql.append("select s.name table_name,p.value comments,s.type table_type from sysobjects s ");
                    sql.append(" left join sysproperties p on s.id=p.id and p.smallid=0 ");
                    sql.append(" where upper(s.name)=upper(?)");
                } else {
                    sql.append("select * from (");
                    sql.append("select a.name table_name,b.value comments,'table' table_type");
                    sql.append(" from sys.tables a left join sys.extended_properties b ");
                    sql.append(" on b.minor_id=0 and a.object_id=b.major_id ");
                    sql.append(" union ");
                    sql.append(" select name table_name,name comments,'view' table_type ");
                    sql.append(" from sys.views");
                    sql.append(")c where lower(table_name)=lower(?)");
                }
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug("sql={}", (Object)sql);
            }
            pst = null;
            rs = null;
            try {
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, name);
                rs = pst.executeQuery();
                if (!rs.next()) break block16;
                Table table2 = new Table();
                table2.setName(rs.getString("table_name"));
                table2.setDesc(rs.getString("comments"));
                table2.setType(DBUtil.getTableType(rs.getString("table_type")));
                if (HelpFunction.isEmpty(table2.getDesc())) {
                    table2.setDesc(table2.getName());
                }
                table = table2;
                DBUtil.closeAll(rs, pst, closeConn ? conn : null);
            }
            catch (SQLException e) {
                try {
                    log4j.error("\u68c0\u7d22\u8868\u6216\u89c6\u56fe\u5931\u8d25\uff1a" + e.getErrorCode() + "," + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtil.closeAll(rs, pst, closeConn ? conn : null);
                    throw throwable;
                }
            }
            return table;
        }
        DBUtil.closeAll(rs, pst, closeConn ? conn : null);
        return null;
    }

    public static Table checkTableOrViewExist(Connection conn, String owner, String name, boolean closeConn) throws SQLException {
        ResultSet rs;
        PreparedStatement pst;
        block17: {
            Table table;
            if (log4j.isDebugEnabled()) {
                log4j.debug("\u8fdb\u5165 checkTableOrViewExist()...\u8868\u540d={}", (Object)name);
            }
            if (conn == null) {
                log4j.error("\u8fde\u63a5\u4e3a\u7a7a");
                return null;
            }
            if (HelpFunction.isEmpty(owner)) {
                log4j.error("\u6240\u6709\u8005\u4e3a\u7a7a");
                return null;
            }
            DatabaseTypes type = DBUtil.getDbType(conn);
            if (type == null) {
                return null;
            }
            StringBuilder sql = new StringBuilder();
            if (type == DatabaseTypes.Oracle) {
                sql.append("select a.table_name,");
                sql.append("nvl(a.comments,case a.table_type when 'TABLE' then '\u8868'||a.table_name when 'VIEW' then '\u89c6\u56fe'||a.table_name else a.table_name end) comments,");
                sql.append("a.table_type");
                sql.append(" from all_tab_comments a,user_tab_privs b ");
                sql.append(" where a.owner=b.owner and a.table_name=b.table_name ");
                sql.append(" and b.owner=upper(?) and a.table_name=upper(?)");
            } else if (type == DatabaseTypes.MySql) {
                sql.append("select table_name,table_comment as comments,table_type ");
                sql.append(" from information_schema.tables ");
                sql.append(" where table_schema=? and ");
                sql.append(" lower(table_name)=lower(?)");
            } else if (type == DatabaseTypes.SqlServer) {
                if (DBUtil.isSqlServer2000(conn)) {
                    sql.append("select s.name table_name,p.value comments,s.type table_type from sysobjects s ");
                    sql.append(" left join sysproperties p on s.id=p.id and p.smallid=0 ");
                    sql.append(" where upper(s.name)=upper(?)");
                } else {
                    sql.append("select * from (");
                    sql.append("select a.name table_name,b.value comments,'table' table_type");
                    sql.append(" from sys.tables a left join sys.extended_properties b ");
                    sql.append(" on b.minor_id=0 and a.object_id=b.major_id ");
                    sql.append(" union ");
                    sql.append(" select name table_name,name comments,'view' table_type ");
                    sql.append(" from sys.views");
                    sql.append(")c where lower(table_name)=lower(?)");
                }
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug("sql={}", (Object)sql);
            }
            pst = null;
            rs = null;
            try {
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, owner);
                pst.setString(2, name);
                rs = pst.executeQuery();
                if (!rs.next()) break block17;
                Table table2 = new Table();
                table2.setName(rs.getString("table_name"));
                table2.setDesc(rs.getString("comments"));
                table2.setType(DBUtil.getTableType(rs.getString("table_type")));
                if (HelpFunction.isEmpty(table2.getDesc())) {
                    table2.setDesc(table2.getName());
                }
                table = table2;
                DBUtil.closeAll(rs, pst, closeConn ? conn : null);
            }
            catch (SQLException e) {
                try {
                    log4j.error("\u68c0\u7d22\u8868\u6216\u89c6\u56fe\u5931\u8d25\uff1a" + e.getErrorCode() + "," + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtil.closeAll(rs, pst, closeConn ? conn : null);
                    throw throwable;
                }
            }
            return table;
        }
        DBUtil.closeAll(rs, pst, closeConn ? conn : null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getQueryAllTablesSql(Connection con, ObjectTypes type, boolean usedAutoClose) {
        StringBuilder query;
        block30: {
            query = new StringBuilder();
            try {
                DatabaseTypes dbType = DBUtil.getDbType(con);
                if (DatabaseTypes.Oracle == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 Oracle \u6570\u636e\u5e93\u8868 ");
                    }
                    query.append("select table_name,comments,table_type from user_tab_comments where ");
                    query.append("table_name not like 'BIN$%'");
                    if (type == ObjectTypes.table) {
                        query.append(" and upper(table_type)='TABLE'");
                        query.append(" ORDER BY table_name");
                    } else if (type == ObjectTypes.view) {
                        query.append(" and upper(table_type)='VIEW'");
                        query.append(" ORDER BY table_name");
                    } else {
                        query.append(" ORDER BY table_type,table_name");
                    }
                    break block30;
                }
                if (DatabaseTypes.MySql == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 MySql \u6570\u636e\u5e93\u8868 ");
                    }
                    query.append("select table_name,table_comment as comments,table_type from information_schema.tables where ");
                    query.append(" table_schema='" + con.getCatalog() + "'");
                    if (type == ObjectTypes.table) {
                        query.append(" and table_type='BASE TABLE' order by table_name ");
                    } else if (type == ObjectTypes.view) {
                        query.append(" and table_type='VIEW' order by table_name");
                    } else {
                        query.append(" order by table_type,table_name");
                    }
                    break block30;
                }
                if (DatabaseTypes.SqlServer == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 Sql Server \u6570\u636e\u5e93\u8868 ");
                    }
                    if (DBUtil.isSqlServer2000(con)) {
                        query.append("select s.name table_name,p.value comments,s.type table_type from sysobjects s ");
                        query.append(" left join sysproperties p on s.id=p.id and p.smallid=0 ");
                        query.append(" where s.name<>'dtproperties' and s.name not like 'sys%' and ");
                        if (type == ObjectTypes.table) {
                            query.append(" s.type='U' order by s.name");
                        } else if (type == ObjectTypes.view) {
                            query.append(" s.type='V' order by s.name");
                        } else {
                            query.append("(s.type='U' or s.type='V') order by s.type,s.name");
                        }
                    } else if (type == ObjectTypes.table) {
                        query.append("select a.name table_name,b.value comments,'table' table_type ");
                        query.append(" from sys.tables a left join sys.extended_properties b ");
                        query.append(" on b.minor_id=0 and a.object_id=b.major_id order by a.name");
                    } else if (type == ObjectTypes.view) {
                        query.append("select name table_name,name comments,'view' table_type from sys.views");
                    } else {
                        query.append("select * from (");
                        query.append("select a.name table_name,'table' table_type,b.value comments");
                        query.append(" from sys.tables a left join sys.extended_properties b ");
                        query.append(" on b.minor_id=0 and a.object_id=b.major_id ");
                        query.append(" union ");
                        query.append(" select name table_name,'view' table_type,name comments ");
                        query.append(" from sys.views");
                        query.append(")c order by table_type,table_name");
                    }
                    break block30;
                }
                String string = null;
                return string;
            }
            catch (SQLException e) {
                String string = null;
                return string;
            }
            finally {
                if (usedAutoClose) {
                    DBUtil.closeAll(null, null, con);
                }
            }
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQueryAllTablesSql(Connection con, ObjectTypes type, String owner, boolean usedAutoClose) {
        StringBuilder query;
        block30: {
            query = new StringBuilder();
            try {
                DatabaseTypes dbType = DBUtil.getDbType(con);
                if (DatabaseTypes.Oracle == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 Oracle \u6570\u636e\u5e93\u7528\u6237 {} \u6388\u6743\u8868\u548c\u89c6\u56fe ", (Object)owner);
                    }
                    query.append("select a.table_name,a.table_type,nvl(comments,a.table_name) comments");
                    query.append(" from all_tab_comments a,user_tab_privs b ");
                    query.append(" where a.owner=b.owner and b.owner=upper(?) and a.table_name=b.table_name");
                    if (type == ObjectTypes.table) {
                        query.append(" and upper(a.table_type)='TABLE'");
                        query.append(" ORDER BY a.table_name");
                    } else if (type == ObjectTypes.view) {
                        query.append(" and upper(a.table_type)='VIEW'");
                        query.append(" ORDER BY a.table_name");
                    } else {
                        query.append(" ORDER BY a.table_type,a.table_name");
                    }
                    break block30;
                }
                if (DatabaseTypes.MySql == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 MySql \u6570\u636e\u5e93 {} \u6388\u6743\u8868\u548c\u89c6\u56fe ", (Object)owner);
                    }
                    query.append("select table_name,table_comment as comments,table_type from information_schema.tables where ");
                    query.append(" table_schema=lower(?)");
                    if (type == ObjectTypes.table) {
                        query.append(" and table_type='BASE TABLE' order by table_name ");
                    } else if (type == ObjectTypes.view) {
                        query.append(" and table_type='VIEW' order by table_name");
                    } else {
                        query.append(" order by table_type,table_name");
                    }
                    break block30;
                }
                if (DatabaseTypes.SqlServer == dbType) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("== \u83b7\u53d6 Sql Server \u6570\u636e\u5e93\u8868 ");
                    }
                    if (DBUtil.isSqlServer2000(con)) {
                        query.append("select s.name table_name,p.value comments,s.type table_type from sysobjects s ");
                        query.append(" left join sysproperties p on s.id=p.id and p.smallid=0 ");
                        query.append(" where s.name<>'dtproperties' and s.name not like 'sys%' and ");
                        if (type == ObjectTypes.table) {
                            query.append(" s.type='U' order by s.name");
                        } else if (type == ObjectTypes.view) {
                            query.append(" s.type='V' order by s.name");
                        } else {
                            query.append("(s.type='U' or s.type='V') order by s.type,s.name");
                        }
                    } else if (type == ObjectTypes.table) {
                        query.append("select a.name table_name,b.value comments,'table' table_type ");
                        query.append(" from sys.tables a left join sys.extended_properties b ");
                        query.append(" on b.minor_id=0 and a.object_id=b.major_id order by a.name");
                    } else if (type == ObjectTypes.view) {
                        query.append("select name table_name,name comments,'view' table_type from sys.views");
                    } else {
                        query.append("select * from (");
                        query.append("select a.name table_name,'table' table_type,b.value comments");
                        query.append(" from sys.tables a left join sys.extended_properties b ");
                        query.append(" on b.minor_id=0 and a.object_id=b.major_id ");
                        query.append(" union ");
                        query.append(" select name table_name,'view' table_type,name comments ");
                        query.append(" from sys.views");
                        query.append(")c order by table_type,table_name");
                    }
                    break block30;
                }
                String string = null;
                return string;
            }
            catch (SQLException e) {
                String string = null;
                return string;
            }
            finally {
                if (usedAutoClose) {
                    DBUtil.closeAll(null, null, con);
                }
            }
        }
        return query.toString();
    }

    public String getQueryAllTablesSql() {
        String query = DBUtil.getQueryAllTablesSql(pool.getConnection(this.dsID), ObjectTypes.table, true);
        return query;
    }

    public static void closeAll(ResultSet rs, Statement smt, Connection con) {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (smt != null) {
                smt.close();
                smt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
                con = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isSqlServer2000(Connection conn) {
        if (conn == null) {
            return false;
        }
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            return dbmd.getDatabaseMajorVersion() == 8;
        }
        catch (SQLException e) {
            log4j.error("\u5224\u65adSqlServer\u7248\u672c\u65f6\u5f02\u5e38\uff1a" + e.getErrorCode() + "," + e.getMessage());
            return false;
        }
    }

    private static String getNoSql2KQuerySql(String srcSql, int startRowIndex, int endRowIndex) {
        String sql = "select * from (select row_number()over(order by tempcolumn) temprownumber,* from (select top #END_ROW_IDX tempcolumn=0,#QUERY_COLUMNS from #AFTER_FROM_SQL )t)tt where temprownumber > #START_ROW_IDX";
        int selectIdx = -1;
        int fromIdx = -1;
        Matcher m = CASE_INSENSITIVE_PATTERN_SELECT.matcher(srcSql);
        if (m.find()) {
            selectIdx = m.end();
        }
        if ((m = CASE_INSENSITIVE_PATTERN_FROM.matcher(srcSql)).find()) {
            fromIdx = m.end();
        }
        String columns = srcSql.substring(selectIdx, fromIdx - 4);
        if (log4j.isDebugEnabled()) {
            log4j.debug("columns={}", (Object)columns);
        }
        String afterFromSql = srcSql.substring(fromIdx);
        if (log4j.isDebugEnabled()) {
            log4j.debug("afterFromSql={}", (Object)afterFromSql);
        }
        sql = sql.replace("#QUERY_COLUMNS", columns);
        sql = sql.replace("#AFTER_FROM_SQL", afterFromSql);
        sql = sql.replace("#END_ROW_IDX", String.valueOf(endRowIndex));
        sql = sql.replace("#START_ROW_IDX", String.valueOf(startRowIndex));
        if (log4j.isDebugEnabled()) {
            log4j.debug(sql);
        }
        return sql;
    }

    private static Table.Types getTableType(String tableType) {
        String type = "view";
        if ("TABLE".equalsIgnoreCase(tableType) || "BASE TABLE".equals(tableType) || "U".equals(tableType)) {
            type = "table";
        }
        return Table.Types.valueOf(type);
    }

    private static DatabaseTypes getDbType(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            String name = conn.getMetaData().getDatabaseProductName();
            if (log4j.isDebugEnabled()) {
                log4j.debug("ProductName={}", (Object)name);
            }
            if ((name = name.toLowerCase()).indexOf("oracle") > -1) {
                return DatabaseTypes.Oracle;
            }
            if (name.indexOf("mysql") > -1) {
                return DatabaseTypes.MySql;
            }
            if (name.indexOf("microsoft") > -1) {
                return DatabaseTypes.SqlServer;
            }
        }
        catch (SQLException e) {
            log4j.error("\u5206\u6790\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff1a" + e.getErrorCode() + "," + e.getMessage());
            throw e;
        }
        return null;
    }

    private static String binaryToBase64(byte[] bytes) {
        String base64 = "";
        if (bytes != null) {
            base64 = encoder.encode(bytes);
        }
        return base64;
    }

    private static String blobToBase64(Blob blob) throws SQLException {
        if (log4j.isDebugEnabled()) {
            log4j.debug("...\u53d1\u73b0BLOB\u5b57\u6bb5");
        }
        String base64 = "";
        if (blob != null) {
            byte[] bts = blob.getBytes(1L, (int)blob.length());
            if (log4j.isDebugEnabled()) {
                log4j.debug("...BLOB\u957f\u5ea6\uff1a{}", (Object)bts.length);
            }
            base64 = encoder.encode(bts);
        }
        return base64;
    }

    private static HashMap<String, String> getRow(ResultSet rs, String dateFormat) throws SQLException {
        HashMap<String, String> row = new HashMap<String, String>();
        SimpleDateFormat sdf = HelpFunction.getSimpleDateFormat(dateFormat);
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u67e5\u8be2\u7684\u5b57\u6bb5\u6570\uff1a{}", (Object)cols);
        }
        block5: for (int x = 0; x < cols; ++x) {
            int colIdx = x + 1;
            int colType = rsmd.getColumnType(colIdx);
            String colName = rsmd.getColumnLabel(colIdx);
            colName = colName.toLowerCase();
            if (log4j.isDebugEnabled()) {
                log4j.debug(colName + " \u5b57\u6bb5\u7684 java.sql.Types \u7c7b\u578b\uff1a{}", (Object)colType);
            }
            switch (colType) {
                case -4: {
                    byte[] data;
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("\u5904\u7406 long raw \u5b57\u6bb5");
                    }
                    if ((data = DBUtil.getBinaryColumnValue(rs, colName)) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, DBUtil.binaryToBase64(data));
                    continue block5;
                }
                case 2004: {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("\u5904\u7406 blob \u5b57\u6bb5");
                    }
                    if (rs.getBlob(colIdx) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, DBUtil.blobToBase64(rs.getBlob(colIdx)));
                    continue block5;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (rs.getTimestamp(colIdx) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, sdf.format(rs.getTimestamp(colIdx)));
                    continue block5;
                }
                default: {
                    if (rs.getString(colIdx) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, rs.getString(colIdx));
                }
            }
        }
        return row;
    }

    private static HashMap<String, String> getRow(ResultSet rs, HashMap<String, String> dateFormat) throws SQLException {
        HashMap<String, String> row = new HashMap<String, String>();
        SimpleDateFormat sdf = null;
        boolean dfIsNull = false;
        if (HelpFunction.isEmpty(dateFormat)) {
            dfIsNull = true;
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        if (log4j.isDebugEnabled()) {
            log4j.debug("\u67e5\u8be2\u7684\u5b57\u6bb5\u6570\uff1a{}", (Object)cols);
        }
        block5: for (int x = 0; x < cols; ++x) {
            int colIdx = x + 1;
            int colType = rsmd.getColumnType(colIdx);
            String colName = rsmd.getColumnLabel(colIdx);
            colName = colName.toLowerCase();
            if (log4j.isDebugEnabled()) {
                log4j.debug(colName + " \u5b57\u6bb5\u7684 java.sql.Types \u7c7b\u578b\uff1a{}", (Object)colType);
            }
            switch (colType) {
                case -4: {
                    byte[] data;
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("\u5904\u7406 long raw \u5b57\u6bb5");
                    }
                    if ((data = DBUtil.getBinaryColumnValue(rs, colName)) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, DBUtil.binaryToBase64(data));
                    continue block5;
                }
                case 2004: {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug("\u5904\u7406 blob \u5b57\u6bb5");
                    }
                    if (rs.getBlob(colIdx) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, DBUtil.blobToBase64(rs.getBlob(colIdx)));
                    continue block5;
                }
                case 91: 
                case 92: 
                case 93: {
                    Timestamp dt = rs.getTimestamp(colIdx);
                    if (dt == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    if (dfIsNull) {
                        row.put(colName, sdf.format(dt));
                        continue block5;
                    }
                    row.put(colName, HelpFunction.getSimpleDateFormat(dateFormat.get(colName)).format(dt));
                    continue block5;
                }
                default: {
                    if (rs.getString(colIdx) == null) {
                        row.put(colName, "");
                        continue block5;
                    }
                    row.put(colName, rs.getString(colIdx));
                }
            }
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBinaryColumnValue(ResultSet rs, String colName) {
        InputStream is = null;
        ByteArrayOutputStream bout = null;
        try {
            is = rs.getBinaryStream(colName);
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            bout = new ByteArrayOutputStream();
            byte[] arr = new byte[2048];
            int len = 0;
            while ((len = is.read(arr)) != -1) {
                bout.write(arr, 0, len);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log4j.error("\u8bfb\u53d6\u6d41\u5b57\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
            is = null;
            bout = null;
        }
        return null;
    }

    public static enum DatabaseTypes {
        Oracle,
        MySql,
        SqlServer;

    }

    public static enum ObjectTypes {
        table,
        view,
        all;

    }
}

