/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.db;

import com.xdja.basecode.util.HelpFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static final Logger log = LoggerFactory.getLogger(HibernateUtil.class);
    private SessionFactory sf;

    public SessionFactory getSf() {
        return this.sf;
    }

    public void setSf(SessionFactory sf) {
        this.sf = sf;
    }

    public org.hibernate.Session getSession() {
        return this.sf.openSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addBean(Object obj) {
        if (obj == null) {
            log.warn("\u4e0d\u80fd\u4fdd\u5b58\u7a7a\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                se.save(obj);
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u4fdd\u5b58\u5bf9\u8c61" + obj.getClass().getSimpleName() + "\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBeans(Object[] objs) {
        if (objs == null || objs.length == 0) {
            log.warn("\u4e0d\u80fd\u4fdd\u5b58\u7a7a\u6570\u7ec4\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                for (int i = 0; i < objs.length; ++i) {
                    Object obj = objs[i];
                    if (obj == null) {
                        throw new HibernateException("\u7b2c " + (i + 1) + " \u5bf9\u8c61\u4e3a\u7a7a");
                    }
                    se.save(obj);
                }
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u4fdd\u5b58\u5bf9\u8c61\u7ec4\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBean(Object obj) {
        if (obj == null) {
            log.warn("\u4e0d\u80fd\u66f4\u65b0\u7a7a\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                se.update(obj);
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u66f4\u65b0\u5bf9\u8c61" + obj.getClass().getSimpleName() + "\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBeans(Object[] objs) {
        if (objs == null || objs.length == 0) {
            log.warn("\u4e0d\u80fd\u66f4\u65b0\u7a7a\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                for (int i = 0; i < objs.length; ++i) {
                    Object obj = objs[i];
                    if (obj == null) {
                        throw new HibernateException("\u7b2c " + (i + 1) + " \u5bf9\u8c61\u4e3a\u7a7a");
                    }
                    se.update(obj);
                }
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u66f4\u65b0\u5bf9\u8c61\u7ec4\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addOrUpdate(Object obj) {
        if (obj == null) {
            log.warn("\u4e0d\u80fd\u4fdd\u5b58\u7a7a\u5bf9\u8c61");
            return null;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                se.saveOrUpdate(obj);
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u4fdd\u5b58\u5bf9\u8c61" + obj.getClass().getSimpleName() + "\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delBean(Object obj) {
        if (obj == null) {
            log.warn("\u4e0d\u80fd\u5220\u9664\u7a7a\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                se.delete(obj);
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u5220\u9664\u5bf9\u8c61" + obj.getClass().getSimpleName() + "\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delBean(Object[] objs) {
        if (HelpFunction.isEmpty(objs)) {
            log.warn("\u4e0d\u80fd\u5220\u9664\u7a7a\u5bf9\u8c61\u6570\u7ec4");
            return false;
        }
        Session se = null;
        Transaction tc = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                tc = se.beginTransaction();
                for (Object obj : objs) {
                    se.delete(obj);
                }
                tc.commit();
            }
        }
        catch (HibernateException e) {
            log.error("\u5220\u9664\u591a\u4e2a\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (tc != null) {
                    tc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return true;
    }

    public int executeHql(String hqlName) {
        return this.executeHql(new String[]{hqlName}, (Object[][])null);
    }

    public int executeHql(String hqlName, Object[] params) {
        return this.executeHql(new String[]{hqlName}, new Object[][]{params});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeHql(String[] hqlNames, Object[][] paramValues) {
        if (HelpFunction.isEmpty(hqlNames) || HelpFunction.isEmpty((Object[])paramValues)) {
            log.error("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684HQL\u8bed\u53e5\u548c\u53c2\u6570\u503c");
            return -1;
        }
        ArrayList<Query> hqls = new ArrayList<Query>();
        Session se = null;
        Transaction ts = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                int x;
                for (x = 0; x < hqlNames.length; ++x) {
                    Object[] pvs;
                    String name = hqlNames[x];
                    if (HelpFunction.isEmpty(name)) {
                        log.warn("\u7b2c\u3010" + (x + 1) + "\u3011\u540d\u79f0\u4e3a\u7a7a");
                        continue;
                    }
                    Query query = se.getNamedQuery(name);
                    String hql = query.getQueryString();
                    if (HelpFunction.isEmpty(hql)) {
                        log.warn("\u540d\u79f0\u3010" + name + "\u3011\u5bf9\u5e94\u7684hql\u8bed\u53e5\u4e3a\u7a7a");
                        continue;
                    }
                    if (!HelpFunction.isEmpty((Object[])paramValues) && !HelpFunction.isEmpty(pvs = paramValues[x])) {
                        for (int y = 0; y < pvs.length; ++y) {
                            query.setParameter(y, pvs[y]);
                        }
                    }
                    hqls.add(query);
                }
                if (hqls.isEmpty()) {
                    log.warn("\u6ca1\u6709\u63d0\u4f9b\u4efb\u4f55\u6709\u6548HQL\u8bed\u53e5");
                    x = -1;
                    return x;
                }
                ts = se.beginTransaction();
                int total = 0;
                for (Query sq : hqls) {
                    total += sq.executeUpdate();
                }
                ts.commit();
                int n = total;
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u6279\u91cf\u6267\u884c\u5df2\u547d\u540dHQL\u8bed\u53e5\u3010" + HelpFunction.arrToString(hqlNames) + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (ts != null) {
                    ts.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeHql(String hqlName, String[] paramNames, Object[] paramValues) {
        if (HelpFunction.isEmpty(hqlName)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684HQL\u8bed\u53e5\u540d\u79f0");
            return -1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                Query query = se.getNamedQuery(hqlName);
                if (!HelpFunction.isEmpty(paramNames)) {
                    for (int i = 0; i < paramNames.length; ++i) {
                        query.setParameter(paramNames[i], paramValues[i]);
                    }
                }
                int n = query.executeUpdate();
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dHQL[" + hqlName + "]\u6267\u884c\u8bed\u53e5\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    public int executeSql(String sqlName) {
        return this.executeSql(sqlName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSql(String[] sqlNames) {
        if (HelpFunction.isEmpty(sqlNames)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684SQL\u8bed\u53e5\u540d\u79f0");
            return -1;
        }
        ArrayList<SQLQuery> sqls = new ArrayList<SQLQuery>();
        Session se = null;
        Transaction ts = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                int x;
                Query query = null;
                for (x = 0; x < sqlNames.length; ++x) {
                    String name = sqlNames[x];
                    if (HelpFunction.isEmpty(name)) {
                        log.warn("\u7b2c\u3010" + (x + 1) + "\u3011\u540d\u79f0\u4e3a\u7a7a");
                        continue;
                    }
                    query = se.getNamedQuery(name);
                    String sql = query.getQueryString();
                    if (HelpFunction.isEmpty(sql)) {
                        log.warn("\u540d\u79f0\u3010" + name + "\u3011\u5bf9\u5e94\u7684sql\u8bed\u53e5\u4e3a\u7a7a");
                        continue;
                    }
                    SQLQuery sqlQuery = se.createSQLQuery(sql);
                    sqls.add(sqlQuery);
                }
                query = null;
                if (sqls.isEmpty()) {
                    log.warn("\u6ca1\u6709\u63d0\u4f9b\u4efb\u4f55\u6709\u6548SQL\u8bed\u53e5");
                    x = -1;
                    return x;
                }
                ts = se.beginTransaction();
                int total = 0;
                for (SQLQuery sq : sqls) {
                    total += sq.executeUpdate();
                }
                ts.commit();
                int n = total;
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u6279\u91cf\u6267\u884c\u5df2\u547d\u540dSQL\u8bed\u53e5\u3010" + HelpFunction.arrToString(sqlNames) + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (ts != null) {
                    ts.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSql(String[] sqlNames, Object[][] paramValues) {
        if (HelpFunction.isEmpty(sqlNames)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684SQL\u8bed\u53e5");
            return -1;
        }
        ArrayList<SQLQuery> sqls = new ArrayList<SQLQuery>();
        Session se = null;
        Transaction ts = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                int x;
                Query query = null;
                for (x = 0; x < sqlNames.length; ++x) {
                    String name = sqlNames[x];
                    if (HelpFunction.isEmpty(name)) {
                        log.warn("\u7b2c\u3010" + (x + 1) + "\u3011\u540d\u79f0\u4e3a\u7a7a");
                        continue;
                    }
                    query = se.getNamedQuery(name);
                    String sql = query.getQueryString();
                    if (HelpFunction.isEmpty(sql)) {
                        log.warn("\u540d\u79f0\u3010" + name + "\u3011\u5bf9\u5e94\u7684sql\u8bed\u53e5\u4e3a\u7a7a");
                        continue;
                    }
                    SQLQuery sqlQuery = se.createSQLQuery(sql);
                    Object[] pvs = paramValues[x];
                    for (int y = 0; y < pvs.length; ++y) {
                        sqlQuery.setParameter(y, pvs[y]);
                    }
                    sqls.add(sqlQuery);
                }
                query = null;
                if (sqls.isEmpty()) {
                    log.warn("\u6ca1\u6709\u63d0\u4f9b\u4efb\u4f55\u6709\u6548SQL\u8bed\u53e5");
                    x = -1;
                    return x;
                }
                ts = se.beginTransaction();
                int total = 0;
                for (SQLQuery sq : sqls) {
                    total += sq.executeUpdate();
                }
                ts.commit();
                int n = total;
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u6279\u91cf\u6267\u884c\u5df2\u547d\u540dSQL\u8bed\u53e5\u3010" + HelpFunction.arrToString(sqlNames) + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (ts != null) {
                    ts.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeOriginalitySql(String[] sqls, Object[][] paramValues) {
        if (HelpFunction.isEmpty(sqls)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684SQL\u8bed\u53e5");
            return -1;
        }
        ArrayList<SQLQuery> sqlList = new ArrayList<SQLQuery>();
        Session se = null;
        Transaction ts = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                int x;
                for (x = 0; x < sqls.length; ++x) {
                    String sql = sqls[x];
                    if (HelpFunction.isEmpty(sql)) {
                        log.warn("\u7b2c\u3010" + (x + 1) + "\u3011\u6761sql\u8bed\u53e5\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                        continue;
                    }
                    SQLQuery sqlQuery = se.createSQLQuery(sql);
                    Object[] pvs = paramValues[x];
                    for (int y = 0; y < pvs.length; ++y) {
                        sqlQuery.setParameter(y, pvs[y]);
                    }
                    sqlList.add(sqlQuery);
                }
                if (sqlList.isEmpty()) {
                    log.warn("\u6ca1\u6709\u63d0\u4f9b\u4efb\u4f55\u6709\u6548SQL\u8bed\u53e5");
                    x = -1;
                    return x;
                }
                ts = se.beginTransaction();
                int total = 0;
                for (SQLQuery sq : sqlList) {
                    total += sq.executeUpdate();
                }
                ts.commit();
                int n = total;
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u6279\u91cf\u6267\u884c\u539f\u59cbSQL\u8bed\u53e5\u7ec4\u5931\u8d25\uff1a" + e.getMessage());
            try {
                if (ts != null) {
                    ts.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSql(String sqlName, Object[] paramValues) {
        if (HelpFunction.isEmpty(sqlName)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684SQL\u8bed\u53e5\u540d\u79f0");
            return -1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                Query query = se.getNamedQuery(sqlName);
                SQLQuery sqlQuery = se.createSQLQuery(query.getQueryString());
                query = null;
                if (!HelpFunction.isEmpty(paramValues)) {
                    for (int i = 0; i < paramValues.length; ++i) {
                        sqlQuery.setParameter(i, paramValues[i]);
                    }
                }
                int n = sqlQuery.executeUpdate();
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dSQL[" + sqlName + "]\u6267\u884c\u8bed\u53e5\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSql(String sqlName, String[] paramNames, Object[] paramValues) {
        if (HelpFunction.isEmpty(sqlName)) {
            log.warn("\u8bf7\u63d0\u4f9b\u6709\u6548\u7684SQL\u8bed\u53e5\u540d\u79f0");
            return -1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            if (se != null) {
                Query query = se.getNamedQuery(sqlName);
                SQLQuery sqlQuery = se.createSQLQuery(query.getQueryString());
                query = null;
                if (!HelpFunction.isEmpty(paramNames)) {
                    for (int i = 0; i < paramNames.length; ++i) {
                        sqlQuery.setParameter(paramNames[i], paramValues[i]);
                    }
                }
                int n = sqlQuery.executeUpdate();
                return n;
            }
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dSQL[" + sqlName + "]\u6267\u884c\u8bed\u53e5\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(Class<?> cls, Serializable id) {
        if (cls == null) {
            log.warn("\u4e0d\u80fd\u68c0\u7d22\u7a7a\u5bf9\u8c61");
            return false;
        }
        Session se = null;
        Object obj = null;
        try {
            se = this.sf.openSession();
            obj = se.get(cls, id);
        }
        catch (HibernateException e) {
            log.error("\u67e5\u8be2\u5bf9\u8c61" + cls.getSimpleName() + "\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return obj;
    }

    public List<?> getBeansByNamedHql(String hqlName) {
        return this.getBeansByNamedHql(hqlName, null, 0, 1000);
    }

    public List<?> getBeansByNamedHql(String hqlName, Object param) {
        return this.getBeansByNamedHql(hqlName, new Object[]{param}, 0, 1000);
    }

    public List<?> getBeansByNamedHql(String hqlName, Object[] params) {
        return this.getBeansByNamedHql(hqlName, params, 0, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getBeansByNamedHql(String hqlName, Object[] params, int firstIndex, int maxRows) {
        if (hqlName == null || hqlName.trim().length() == 0) {
            log.warn("\u7a7a\u7684HQL\u540d\u79f0");
            return null;
        }
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        if (maxRows < 1) {
            maxRows = 1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            Query query = se.getNamedQuery(hqlName);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object pv = params[i];
                    query.setParameter(i, pv);
                }
            }
            query.setFirstResult(firstIndex);
            query.setMaxResults(maxRows);
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dHQL[" + hqlName + "]\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getBeansByNamedHql(String hqlName, Object[] paramNames, Object[] paramValues, int firstIndex, int maxRows) {
        if (hqlName == null || hqlName.trim().length() == 0) {
            log.warn("\u7a7a\u7684HQL\u540d\u79f0");
            return null;
        }
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        if (maxRows < 1) {
            maxRows = 1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            Query query = se.getNamedQuery(hqlName);
            if (paramNames != null && paramNames.length > 0) {
                for (int i = 0; i < paramNames.length; ++i) {
                    Object pv = paramValues[i];
                    query.setParameter((String)paramNames[i], pv);
                }
            }
            query.setFirstResult(firstIndex);
            query.setMaxResults(maxRows);
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dHQL[" + hqlName + "]\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return null;
    }

    public List<?> getBeansByNamedSql(String sqlName) {
        return this.getBeansByNamedSql(sqlName, null, 0, 1000);
    }

    public List<?> getBeansByNamedSql(String sqlName, Object[] params, String aliseName, Class<?> cls) {
        return this.getBeansByNamedSql(sqlName, params, 0, 1000, aliseName, cls);
    }

    public List<?> getBeansByNamedSql(String sqlName, Object[] params, int firstIndex, int maxRows) {
        return this.getBeansByNamedSql(sqlName, params, firstIndex, maxRows, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getBeansByNamedSql(String sqlName, Object[] params, int firstIndex, int maxRows, String aliseName, Class<?> cls) {
        if (sqlName == null || sqlName.trim().length() == 0) {
            log.warn("\u7a7a\u7684SQL\u540d\u79f0");
            return null;
        }
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        if (maxRows < 1) {
            maxRows = 1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            Query query = se.getNamedQuery(sqlName);
            SQLQuery sqlQuery = se.createSQLQuery(query.getQueryString());
            query = null;
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    sqlQuery.setParameter(i, params[i]);
                }
            }
            sqlQuery.setFirstResult(firstIndex);
            sqlQuery.setMaxResults(maxRows);
            if (!HelpFunction.isEmpty(aliseName) && cls != null) {
                sqlQuery.addEntity(aliseName, cls);
            }
            List list = sqlQuery.list();
            return list;
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dSQL[" + sqlName + "]\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getBeansByNamedSql(String sqlName, Object[] paramNames, Object[] paramValues, int firstIndex, int maxRows) {
        if (sqlName == null || sqlName.trim().length() == 0) {
            log.warn("\u7a7a\u7684SQL\u540d\u79f0");
            return null;
        }
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        if (maxRows < 1) {
            maxRows = 1;
        }
        Session se = null;
        try {
            se = this.sf.openSession();
            Query query = se.getNamedQuery(sqlName);
            SQLQuery sqlQuery = se.createSQLQuery(query.getQueryString());
            query = null;
            if (paramNames != null && paramNames.length > 0) {
                for (int i = 0; i < paramNames.length; ++i) {
                    sqlQuery.setParameter((String)paramNames[i], paramValues[i]);
                }
            }
            sqlQuery.setFirstResult(firstIndex);
            sqlQuery.setMaxResults(maxRows);
            List list = sqlQuery.list();
            return list;
        }
        catch (HibernateException e) {
            log.error("\u5229\u7528\u5df2\u547d\u540dSQL[" + sqlName + "]\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            this.release((org.hibernate.Session)se);
        }
        return null;
    }

    private void release(org.hibernate.Session se) {
        try {
            if (se != null) {
                se.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        se = null;
    }
}

