/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.db;

import com.xdja.basecode.util.HelpFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlUtil {
    public static final String[] SQL_OPERATER = new String[]{"=", ">", "<", ">=", "<=", "<>", "!=", "like", "between"};
    public static final String RETURN_REPLACE_SQL = "return_replace_sql";

    public static LinkedHashMap<String, ArrayList<String>> fetchParameterWithQmarkReplace(String sql, String[] fieldNames) throws Exception {
        if (HelpFunction.isEmpty(sql)) {
            throw new Exception("SQL\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Integer, HashMap<String, String>> idxFieldValues = new HashMap<Integer, HashMap<String, String>>();
        HashMap<String, String> fv = null;
        for (String fieldName : fieldNames) {
            sql = SqlUtil.loopCommonOper(idxFieldValues, sql, fieldName);
            Matcher matcher = null;
            String tmp = null;
            matcher = Pattern.compile("\\s*" + fieldName + "\\s*>\\s+=\\s*((\\d+)|('[^']*'))\\s*", 2).matcher(sql);
            while (matcher.find()) {
                tmp = sql.substring(matcher.start(), matcher.end());
                tmp = tmp.split(">\\s+=")[1];
                tmp = tmp.replaceAll("'", "").trim();
                fv = new HashMap<String, String>();
                fv.put(fieldName, tmp);
                idxFieldValues.put(matcher.start(), fv);
                sql = matcher.replaceFirst(" " + fieldName + " >= ? ");
            }
            matcher = Pattern.compile("\\s*" + fieldName + "\\s*<\\s+=\\s*((\\d+)|('[^']*'))\\s*", 2).matcher(sql);
            while (matcher.find()) {
                tmp = sql.substring(matcher.start(), matcher.end());
                tmp = tmp.split("<\\s+=")[1];
                tmp = tmp.replaceAll("'", "").trim();
                fv = new HashMap();
                fv.put(fieldName, tmp);
                idxFieldValues.put(matcher.start(), fv);
                sql = matcher.replaceFirst(" " + fieldName + " <= ? ");
            }
            matcher = Pattern.compile("\\s*" + fieldName + "\\s*!\\s+=\\s*((\\d+)|('[^']*'))\\s*", 2).matcher(sql);
            while (matcher.find()) {
                tmp = sql.substring(matcher.start(), matcher.end());
                tmp = tmp.split("!\\s+=")[1];
                tmp = tmp.replaceAll("'", "").trim();
                fv = new HashMap();
                fv.put(fieldName, tmp);
                idxFieldValues.put(matcher.start(), fv);
                sql = matcher.replaceFirst(" " + fieldName + " != ? ");
            }
            matcher = Pattern.compile("\\s*" + fieldName + "\\s*<\\s+>\\s*((\\d+)|('[^']*'))\\s*", 2).matcher(sql);
            while (matcher.find()) {
                tmp = sql.substring(matcher.start(), matcher.end());
                tmp = tmp.split("<\\s+>")[1];
                tmp = tmp.replaceAll("'", "").trim();
                fv = new HashMap();
                fv.put(fieldName, tmp);
                idxFieldValues.put(matcher.start(), fv);
                sql = matcher.replaceFirst(" " + fieldName + " <> ? ");
            }
        }
        LinkedHashMap<String, ArrayList<String>> values = SqlUtil.sortValues(idxFieldValues);
        ArrayList<String> al = new ArrayList<String>();
        al.add(sql);
        values.put(RETURN_REPLACE_SQL, al);
        return values;
    }

    private static String loopCommonOper(HashMap<Integer, HashMap<String, String>> idxFieldValue, String sql, String fieldName) {
        HashMap<String, String> fv = null;
        String tmp = null;
        for (String oper : SQL_OPERATER) {
            if ("between".equalsIgnoreCase(oper)) {
                sql = SqlUtil.processBetween(sql, fieldName, idxFieldValue);
                continue;
            }
            if ("like".equalsIgnoreCase(oper)) {
                sql = SqlUtil.processLike(sql, fieldName, idxFieldValue);
                continue;
            }
            Pattern p = Pattern.compile("\\b\\s*" + fieldName + "\\b\\s*" + oper + "\\s*((\\d+)|('[^']*'))\\s*", 2);
            Matcher matcher = p.matcher(sql);
            boolean has = matcher.find();
            while (has) {
                tmp = sql.substring(matcher.start(), matcher.end());
                String[] tmpArray = tmp.split(oper);
                StringBuilder sb = new StringBuilder();
                if (tmpArray != null && tmpArray.length > 0) {
                    for (int i = 1; i < tmpArray.length; ++i) {
                        sb.append(tmpArray[i]).append(oper);
                    }
                }
                tmp = sb.toString();
                tmp = tmp.substring(0, tmp.lastIndexOf(oper)).replaceAll("'", "").trim();
                fv = new HashMap<String, String>();
                fv.put(fieldName, tmp);
                idxFieldValue.put(matcher.start(), fv);
                sql = matcher.replaceFirst(" " + fieldName + " " + oper + " ? ");
                matcher = p.matcher(sql);
                has = matcher.find();
            }
        }
        return sql;
    }

    private static String processLike(String sql, String fieldName, HashMap<Integer, HashMap<String, String>> idxFieldValue) {
        Pattern p = Pattern.compile("\\s*" + fieldName + "\\s+((like)|(not\\s+like))\\s+'[^']*'\\s*", 2);
        Matcher matcher = p.matcher(sql);
        while (matcher.find()) {
            String tmp = sql.substring(matcher.start(), matcher.end());
            boolean notLike = false;
            String[] likeSplit = tmp.split("\\bnot\\s+like\\b");
            if (likeSplit.length > 1) {
                notLike = true;
            } else {
                likeSplit = tmp.split("\\blike\\b");
            }
            tmp = likeSplit[1].replace("'", "").trim();
            HashMap<String, String> fv = new HashMap<String, String>();
            fv.put(fieldName, tmp);
            idxFieldValue.put(matcher.start(), fv);
            sql = notLike ? matcher.replaceFirst(" " + fieldName + " not like ? ") : matcher.replaceFirst(" " + fieldName + " like ? ");
            matcher = p.matcher(sql);
        }
        return sql;
    }

    private static String processBetween(String sql, String fieldName, HashMap<Integer, HashMap<String, String>> idxFieldValue) {
        Pattern p = Pattern.compile("\\s*" + fieldName + "\\s+((between)|(not\\s+between))\\s+((\\d+\\s+and\\s+\\d+)|('[^']*'\\s+and\\s+'[^']*'))\\s*", 2);
        Matcher matcher = p.matcher(sql);
        while (matcher.find()) {
            String tmp = sql.substring(matcher.start(), matcher.end());
            boolean notBetween = false;
            String[] betweenSplit = tmp.split("\\bnot\\s+between\\b");
            if (betweenSplit.length > 1) {
                notBetween = true;
            } else {
                betweenSplit = tmp.split("\\bbetween\\b");
            }
            String[] arr = betweenSplit[1].split("\\band\\b");
            HashMap<String, String> fv = new HashMap<String, String>();
            fv.put(fieldName, arr[0].replaceAll("'", "").trim());
            idxFieldValue.put(matcher.start(), fv);
            fv = new HashMap();
            fv.put(fieldName, arr[1].replaceAll("'", "").trim());
            idxFieldValue.put(matcher.start() + 1, fv);
            sql = notBetween ? matcher.replaceFirst(" " + fieldName + " not between ? and ? ") : matcher.replaceFirst(" " + fieldName + " between ? and ? ");
            matcher = p.matcher(sql);
        }
        return sql;
    }

    private static LinkedHashMap<String, ArrayList<String>> sortValues(HashMap<Integer, HashMap<String, String>> idxFieldValues) {
        LinkedHashMap<String, ArrayList<String>> maps = new LinkedHashMap<String, ArrayList<String>>();
        HashMap<String, String> tmpMap = null;
        ArrayList<String> valueList = null;
        if (idxFieldValues.size() == 1) {
            tmpMap = idxFieldValues.values().iterator().next();
            String key = tmpMap.keySet().iterator().next();
            valueList = new ArrayList<String>();
            valueList.add(tmpMap.get(key));
            maps.put(key, valueList);
        } else if (idxFieldValues.size() > 1) {
            Object[] idxes = idxFieldValues.keySet().toArray(new Integer[0]);
            Arrays.sort(idxes);
            Object[] arrayOfInteger1 = idxes;
            int j = idxes.length;
            for (int i = 0; i < j; ++i) {
                int idx = (Integer)arrayOfInteger1[i];
                tmpMap = idxFieldValues.get(idx);
                String key = tmpMap.keySet().iterator().next();
                if (maps.containsKey(key)) {
                    maps.get(key).add(tmpMap.get(key));
                    continue;
                }
                valueList = new ArrayList();
                valueList.add(tmpMap.get(key));
                maps.put(key, valueList);
            }
        }
        return maps;
    }
}

