/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.image;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.util.IDCreator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class ImageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageUtil.class);
    private static BASE64Decoder decoder = new BASE64Decoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBlobToLocation(String base64Content, String saveDir, String imageName, String extendName) {
        if (HelpFunction.isEmpty(base64Content)) {
            LOGGER.error("...\u7167\u7247\u5185\u5bb9\u4e3a\u7a7a!");
            return null;
        }
        LOGGER.debug("...saveDir=" + saveDir);
        if (HelpFunction.isEmpty(saveDir)) {
            LOGGER.error("...\u8def\u5f84\u65e0\u6548!");
            return null;
        }
        File file = new File(saveDir);
        if (!file.exists()) {
            LOGGER.info("...\u4fdd\u5b58\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u6b63\u5728\u521b\u5efa...");
            try {
                file.mkdirs();
                LOGGER.info("...\u76ee\u5f55\u5df2\u521b\u5efa");
            }
            catch (Exception e) {
                LOGGER.error("...\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff0c\u65e0\u6cd5\u4fdd\u5b58\u56fe\u7247!", (Throwable)e);
                return null;
            }
        }
        String name = null;
        name = !HelpFunction.isEmpty(imageName) ? imageName : IDCreator.getInstance().getID();
        if (!HelpFunction.isEmpty(extendName)) {
            name = name + "." + extendName;
        }
        LOGGER.debug("...imageName=" + name);
        file = new File(saveDir + File.separator + name);
        LOGGER.debug("...\u9884\u521b\u5efa\u56fe\u7247\u8def\u5f84\uff1a" + file.getAbsolutePath());
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            LOGGER.error("...\u521b\u5efa\u7167\u7247\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            return null;
        }
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(decoder.decodeBuffer(base64Content));
            ((BufferedOutputStream)out).flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            LOGGER.error("...\u5199\u7167\u7247\u5185\u5bb9\u5931\u8d25\uff01", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
        }
        LOGGER.debug("...\u7167\u7247\u5df2\u521b\u5efa");
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readImage(String imageFilePath) {
        File file = new File(imageFilePath);
        if (!file.exists()) {
            LOGGER.error("\u56fe\u7247\u6587\u4ef6\u3010" + imageFilePath + "\u3011\u4e0d\u5b58\u5728");
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            byte[] data = new byte[2048];
            int dataLength = 0;
            while ((dataLength = bis.read(data)) != -1) {
                baos.write(data, 0, dataLength);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\u6587\u4ef6\u5df2\u4e0d\u5b58\u5728");
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u6587\u4ef6\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

