/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Hex;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class HelpFunction {
    private static final Logger log = LoggerFactory.getLogger(HelpFunction.class);
    private static final SimpleDateFormat fix = new SimpleDateFormat("yyyyMMddHHmmss");
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static BASE64Decoder decoder = new BASE64Decoder();
    private static final BASE64Encoder be = new BASE64Encoder();
    private static final BASE64Decoder de = new BASE64Decoder();

    public static boolean isEmpty(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        String tmp = str.trim().toLowerCase();
        if ("null".equals(tmp) || tmp.length() == 0) {
            tmp = null;
            return true;
        }
        tmp = null;
        return false;
    }

    public static boolean isEmpty(StringBuilder str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        String tmp = str.toString().trim().toLowerCase();
        if ("null".equals(tmp) || tmp.length() == 0) {
            tmp = null;
            return true;
        }
        tmp = null;
        return false;
    }

    public static boolean isEmpty(int[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentDateString() {
        SimpleDateFormat simpleDateFormat = fix;
        synchronized (simpleDateFormat) {
            return fix.format(new Date());
        }
    }

    public static String getCurrentDateString(String dateFormat) {
        String date = null;
        if (HelpFunction.isEmpty(dateFormat)) {
            return null;
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(dateFormat);
        }
        catch (IllegalArgumentException e) {
            log.error("\u8b66\u544a\uff01\u65e5\u671f\u683c\u5f0f\u65e0\u6548\uff1a" + dateFormat);
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        date = sdf.format(new Date());
        return date;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") >= 0;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") >= 0;
    }

    public static boolean isChinese(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static boolean isChinesePunctuation(char ch) {
        return ch >= '\uff01' && ch <= '\uff5e';
    }

    public static boolean isChineseOrPunctuation(char ch) {
        return HelpFunction.isChinese(ch) || HelpFunction.isChinesePunctuation(ch);
    }

    public static boolean isChinese(String str) {
        if (str == null) {
            return false;
        }
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!HelpFunction.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinesePunctuation(String str) {
        if (str == null) {
            return false;
        }
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!HelpFunction.isChinesePunctuation(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseOrPunctuation(String str) {
        if (str == null) {
            return false;
        }
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!HelpFunction.isChineseOrPunctuation(c)) continue;
            return true;
        }
        return false;
    }

    public static int getInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String value, long defValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static boolean getBoolean(String value, boolean defValue) {
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ping(String urlAddress) {
        URL url = null;
        HttpURLConnection urlConnect = null;
        try {
            url = new URL(urlAddress);
            urlConnect = (HttpURLConnection)url.openConnection();
            urlConnect.setConnectTimeout(3000);
            urlConnect.connect();
            int code = urlConnect.getResponseCode();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                if (urlConnect != null) {
                    urlConnect.disconnect();
                }
                urlConnect = null;
                url = null;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static String cutWhiteSpace(String str) {
        if (HelpFunction.isEmpty(str)) {
            return null;
        }
        StringBuilder newStr = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            newStr.append(c);
        }
        return newStr.toString();
    }

    public static String leftTrim(String str, char ch) {
        if (HelpFunction.isEmpty(str)) {
            return "";
        }
        char[] arr = str.toCharArray();
        if (arr[0] != ch) {
            return str;
        }
        int idx = 0;
        int x = 0;
        while (x < arr.length && arr[x] == ch) {
            idx = x++;
        }
        return str.substring(idx + 1);
    }

    public static String rightTrim(String str, char ch) {
        if (HelpFunction.isEmpty(str)) {
            return "";
        }
        char[] arr = str.toCharArray();
        if (arr[arr.length - 1] != ch) {
            return str;
        }
        int idx = 0;
        int x = arr.length - 1;
        while (x >= 0 && arr[x] == ch) {
            idx = x--;
        }
        return str.substring(0, idx);
    }

    public static byte[] compressData(byte[] sourceData) {
        if (sourceData == null || sourceData.length <= 0) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gzos = null;
        try {
            bos = new ByteArrayOutputStream();
            gzos = new GZIPOutputStream(bos);
            gzos.write(sourceData);
            gzos.close();
        }
        catch (IOException ex) {
            log.error("\u538b\u7f29\u5931\u8d25\uff1a" + ex.getMessage());
            return null;
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unCompressData(byte[] compressData) {
        if (compressData == null || compressData.length <= 0) {
            return null;
        }
        ByteArrayInputStream bis = null;
        OutputStream bos = null;
        GZIPInputStream gzis = null;
        try {
            bis = new ByteArrayInputStream(compressData);
            bos = new ByteArrayOutputStream();
            gzis = new GZIPInputStream(bis);
            byte[] tbyte = new byte[1024];
            int flag = -1;
            while ((flag = gzis.read(tbyte, 0, tbyte.length)) != -1) {
                ((ByteArrayOutputStream)bos).write(tbyte, 0, flag);
            }
            byte[] byArray = ((ByteArrayOutputStream)bos).toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            log.error("\u89e3\u538b\u5931\u8d25\uff1a" + ex.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                    ((ByteArrayOutputStream)bos).close();
                }
                if (gzis != null) {
                    gzis.close();
                }
            }
            catch (Exception exception) {}
            bos = null;
            gzis = null;
        }
    }

    public static void unZip(String sourceZip, String destDir) {
        log.debug("\u5f00\u59cb\u89e3\u538b\u6587\u4ef6...");
        try {
            Project project = new Project();
            Expand expand = new Expand();
            expand.setProject(project);
            expand.setSrc(new File(sourceZip));
            expand.setOverwrite(false);
            File f = new File(destDir);
            expand.setDest(f);
            expand.execute();
            log.debug("\u89e3\u538b\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u89e3\u538b\u5931\u8d25", (Throwable)e);
        }
    }

    public static void zip(String sourceFile, String targetZip) {
        log.debug("\u5f00\u59cb\u538b\u7f29\u6587\u4ef6...");
        try {
            Project prj = new Project();
            Zip zip = new Zip();
            zip.setProject(prj);
            zip.setDestFile(new File(targetZip));
            FileSet fileSet = new FileSet();
            fileSet.setProject(prj);
            fileSet.setDir(new File(sourceFile));
            zip.addFileset(fileSet);
            zip.execute();
            log.debug("\u538b\u7f29\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
    }

    public static byte[] intToBytes4(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >> 24 - i * 8);
        }
        return b;
    }

    public static int bytes4ToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static String bytesToBase64(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return encoder.encode(bytes);
    }

    public static byte[] base64ToBytes(String base64) {
        if (!HelpFunction.isEmpty(base64)) {
            try {
                return decoder.decodeBuffer(base64);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return null;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (HelpFunction.isEmpty(dateFormat)) {
            sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
        } else {
            try {
                sdf.applyPattern(dateFormat);
            }
            catch (Exception e) {
                log.error("\u6307\u5b9a\u7684\u65e5\u671f\u683c\u5f0f[" + dateFormat + "]\u9519\u8bef\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c");
                sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
            }
        }
        return sdf;
    }

    public static Date parse(String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(dateTime);
        }
        catch (Exception e) {
            log.error("" + e.getMessage());
            return null;
        }
    }

    public static Date parse(String pattern, String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            sdf.applyPattern(pattern);
            return sdf.parse(dateTime);
        }
        catch (Exception e) {
            log.error("" + e.getMessage());
            return null;
        }
    }

    public static int searchString(String[] arr, String val) {
        if (arr == null || val == null) {
            return -1;
        }
        for (int x = 0; x < arr.length; ++x) {
            if (arr[x] == null || !arr[x].equalsIgnoreCase(val)) continue;
            return x;
        }
        return -1;
    }

    public static int searchInt(int[] arr, int val) {
        if (arr == null) {
            return -1;
        }
        for (int x = 0; x < arr.length; ++x) {
            if (arr[x] != val) continue;
            return x;
        }
        return -1;
    }

    public static boolean isNumber(String strNum) {
        Pattern p;
        Matcher m;
        return strNum != null && (m = (p = Pattern.compile("[0-9]{1,}")).matcher(strNum)).matches();
    }

    public static String arrToString(String[] arr) {
        if (HelpFunction.isEmpty(arr)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (String s : arr) {
            str.append(s);
            str.append(",");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    public static String arrToString(int[] arr) {
        if (HelpFunction.isEmpty(arr)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int s : arr) {
            str.append(s);
            str.append(",");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    public static void beanToXml(Object convertBean, List<Class<?>> classes, StringBuilder appendXml) {
        Field[] fields;
        if (convertBean == null) {
            log.error("\u5f85\u8f6c\u6362\u5bf9\u8c61\u4e3a null \uff0c\u8f6c\u6362\u5931\u8d25");
            return;
        }
        if (appendXml == null) {
            log.error("\u5f85\u8ffd\u52a0XML\u4e3a null \uff0c\u8f6c\u6362\u5931\u8d25");
            return;
        }
        for (Field field : fields = convertBean.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            try {
                Object obj = field.get(convertBean);
                if (obj == null) {
                    appendXml.append("<" + name + "/>");
                    continue;
                }
                appendXml.append("<" + name + ">");
                Class<?> fcls = field.getType();
                if (HelpFunction.isStrPrimEnumOrMore(fcls)) {
                    appendXml.append(obj.toString());
                    appendXml.append("</" + name + ">");
                    continue;
                }
                if (Collection.class.isAssignableFrom(fcls)) {
                    Collection collection = (Collection)obj;
                    if (collection.isEmpty()) {
                        appendXml.append("</" + name + ">");
                        continue;
                    }
                    HelpFunction.processCollection(collection, name, classes, appendXml);
                }
                if (Map.class.isAssignableFrom(fcls)) {
                    Map map = (Map)obj;
                    if (map.isEmpty()) {
                        appendXml.append("</" + name + ">");
                        continue;
                    }
                    HelpFunction.processKeyValue(map, obj, classes, appendXml);
                }
                for (Class<?> cls : classes) {
                    if (!fcls.getCanonicalName().equals(cls.getCanonicalName())) continue;
                    HelpFunction.beanToXml(obj, classes, appendXml);
                    break;
                }
                appendXml.append("</" + name + ">");
            }
            catch (IllegalArgumentException e) {
                log.error("\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.error("\u8bbf\u95ee\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private static void processCollection(Collection<Class<?>> collection, String name, List<Class<?>> classes, StringBuilder appendXml) {
        Object[] tlist = collection.toArray();
        for (int x = 0; x < tlist.length; ++x) {
            Object bt = tlist[x];
            if (bt == null) {
                if (x >= tlist.length - 1) continue;
                appendXml.append("</" + name + ">");
                appendXml.append("<" + name + ">");
                continue;
            }
            if (HelpFunction.isStrPrimEnumOrMore(bt.getClass())) {
                appendXml.append(bt.toString());
            } else {
                HelpFunction.beanToXml(bt, classes, appendXml);
            }
            if (x >= tlist.length - 1) continue;
            appendXml.append("</" + name + ">");
            appendXml.append("<" + name + ">");
        }
    }

    private static void processKeyValue(Map<?, ?> map, Object obj, List<Class<?>> classes, StringBuilder appendXml) {
        Object key = null;
        Object value = null;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            appendXml.append("<entry>");
            key = entry.getKey();
            if (key != null) {
                appendXml.append("<key>");
                appendXml.append(key.toString());
                appendXml.append("</key>");
            }
            appendXml.append("<value>");
            value = entry.getValue();
            if (value == null) {
                appendXml.append("</value>");
                appendXml.append("</entry>");
                continue;
            }
            if (HelpFunction.isStrPrimEnumOrMore(value.getClass())) {
                appendXml.append(value.toString());
                appendXml.append("</value>");
            } else {
                HelpFunction.beanToXml(value, classes, appendXml);
            }
            appendXml.append("</entry>");
        }
    }

    public static void beanToXml(Object convertBean, List<Class<?>> classes, Element appendElement) {
        Field[] fields;
        if (convertBean == null) {
            log.error("\u5f85\u8f6c\u6362\u5bf9\u8c61\u4e3a null \uff0c\u8f6c\u6362\u5931\u8d25");
            return;
        }
        if (appendElement == null) {
            log.error("\u5f85\u8ffd\u52a0\u5143\u7d20\u8282\u70b9\u4e3a null \uff0c\u8f6c\u6362\u5931\u8d25");
            return;
        }
        block4: for (Field field : fields = convertBean.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            try {
                Element node = appendElement.addElement(name);
                Object obj = field.get(convertBean);
                if (obj == null) continue;
                Class<?> fcls = field.getType();
                if (HelpFunction.isStrPrimEnumOrMore(fcls)) {
                    node.setText(obj.toString());
                    continue;
                }
                if (Collection.class.isAssignableFrom(fcls)) {
                    Collection collection = (Collection)obj;
                    if (collection.isEmpty()) continue;
                    HelpFunction.processCollection(collection, name, classes, appendElement, node);
                }
                if (Map.class.isAssignableFrom(fcls)) {
                    Map map = (Map)obj;
                    if (map.isEmpty()) continue;
                    HelpFunction.processKeyValue(map, classes, node);
                }
                for (Class<?> cls : classes) {
                    if (!fcls.getCanonicalName().equals(cls.getCanonicalName())) continue;
                    HelpFunction.beanToXml(obj, classes, node);
                    continue block4;
                }
            }
            catch (IllegalArgumentException e) {
                log.error("\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.error("\u8bbf\u95ee\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private static void processKeyValue(Map<?, ?> map, List<Class<?>> classes, Element node) {
        Object key = null;
        Object value = null;
        for (Map.Entry<?, ?> temp : map.entrySet()) {
            Element entry = node.addElement("entry");
            key = temp.getKey();
            if (key != null) {
                entry.addElement("key").setText(key.toString());
            }
            Element val = entry.addElement("value");
            value = temp.getValue();
            if (value == null) continue;
            if (HelpFunction.isStrPrimEnumOrMore(value.getClass())) {
                val.setText(value.toString());
                continue;
            }
            HelpFunction.beanToXml(value, classes, val);
        }
    }

    private static void processCollection(Collection<Class<?>> collection, String name, List<Class<?>> classes, Element appendElement, Element node) {
        Object[] tlist = collection.toArray();
        for (int x = 0; x < tlist.length; ++x) {
            Object bt = tlist[x];
            if (bt == null) {
                if (x >= tlist.length - 1) continue;
                appendElement.addElement(name);
                continue;
            }
            if (HelpFunction.isStrPrimEnumOrMore(bt.getClass())) {
                node.setText(bt.toString());
            } else {
                HelpFunction.beanToXml(bt, classes, node);
            }
            if (x >= tlist.length - 1) continue;
            node = appendElement.addElement(name);
        }
    }

    private static boolean isStrPrimEnumOrMore(Class<?> cls) {
        return cls.getCanonicalName().equals(String.class.getCanonicalName()) || cls.isPrimitive() || Enum.class.isAssignableFrom(cls);
    }

    public static boolean isNumeric(String str) {
        if (str != null && !"".equals(str)) {
            return Pattern.compile("\\d*").matcher(str).matches();
        }
        return false;
    }

    public static boolean validatePower(String userpower, String typepower) {
        return userpower != null && typepower != null && userpower.length() > typepower.length() && userpower.indexOf(typepower) != -1;
    }

    public static String SFZ15TO18(String idCardNo15) {
        int century = 19;
        String centuryStr = "" + century;
        if (century < 0 || centuryStr.length() != 2) {
            throw new IllegalArgumentException("\u4e16\u7eaa\u6570\u65e0\u6548\uff01\u5e94\u8be5\u662f\u4e24\u4f4d\u7684\u6b63\u6574\u6570\u3002");
        }
        if (!HelpFunction.isIdCardNo(idCardNo15) || idCardNo15.length() != 15) {
            throw new IllegalArgumentException("\u65e7\u7684\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        int[] weight = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        String newNoBody = idCardNo15.substring(0, 6) + centuryStr + idCardNo15.substring(6);
        int checkSum = 0;
        for (int i = 0; i < 17; ++i) {
            int ai = Integer.parseInt("" + newNoBody.charAt(i));
            checkSum += ai * weight[i];
        }
        int checkNum = checkSum % 11;
        String checkChar = null;
        switch (checkNum) {
            case 0: {
                checkChar = "1";
                break;
            }
            case 1: {
                checkChar = "0";
                break;
            }
            case 2: {
                checkChar = "X";
                break;
            }
            default: {
                checkChar = "" + (12 - checkNum);
            }
        }
        return newNoBody + checkChar;
    }

    public static String SFZ18TO15(String idCardNo18) {
        if (!HelpFunction.isIdCardNo(idCardNo18) || idCardNo18.length() != 18) {
            throw new IllegalArgumentException("\u8eab\u4efd\u8bc1\u53f7\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        return idCardNo18.substring(0, 6) + idCardNo18.substring(8, 17);
    }

    public static boolean isIdCardNo(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len != 15 && len != 18) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            try {
                Integer.parseInt("" + str.charAt(i));
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static synchronized int getNodePoint(Node xn, String tagname) {
        int point = -1;
        try {
            for (int i = 0; i < xn.getChildNodes().getLength(); ++i) {
                Node no = xn.getChildNodes().item(i);
                if (no.getNodeType() != 1 || !no.getFirstChild().getNodeValue().equalsIgnoreCase(tagname)) continue;
                point = i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return point;
    }

    public static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String strToBase64(String str) {
        if (!HelpFunction.isEmpty(str)) {
            try {
                return be.encode(str.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }

    public static String base64ToStr(String base64) {
        if (!HelpFunction.isEmpty(base64)) {
            try {
                return new String(de.decodeBuffer(base64), "UTF-8");
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }

    public static String byteTobase64str(byte[] b) {
        if (b != null && b.length > 0) {
            return be.encode(b);
        }
        return null;
    }

    public static byte[] base64strTobyte(String base64str) {
        if (base64str != null && base64str.length() > 0) {
            try {
                return de.decodeBuffer(base64str);
            }
            catch (IOException ex) {
                log.error("base64\u5b57\u7b26\u4e32\u8f6c\u5b57\u8282\u5931\u8d25\uff1a" + ex.getMessage());
            }
        }
        return null;
    }

    public static byte[] CompressData(byte[] sourcedata) {
        if (sourcedata == null || sourcedata.length <= 0) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gzos = null;
        try {
            bos = new ByteArrayOutputStream();
            gzos = new GZIPOutputStream(bos);
            gzos.write(sourcedata);
            gzos.close();
        }
        catch (IOException ex) {
            log.error("\u538b\u7f29\u5931\u8d25\uff1a" + ex.getMessage());
            return null;
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] DeCompressData(byte[] compressdata) {
        if (compressdata == null || compressdata.length <= 0) {
            return null;
        }
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        GZIPInputStream gzis = null;
        try {
            bis = new ByteArrayInputStream(compressdata);
            bos = new ByteArrayOutputStream();
            gzis = new GZIPInputStream(bis);
            byte[] tbyte = new byte[8192];
            int flag = -1;
            while ((flag = gzis.read(tbyte, 0, tbyte.length)) != -1) {
                bos.write(tbyte, 0, flag);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            log.error("\u89e3\u538b\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (gzis != null) {
                    gzis.close();
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage());
            }
        }
    }

    public static int Bytes4ToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] IntToBytes4(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >> 24 - i * 8);
        }
        return b;
    }

    public static Document stringToXmlDocument(String xmlStr) {
        if (HelpFunction.isEmpty(xmlStr) || xmlStr.startsWith("-1")) {
            log.warn("\u5c06XML\u6587\u672c\u8f6c\u6362\u4e3aorg.w3c.dom.Document\u5931\u8d25");
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
            Document doc = db.parse(is);
            return doc;
        }
        catch (Exception ex) {
            log.error("\u8f6c\u6362XML\u6587\u6863\u5931\u8d25" + ex.getMessage());
            return null;
        }
    }

    public static byte[] FormatSocketSendData(String str) {
        if (str == null) {
            return null;
        }
        byte[] tbyte = HelpFunction.CompressData(HelpFunction.getUTF8Bytes(str));
        if (tbyte == null) {
            return null;
        }
        byte[] lenbyte = HelpFunction.IntToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        tbyte = null;
        lenbyte = null;
        return allbyte;
    }

    public static byte[] getSendData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] byteLength = HelpFunction.IntToBytes4(data.length);
        byte[] allBytes = new byte[data.length + 4];
        System.arraycopy(byteLength, 0, allBytes, 0, 4);
        System.arraycopy(data, 0, allBytes, 4, data.length);
        byteLength = null;
        return allBytes;
    }

    public static String FormatReturnXmlStr(String reqtype, String relation) {
        StringBuilder respstr = new StringBuilder();
        respstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        respstr.append("<RequestAgent>");
        respstr.append("<Type>" + reqtype + "</Type>");
        respstr.append("<Items>");
        respstr.append("<Values>");
        respstr.append("<Row>");
        respstr.append("<Data>result</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>\u67e5\u8be2\u7ed3\u679c</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>\u672a\u627e\u5230\u8bb0\u5f55!</Data>");
        respstr.append("</Row>");
        respstr.append("</Values>");
        respstr.append(relation);
        respstr.append("</Items>");
        respstr.append("</RequestAgent>");
        return respstr.toString();
    }

    public static String[] DistinctArray(String[] array) {
        if (array != null && array.length > 1) {
            int m = array.length;
            for (int i = 0; i < array.length; ++i) {
                if (i >= array.length - 1 || !array[i].equals(array[i + 1])) continue;
                array[i] = null;
                --m;
            }
            if (m == array.length) {
                return array;
            }
            String[] tmp = new String[m];
            m = 0;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                tmp[m++] = array[i];
            }
            array = null;
            return tmp;
        }
        return null;
    }

    public static String substrb(String str, int subBytes) {
        int bytes = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (bytes == subBytes) {
                return str.substring(0, i);
            }
            char c = str.charAt(i);
            if (c < '\u0100') {
                ++bytes;
                continue;
            }
            if ((bytes += 2) - subBytes != 1) continue;
            return str.substring(0, i);
        }
        return str;
    }

    public static boolean isNull(String val) {
        return val == null || "".equals(val) || "null".compareToIgnoreCase(val) == 0;
    }

    public static String nvl(String in_value, String out_value) {
        if (HelpFunction.isNull(in_value)) {
            return out_value;
        }
        return in_value;
    }

    public static String replaceAllword(String source, String pattern, String replacement) {
        String ls_ret = source;
        Matcher mc = null;
        Pattern p = null;
        int pos = 0;
        if (pattern.compareToIgnoreCase(replacement) == 0) {
            return ls_ret;
        }
        p = Pattern.compile("\\" + pattern + "\\b", 2);
        mc = p.matcher(ls_ret);
        while (pos < ls_ret.length() - 1 && mc.find(pos)) {
            ls_ret = ls_ret.substring(0, mc.start()) + replacement + ls_ret.substring(mc.end());
            pos = mc.start() + replacement.length();
            mc = p.matcher(ls_ret);
        }
        return ls_ret;
    }

    public static boolean find(String source, String pattern) {
        Matcher mc = null;
        Pattern p = null;
        p = Pattern.compile("\\" + pattern + "\\b", 2);
        mc = p.matcher(source);
        return mc.find(0);
    }

    public static String trim(String source, String pattern) {
        String ls_ret = source;
        while (ls_ret.startsWith(pattern)) {
            ls_ret = ls_ret.substring(pattern.length());
        }
        while (ls_ret.endsWith(pattern)) {
            ls_ret = ls_ret.substring(0, ls_ret.length() - pattern.length());
        }
        return ls_ret;
    }

    public static boolean checkVersion(String oldVer, String newVer) {
        int i;
        String[] news;
        if (HelpFunction.isEmpty(oldVer) || HelpFunction.isEmpty(newVer)) {
            return false;
        }
        String[] olds = oldVer.split("\\.");
        if (olds.length == (news = newVer.split("\\.")).length) {
            for (i = 0; i < olds.length; ++i) {
                try {
                    if (Integer.parseInt(news[i]) > Integer.parseInt(olds[i])) {
                        return true;
                    }
                    if (Integer.parseInt(news[i]) == Integer.parseInt(olds[i])) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        if (olds.length > news.length) {
            for (i = 0; i < news.length; ++i) {
                try {
                    if (Integer.parseInt(news[i]) > Integer.parseInt(olds[i])) {
                        return true;
                    }
                    if (Integer.parseInt(news[i]) == Integer.parseInt(olds[i])) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        if (olds.length < news.length) {
            for (i = 0; i < olds.length; ++i) {
                try {
                    if (Integer.parseInt(news[i]) > Integer.parseInt(olds[i])) {
                        return true;
                    }
                    if (Integer.parseInt(news[i]) == Integer.parseInt(olds[i])) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static String getSHA256Str(String str) {
        String encdeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static void main(String[] args) {
        System.out.println(HelpFunction.getSHA256Str("FFFF122"));
    }
}

