/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.util;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(WebServiceUtil.class);

    public static String getNamespace(String wsAddress) {
        int code;
        log.debug("\u8fdb\u5165 getNamespace()...");
        log.info("wsAddress=" + wsAddress);
        if (HelpFunction.isEmpty(wsAddress)) {
            log.error("Web\u670d\u52a1\u5730\u5740\u65e0\u6548");
            return null;
        }
        String ns = null;
        String webService = wsAddress.trim();
        if (webService.length() < 5) {
            log.error("Web\u670d\u52a1\u5730\u5740\u65e0\u6548");
            return null;
        }
        if (!"?wsdl".equalsIgnoreCase(webService.substring(webService.length() - 5))) {
            webService = webService + "?wsdl";
        }
        URL url = null;
        try {
            url = new URI(webService).toURL();
        }
        catch (MalformedURLException e) {
            log.error("\u9519\u8bef\u7684 URL\u5730\u5740", (Throwable)e);
            return null;
        }
        catch (URISyntaxException e) {
            log.error("\u89e3\u6790\u4e3aURI\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        HttpURLConnection httpConn = null;
        try {
            httpConn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            log.error("\u6253\u5f00\u8fdc\u7a0b\u5730\u5740\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        try {
            httpConn.connect();
        }
        catch (IOException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u5730\u5740\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        try {
            code = httpConn.getResponseCode();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u54cd\u5e94\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        log.debug("code=" + code);
        if (code != 200) {
            log.warn("\u8fd4\u56de\u4e86\u9519\u8bef\u7684\u72b6\u6001\u7801\uff1a" + code);
            return null;
        }
        InputStream is = null;
        try {
            is = httpConn.getInputStream();
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u8f93\u51fa\u6d41\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int length = 0;
        try {
            while ((length = is.read(data)) != -1) {
                baos.write(data, 0, length);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6wsdl\u5185\u5bb9\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        byte[] allData = baos.toByteArray();
        String xml = new String(allData);
        log.debug("wsdl=" + xml);
        Document doc = XmlHelper.getDoc(xml);
        Element root = doc.getRootElement();
        log.debug("root=" + root.getName());
        log.debug("targetNamespace=" + root.attributeValue("targetNamespace"));
        ns = root.attributeValue("targetNamespace");
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            is = null;
        }
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        baos = null;
        return ns;
    }

    public static String getNamespacePrefix(String namespace) {
        if (HelpFunction.isEmpty(namespace) || namespace.trim().length() < 10) {
            return null;
        }
        return namespace.substring(7, 10);
    }
}

