/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.xml;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.DTDEntityResolver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.STAXEventReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public final class XmlHelper {
    private static final Logger log4j = LoggerFactory.getLogger(XmlHelper.class);
    private static final String UTF8 = "UTF-8";
    public static final String ATTR_NAME_VALUE = "value";
    public static final String XML_HEADER = "<?xml version='1.0' encoding='UTF-8'?>";
    private static OutputFormat format = OutputFormat.createPrettyPrint();

    public static Document getDoc(File file) {
        if (file == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        Document doc = null;
        SAXReader reader = null;
        try {
            reader = new SAXReader();
            doc = reader.read(file);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u6587\u4ef6[" + file.getAbsolutePath() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocAsFilePath(String filePath) {
        if (filePath == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            log4j.error("\u6587\u4ef6[" + filePath + "]\u4e0d\u5b58\u5728");
            return null;
        }
        Document doc = null;
        SAXReader reader = null;
        try {
            reader = new SAXReader();
            doc = reader.read(file);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u6587\u4ef6[" + file.getAbsolutePath() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            file = null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocAsFilePath(String filePath, DTDEntityResolver dtd) {
        if (filePath == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            log4j.error("\u6587\u4ef6[" + filePath + "]\u4e0d\u5b58\u5728");
            return null;
        }
        Document doc = null;
        SAXReader reader = null;
        try {
            reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)dtd);
            reader.setValidation(true);
            doc = reader.read(file);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u6587\u4ef6[" + file.getAbsolutePath() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            file = null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocAsStax(File file) {
        if (file == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        STAXEventReader stax = null;
        Document doc = null;
        FileInputStream fis = null;
        try {
            stax = new STAXEventReader();
            fis = new FileInputStream(file);
            doc = stax.readDocument((InputStream)fis);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u6587\u4ef6[" + file.getAbsolutePath() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            fis = null;
            stax = null;
        }
        return doc;
    }

    public static Document getDoc(String xmlString) {
        if (xmlString == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        xmlString = xmlString.replaceAll("&#0;", "").replaceAll("[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]", "");
        Document doc = null;
        SAXReader reader = null;
        try {
            reader = new SAXReader();
            StringReader sr = new StringReader(xmlString);
            doc = reader.read((Reader)sr);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u5185\u5bb9\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocAsStax(String xmlString) {
        if (xmlString == null) {
            log4j.warn("\u4f20\u5165\u4e86\u7a7a\u503c\uff01");
            return null;
        }
        STAXEventReader stax = null;
        Document doc = null;
        Reader reader = null;
        try {
            stax = new STAXEventReader();
            reader = new StringReader(xmlString);
            doc = stax.readDocument(reader);
        }
        catch (Exception e) {
            log4j.error("...\u89e3\u6790XML\u5185\u5bb9\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            reader = null;
            stax = null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writerDoc(String filePath, Document doc) {
        XMLWriter writer = null;
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), UTF8));
            writer = new XMLWriter((Writer)bw, format);
            writer.write(doc);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log4j.error("...\u5199XML\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {}
            writer = null;
            bw = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writerDoc(String filePath, String xmlDoc) {
        XMLWriter writer = null;
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), UTF8));
            writer = new XMLWriter((Writer)bw);
            writer.setEscapeText(false);
            writer.write(xmlDoc);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log4j.error("...\u5199XML\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {}
            writer = null;
            bw = null;
        }
        return false;
    }

    public static Element stringToElement(String xmlSegment) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xmlSegment);
        }
        catch (Exception e) {
            log4j.error("\u683c\u5f0f\u5316xml\u7247\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
        return doc.getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXml(String xml, OutputFormat format, String charset, boolean isTrans) {
        if (format == null) {
            format = OutputFormat.createCompactFormat();
        }
        if (HelpFunction.isEmpty(charset)) {
            charset = UTF8;
        }
        format.setEncoding(charset);
        StringWriter sw = new StringWriter();
        XMLWriter xw = new XMLWriter((Writer)sw, format);
        xw.setEscapeText(isTrans);
        try {
            xw.write(xml);
            xw.flush();
            xw.close();
        }
        catch (IOException e) {
            log4j.error("-1 \u683c\u5f0f\u5316XML\u9519\u8bef" + e.getMessage());
        }
        finally {
            try {
                if (xw != null) {
                    xw.close();
                    xw = null;
                }
            }
            catch (Exception exception) {}
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXml(Node node, OutputFormat format, String charset, boolean isTrans) {
        if (format == null) {
            format = OutputFormat.createCompactFormat();
        }
        if (HelpFunction.isEmpty(charset)) {
            charset = UTF8;
        }
        format.setEncoding(charset);
        StringWriter sw = new StringWriter();
        XMLWriter xw = new XMLWriter((Writer)sw, format);
        xw.setEscapeText(isTrans);
        try {
            xw.write(node.asXML());
            xw.flush();
            xw.close();
        }
        catch (IOException e) {
            log4j.error("-1 \u683c\u5f0f\u5316XML\u9519\u8bef" + e.getMessage());
        }
        finally {
            try {
                if (xw != null) {
                    xw.close();
                    xw = null;
                }
            }
            catch (Exception exception) {}
        }
        return sw.toString();
    }

    public static String formatNodeSpace(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder newXml = new StringBuilder();
        List ns = node.selectNodes("*");
        if (ns.isEmpty()) {
            newXml.append(node.asXML());
        } else {
            Object root = null;
            root = node instanceof Document ? ((Document)node).getRootElement() : node;
            newXml.append("<" + root.getName() + ">");
            for (Node n : ns) {
                XmlHelper.loopNode(n, newXml);
            }
            newXml.append("</" + root.getName() + ">");
        }
        return newXml.toString();
    }

    public static String formatNodeSpace(String xmlSegment) {
        if (xmlSegment == null) {
            return "";
        }
        Document doc = XmlHelper.getDoc(xmlSegment);
        Element root = null;
        if (doc == null) {
            return "";
        }
        root = doc.getRootElement();
        StringBuilder newXml = new StringBuilder();
        List ns = root.selectNodes("*");
        if (ns.isEmpty()) {
            newXml.append(root.asXML());
        } else {
            if (xmlSegment.startsWith("<?xml")) {
                newXml.append(xmlSegment.substring(0, xmlSegment.indexOf("?>") + 2));
            }
            newXml.append("<" + root.getName() + ">");
            for (Node n : ns) {
                XmlHelper.loopNode(n, newXml);
            }
            newXml.append("</" + root.getName() + ">");
        }
        return newXml.toString();
    }

    public static String getValue(Node xmlNode, String xpath, String defaultValue) {
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return defaultValue;
        }
        String val = node.getText().trim();
        if (HelpFunction.isEmpty(val)) {
            return defaultValue;
        }
        return val;
    }

    public static boolean getValue(Node xmlNode, String xpath, boolean defaultValue) {
        boolean flag = defaultValue;
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684XPath\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return flag;
        }
        try {
            flag = Boolean.valueOf(node.getText().trim());
        }
        catch (Exception e) {
            flag = defaultValue;
        }
        return flag;
    }

    public static int getValue(Node xmlNode, String xpath, int defaultValue) {
        int flag = defaultValue;
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return flag;
        }
        try {
            flag = Integer.parseInt(node.getText().trim());
        }
        catch (Exception e) {
            flag = defaultValue;
        }
        return flag;
    }

    public static long getValue(Node xmlNode, String xpath, long defaultValue) {
        long flag = defaultValue;
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return flag;
        }
        try {
            flag = Long.parseLong(node.getText().trim());
        }
        catch (Exception e) {
            flag = defaultValue;
        }
        return flag;
    }

    public static float getValue(Node xmlNode, String xpath, float defaultValue) {
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return defaultValue;
        }
        float def = defaultValue;
        try {
            def = Float.valueOf(node.getText().trim()).floatValue();
        }
        catch (Exception e) {
            def = defaultValue;
        }
        return def;
    }

    public static String getAttributeValue(Node xmlNode, String xpath, String attrName, String defaultValue) {
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return defaultValue;
        }
        String val = node.valueOf("@" + attrName);
        if (HelpFunction.isEmpty(val)) {
            return defaultValue;
        }
        return val;
    }

    public static boolean getAttributeValue(Node xmlNode, String xpath, String attrName, boolean defaultValue) {
        boolean flag = defaultValue;
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684XPath\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return flag;
        }
        try {
            flag = Boolean.valueOf(node.valueOf("@" + attrName));
        }
        catch (Exception e) {
            flag = defaultValue;
        }
        return flag;
    }

    public static int getAttributeValue(Node xmlNode, String xpath, String attrName, int defaultValue) {
        int flag = defaultValue;
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return flag;
        }
        try {
            flag = Integer.valueOf(node.valueOf("@" + attrName));
        }
        catch (Exception e) {
            flag = defaultValue;
        }
        return flag;
    }

    public static float getAttributeValue(Node xmlNode, String xpath, String attrName, float defaultValue) {
        Node node = null;
        if (xmlNode == null) {
            log4j.warn(xpath + "\u5bf9\u5e94\u8282\u70b9=null");
            return defaultValue;
        }
        try {
            node = xmlNode.selectSingleNode(xpath);
        }
        catch (InvalidXPathException e) {
            node = null;
            log4j.error("...\u9519\u8bef\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\uff1a" + e.getMessage());
        }
        if (node == null) {
            log4j.warn("...\u6839\u636e\u63d0\u4f9b\u7684[" + xpath + "]\u8868\u8fbe\u5f0f\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u7d20\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u6b63\u786e\uff0c\u73b0\u5728\u542f\u7528\u9ed8\u8ba4\u503c[" + defaultValue + "]");
            return defaultValue;
        }
        float def = defaultValue;
        try {
            def = Float.valueOf(node.valueOf("@" + attrName)).floatValue();
        }
        catch (Exception e) {
            def = defaultValue;
        }
        return def;
    }

    public static boolean isCDATAValue(Node node) {
        if (node != null && !HelpFunction.isEmpty(node.getText())) {
            boolean has;
            String nv = node.asXML();
            boolean bl = has = nv.indexOf("<![CDATA[") > -1;
            if (has) {
                return true;
            }
            return nv.indexOf("&lt;![CDATA[") > -1;
        }
        return false;
    }

    public static String getCDATAElement(String elementName, String data) {
        if (HelpFunction.isEmpty(elementName)) {
            return "";
        }
        if (HelpFunction.isEmpty(data)) {
            return "<" + elementName + "/>";
        }
        Element e = null;
        try {
            e = DocumentHelper.createElement((String)elementName);
            e.setText(data);
            return e.asXML();
        }
        catch (Exception ex) {
            log4j.error(ex.getMessage());
            return "";
        }
    }

    private static void loopNode(Node node, StringBuilder newXml) {
        if (node == null || newXml == null) {
            return;
        }
        List ns = node.selectNodes("*");
        if (ns.isEmpty()) {
            newXml.append(node.asXML());
        } else {
            for (Node n : ns) {
                XmlHelper.loopNode(n, newXml);
            }
        }
    }

    static {
        format.setEncoding(UTF8);
    }
}

