/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.yc;

import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import com.xdja.drs.wsclient.yc.GjxxClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckWarning
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(CheckWarning.class);

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("\u8fdb\u5165\u544a\u8b66\u63a5\u53e3");
        String retStr = "";
        new OrganizeSql().process(sheet);
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String url = "";
        url = ods.getUrl();
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
        url = this.packJkUrl(url, maps);
        GjxxClient gc = new GjxxClient();
        retStr = gc.invoke(url);
        log.debug("\u544a\u8b66\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a" + retStr);
        retStr = retStr.substring(retStr.indexOf("<"));
        log.debug("\u5904\u7406\u540e\u7ed3\u679c\uff1a" + retStr);
        this.processQueryResult(retStr, sheet);
    }

    private String packJkUrl(String url, LinkedHashMap<String, String> maps) {
        Iterator<Map.Entry<String, String>> it = maps.entrySet().iterator();
        StringBuilder temp = new StringBuilder(url);
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            try {
                temp.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u5730\u5740URL\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        url = url.substring(0, url.length() - 1);
        log.debug("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5730\u5740\u4e3a\uff1a" + url);
        return url;
    }

    private void processQueryResult(String retStr, WorkSheet sheet) {
        Document doc = XmlHelper.getDoc((String)retStr);
        sheet.setRowTotal(1L);
        Element ele = doc.getRootElement();
        LinkedHashMap outFields = sheet.getOutLocalMapFields();
        Iterator it = outFields.keySet().iterator();
        String key = null;
        String value = null;
        HashMap<String, String> kvMaps = new HashMap<String, String>();
        while (it.hasNext()) {
            key = (String)it.next();
            value = ele.elementTextTrim(key);
            kvMaps.put(key, value);
        }
        sheet.getQueryResultList().add(kvMaps);
    }
}

