/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.emoji.manager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import com.xdja.emoji.R;
import com.xdja.emoji.utils.BitmapUtils;
import com.xdja.emoji.utils.ImageCache;
import com.xdja.emoji.view.easemob.EaseEmojicon;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FaceManager {
    private static final String EMOJI_RES_PATH = "sticker/emotion/";
    public static final String DELETE_KEY = "em_delete_delete_expression";
    public static final String PRAISE = "[emoji_060]";
    public static final Pattern EMOTION_URL = Pattern.compile("\\[(\\S+?)\\]");
    private Map<String, String> mFaceMap = new LinkedHashMap<String, String>();
    private ArrayList<String> faceKeys;
    private List<EaseEmojicon> emojiconList;
    private static FaceManager faceManager;

    private FaceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceManager getInstance() {
        if (faceManager != null) return faceManager;
        Class<FaceManager> clazz = FaceManager.class;
        synchronized (FaceManager.class) {
            if (faceManager != null) return faceManager;
            faceManager = new FaceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return faceManager;
        }
    }

    public Map<String, String> getFaceMap() {
        return this.mFaceMap;
    }

    public ArrayList<String> getFaceKeys() {
        return this.faceKeys;
    }

    public void initFaceMap() {
        this.mFaceMap.put("[emoji_000]", "sticker/emotion/emoji_000.png");
        this.mFaceMap.put("[emoji_001]", "sticker/emotion/emoji_001.png");
        this.mFaceMap.put("[emoji_002]", "sticker/emotion/emoji_002.png");
        this.mFaceMap.put("[emoji_003]", "sticker/emotion/emoji_003.png");
        this.mFaceMap.put("[emoji_004]", "sticker/emotion/emoji_004.png");
        this.mFaceMap.put("[emoji_005]", "sticker/emotion/emoji_005.png");
        this.mFaceMap.put("[emoji_006]", "sticker/emotion/emoji_006.png");
        this.mFaceMap.put("[emoji_007]", "sticker/emotion/emoji_007.png");
        this.mFaceMap.put("[emoji_008]", "sticker/emotion/emoji_008.png");
        this.mFaceMap.put("[emoji_009]", "sticker/emotion/emoji_009.png");
        this.mFaceMap.put("[emoji_010]", "sticker/emotion/emoji_010.png");
        this.mFaceMap.put("[emoji_011]", "sticker/emotion/emoji_011.png");
        this.mFaceMap.put("[emoji_012]", "sticker/emotion/emoji_012.png");
        this.mFaceMap.put("[emoji_013]", "sticker/emotion/emoji_013.png");
        this.mFaceMap.put("[emoji_014]", "sticker/emotion/emoji_014.png");
        this.mFaceMap.put("[emoji_015]", "sticker/emotion/emoji_015.png");
        this.mFaceMap.put("[emoji_016]", "sticker/emotion/emoji_016.png");
        this.mFaceMap.put("[emoji_017]", "sticker/emotion/emoji_017.png");
        this.mFaceMap.put("[emoji_018]", "sticker/emotion/emoji_018.png");
        this.mFaceMap.put("[emoji_019]", "sticker/emotion/emoji_019.png");
        this.mFaceMap.put("[emoji_020]", "sticker/emotion/emoji_020.png");
        this.mFaceMap.put("[emoji_021]", "sticker/emotion/emoji_021.png");
        this.mFaceMap.put("[emoji_022]", "sticker/emotion/emoji_022.png");
        this.mFaceMap.put("[emoji_023]", "sticker/emotion/emoji_023.png");
        this.mFaceMap.put("[emoji_024]", "sticker/emotion/emoji_024.png");
        this.mFaceMap.put("[emoji_025]", "sticker/emotion/emoji_025.png");
        this.mFaceMap.put("[emoji_026]", "sticker/emotion/emoji_026.png");
        this.mFaceMap.put("[emoji_027]", "sticker/emotion/emoji_027.png");
        this.mFaceMap.put("[emoji_028]", "sticker/emotion/emoji_028.png");
        this.mFaceMap.put("[emoji_029]", "sticker/emotion/emoji_029.png");
        this.mFaceMap.put("[emoji_030]", "sticker/emotion/emoji_030.png");
        this.mFaceMap.put("[emoji_031]", "sticker/emotion/emoji_031.png");
        this.mFaceMap.put("[emoji_032]", "sticker/emotion/emoji_032.png");
        this.mFaceMap.put("[emoji_033]", "sticker/emotion/emoji_033.png");
        this.mFaceMap.put("[emoji_034]", "sticker/emotion/emoji_034.png");
        this.mFaceMap.put("[emoji_035]", "sticker/emotion/emoji_035.png");
        this.mFaceMap.put("[emoji_036]", "sticker/emotion/emoji_036.png");
        this.mFaceMap.put("[emoji_037]", "sticker/emotion/emoji_037.png");
        this.mFaceMap.put("[emoji_038]", "sticker/emotion/emoji_038.png");
        this.mFaceMap.put("[emoji_039]", "sticker/emotion/emoji_039.png");
        this.mFaceMap.put("[emoji_040]", "sticker/emotion/emoji_040.png");
        this.mFaceMap.put("[emoji_041]", "sticker/emotion/emoji_041.png");
        this.mFaceMap.put("[emoji_042]", "sticker/emotion/emoji_042.png");
        this.mFaceMap.put("[emoji_043]", "sticker/emotion/emoji_043.png");
        this.mFaceMap.put("[emoji_044]", "sticker/emotion/emoji_044.png");
        this.mFaceMap.put("[emoji_045]", "sticker/emotion/emoji_045.png");
        this.mFaceMap.put("[emoji_046]", "sticker/emotion/emoji_046.png");
        this.mFaceMap.put("[emoji_047]", "sticker/emotion/emoji_047.png");
        this.mFaceMap.put("[emoji_048]", "sticker/emotion/emoji_048.png");
        this.mFaceMap.put("[emoji_049]", "sticker/emotion/emoji_049.png");
        this.mFaceMap.put("[emoji_050]", "sticker/emotion/emoji_050.png");
        this.mFaceMap.put("[emoji_051]", "sticker/emotion/emoji_051.png");
        this.mFaceMap.put("[emoji_052]", "sticker/emotion/emoji_052.png");
        this.mFaceMap.put("[emoji_053]", "sticker/emotion/emoji_053.png");
        this.mFaceMap.put("[emoji_054]", "sticker/emotion/emoji_054.png");
        this.mFaceMap.put("[emoji_055]", "sticker/emotion/emoji_055.png");
        this.mFaceMap.put("[emoji_056]", "sticker/emotion/emoji_056.png");
        this.mFaceMap.put("[emoji_057]", "sticker/emotion/emoji_057.png");
        this.mFaceMap.put("[emoji_058]", "sticker/emotion/emoji_058.png");
        this.mFaceMap.put("[emoji_059]", "sticker/emotion/emoji_059.png");
        this.mFaceMap.put(PRAISE, "sticker/emotion/emoji_060.png");
        this.mFaceMap.put("[emoji_061]", "sticker/emotion/emoji_061.png");
        this.mFaceMap.put("[emoji_062]", "sticker/emotion/emoji_062.png");
        this.mFaceMap.put("[emoji_063]", "sticker/emotion/emoji_063.png");
        this.mFaceMap.put("[emoji_064]", "sticker/emotion/emoji_064.png");
        this.mFaceMap.put("[emoji_065]", "sticker/emotion/emoji_065.png");
        this.mFaceMap.put("[emoji_066]", "sticker/emotion/emoji_066.png");
        this.mFaceMap.put("[emoji_067]", "sticker/emotion/emoji_067.png");
        this.mFaceMap.put("[emoji_068]", "sticker/emotion/emoji_068.png");
        this.mFaceMap.put("[emoji_069]", "sticker/emotion/emoji_069.png");
        this.mFaceMap.put("[emoji_070]", "sticker/emotion/emoji_070.png");
        this.mFaceMap.put("[emoji_071]", "sticker/emotion/emoji_071.png");
        Set<String> keySet = this.getFaceMap().keySet();
        this.faceKeys = new ArrayList();
        this.faceKeys.addAll(keySet);
    }

    private List<EaseEmojicon> initEmojiconList() {
        ArrayList<EaseEmojicon> emojiconList = new ArrayList<EaseEmojicon>();
        for (String emojiconKeyString : this.faceKeys) {
            EaseEmojicon emojicon = new EaseEmojicon(this.mFaceMap.get(emojiconKeyString), emojiconKeyString, EaseEmojicon.Type.NORMAL);
            emojiconList.add(emojicon);
        }
        return emojiconList;
    }

    public List<EaseEmojicon> getEmojiconList() {
        if (this.emojiconList != null) {
            return this.emojiconList;
        }
        this.emojiconList = this.initEmojiconList();
        return this.emojiconList;
    }

    public CharSequence convertNormalStringToSpannableString(Context mContext, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        String hackTxt = message.startsWith("[") && message.endsWith("]") ? message : message;
        SpannableString value = SpannableString.valueOf((CharSequence)hackTxt);
        Matcher localMatcher = EMOTION_URL.matcher((CharSequence)value);
        while (localMatcher.find()) {
            String str2 = localMatcher.group(0);
            int k = localMatcher.start();
            int m = localMatcher.end();
            if (m - k >= 12 || !this.getFaceMap().containsKey(str2)) continue;
            ImageCache imageCache = ImageCache.getInstance();
            Bitmap newBitmap = null;
            if (imageCache.get(str2) != null) {
                newBitmap = imageCache.get(str2);
            } else {
                String emojiResPath = this.getFaceMap().get(str2);
                Bitmap bitmap = BitmapUtils.getImageFromAssets(mContext, emojiResPath);
                int edittext_emojicon_size = (int)mContext.getResources().getDimension(R.dimen.edittext_emojicon_size);
                if (bitmap != null) {
                    int rawHeigh = bitmap.getHeight();
                    int rawWidth = bitmap.getHeight();
                    int newHeight = edittext_emojicon_size;
                    int newWidth = edittext_emojicon_size;
                    float heightScale = (float)newHeight / (float)rawHeigh;
                    float widthScale = (float)newWidth / (float)rawWidth;
                    Matrix matrix = new Matrix();
                    matrix.postScale(heightScale, widthScale);
                    newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)rawWidth, (int)rawHeigh, (Matrix)matrix, (boolean)true);
                    imageCache.put(str2, newBitmap);
                    bitmap.recycle();
                }
            }
            ImageSpan imageSpan = new ImageSpan(mContext, newBitmap);
            value.setSpan((Object)imageSpan, k, m, 33);
        }
        return value;
    }
}

