/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.emoji.view;

import android.view.View;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.xdja.emoji.view.AnimationShake;
import com.xdja.emoji.view.BaseViewAnimator;
import java.util.ArrayList;
import java.util.List;

public class AnimationYoYo {
    private static final long DURATION = 1000L;
    private static final long NO_DELAY = 0L;
    private BaseViewAnimator animator;
    private long duration;
    private long delay;
    private Interpolator interpolator;
    private List<Animator.AnimatorListener> callbacks;
    private View target;

    private AnimationYoYo(AnimationComposer animationComposer) {
        this.animator = animationComposer.animator;
        this.duration = animationComposer.duration;
        this.delay = animationComposer.delay;
        this.interpolator = animationComposer.interpolator;
        this.callbacks = animationComposer.callbacks;
        this.target = animationComposer.target;
    }

    public static AnimationComposer with(BaseViewAnimator animator) {
        return new AnimationComposer(animator);
    }

    public static void shakeView(View v) {
        AnimationYoYo.with(new AnimationShake()).duration(700L).playOn(v);
    }

    private BaseViewAnimator play() {
        this.animator.setTarget(this.target);
        this.animator.setDuration(this.duration).setInterpolator(this.interpolator).setStartDelay(this.delay);
        if (this.callbacks.size() > 0) {
            for (Animator.AnimatorListener callback : this.callbacks) {
                this.animator.addAnimatorListener(callback);
            }
        }
        this.animator.animate();
        return this.animator;
    }

    public static final class YoYoString {
        private BaseViewAnimator animator;
        private View target;

        private YoYoString(BaseViewAnimator animator, View target) {
            this.target = target;
            this.animator = animator;
        }

        public boolean isStarted() {
            return this.animator.isStarted();
        }

        public boolean isRunning() {
            return this.animator.isRunning();
        }

        public void stop(boolean reset) {
            this.animator.cancel();
            if (reset) {
                this.animator.reset(this.target);
            }
        }
    }

    public static final class AnimationComposer {
        private List<Animator.AnimatorListener> callbacks = new ArrayList<Animator.AnimatorListener>();
        private BaseViewAnimator animator;
        private long duration = 1000L;
        private long delay = 0L;
        private Interpolator interpolator;
        private View target;

        private AnimationComposer(BaseViewAnimator animator) {
            this.animator = animator;
        }

        public AnimationComposer duration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationComposer delay(long delay) {
            this.delay = delay;
            return this;
        }

        public AnimationComposer interpolate(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public AnimationComposer withListener(Animator.AnimatorListener listener) {
            this.callbacks.add(listener);
            return this;
        }

        public YoYoString playOn(View target) {
            this.target = target;
            return new YoYoString(new AnimationYoYo(this).play(), this.target);
        }
    }
}

