/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.emoji.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;
import com.xdja.emoji.R;
import com.xdja.emoji.view.AnimationYoYo;
import com.xdja.widget.emoji.EmojiconEditText;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputControlEditText
extends EmojiconEditText {
    private int maxLength = 2000;
    public InputLengthHintListener mInputLengthHintListener;
    public GetInputLengthListener mGetInputLengthListener;
    public TextChangedListener mTextChangedListener;
    private MyWatcher mWatcher;
    private Pattern emojiPattern = Pattern.compile("\\[emoji_[0-9]{3}\\]");

    public InputControlEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public InputControlEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InputControlEditText(Context context) {
        super(context);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setOnMaxInputListener(int maxInputLength, InputLengthHintListener Listener) {
        this.maxLength = maxInputLength;
        this.mInputLengthHintListener = Listener;
        if (this.mWatcher == null) {
            this.mWatcher = new MyWatcher();
        }
        this.addTextChangedListener(this.mWatcher);
    }

    public void setOnGetInputLengthListener(GetInputLengthListener listener) {
        this.mGetInputLengthListener = listener;
        if (this.mWatcher == null) {
            this.mWatcher = new MyWatcher();
        }
        this.addTextChangedListener(this.mWatcher);
    }

    public void setTextChangedListener(TextChangedListener listener) {
        this.mTextChangedListener = listener;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public void onOverFlowHint() {
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.add_text_over_hint, new Object[]{this.maxLength + ""}), (int)0).show();
        AnimationYoYo.shakeView((View)this);
    }

    private class MyWatcher
    implements TextWatcher {
        private long startBackSpaceTime = 0L;

        private MyWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (InputControlEditText.this.mTextChangedListener != null) {
                InputControlEditText.this.mTextChangedListener.textChanged(s);
            }
        }

        private long getTextLength() {
            String tempStr = InputControlEditText.this.getText().toString();
            Matcher emojiCustomMatcher = InputControlEditText.this.emojiPattern.matcher(tempStr);
            ArrayList<String> emojis = new ArrayList<String>();
            while (emojiCustomMatcher.find()) {
                String emojiCustomText = emojiCustomMatcher.group(0);
                emojis.add(emojiCustomText);
                tempStr = tempStr.replace(emojiCustomText, "");
            }
            return tempStr.length() + emojis.size();
        }

        public void afterTextChanged(Editable s) {
            long textLength = this.getTextLength();
            if (InputControlEditText.this.mTextChangedListener != null) {
                InputControlEditText.this.mTextChangedListener.afterTextChanged(s);
            }
            if (InputControlEditText.this.mGetInputLengthListener != null) {
                InputControlEditText.this.mGetInputLengthListener.getInputLength(this.getTextLength());
            }
            if (textLength > (long)InputControlEditText.this.maxLength) {
                if (System.currentTimeMillis() - this.startBackSpaceTime > 100L && InputControlEditText.this.mInputLengthHintListener != null) {
                    InputControlEditText.this.mInputLengthHintListener.onOverFlowHint();
                }
                this.startBackSpaceTime = System.currentTimeMillis();
                InputControlEditText.this.onBackSpace();
                return;
            }
            this.startBackSpaceTime = 0L;
        }
    }

    public static interface TextChangedListener {
        public void textChanged(CharSequence var1);

        public void afterTextChanged(Editable var1);
    }

    public static interface GetInputLengthListener {
        public void getInputLength(long var1);
    }

    public static interface InputLengthHintListener {
        public void onOverFlowHint();
    }
}

