/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.emoji.view.easemob;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.xdja.emoji.R;
import com.xdja.emoji.utils.BitmapUtils;
import com.xdja.emoji.view.easemob.EaseEmojicon;
import java.util.List;

public class EmojiconGridAdapter
extends ArrayAdapter<EaseEmojicon> {
    private EaseEmojicon.Type emojiconType;
    private LayoutInflater inflater;
    private Context mContext;

    public EmojiconGridAdapter(Context context, int textViewResourceId, List<EaseEmojicon> objects, EaseEmojicon.Type emojiconType) {
        super(context, textViewResourceId, objects);
        this.mContext = context;
        this.emojiconType = emojiconType;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.emojiconType == EaseEmojicon.Type.BIG_EXPRESSION ? View.inflate((Context)this.getContext(), (int)R.layout.ease_row_big_expression, null) : this.inflater.inflate(R.layout.ease_row_expression, parent, false);
        }
        ImageView imageView = (ImageView)convertView.findViewById(R.id.iv_expression);
        TextView textView = (TextView)convertView.findViewById(R.id.tv_name);
        EaseEmojicon emojicon = (EaseEmojicon)this.getItem(position);
        if (textView != null && emojicon.getName() != null) {
            textView.setText((CharSequence)emojicon.getName());
        }
        if ("em_delete_delete_expression".equals(emojicon.getEmojiText())) {
            imageView.setImageResource(R.drawable.emotion_del_selector);
        } else if (!TextUtils.isEmpty((CharSequence)emojicon.getEmojiResPath())) {
            Bitmap emojiBitmap = BitmapUtils.getImageFromAssets(this.mContext, emojicon.getEmojiResPath());
            imageView.setImageBitmap(emojiBitmap);
        } else if (emojicon.getIconPath() != null) {
            Glide.with((Context)this.getContext()).load(emojicon.getIconPath()).placeholder(R.drawable.ease_default_expression).into(imageView);
        }
        return convertView;
    }
}

