/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.widget.emoji;

import android.os.Parcel;
import android.os.Parcelable;
import com.xdja.widget.emoji.CustomPeople;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Emojicon
implements Parcelable {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_CUSTOM_PEOPLE = 1;
    public static final Parcelable.Creator<Emojicon> CREATOR = new Parcelable.Creator<Emojicon>(){

        public Emojicon createFromParcel(Parcel in) {
            return new Emojicon(in);
        }

        public Emojicon[] newArray(int size) {
            return new Emojicon[size];
        }
    };
    private int icon;
    private char value;
    private String emoji;

    public static Emojicon[] getEmojicons(int type) {
        switch (type) {
            case 1: {
                return CustomPeople.CustomPeopleHolder.DATA;
            }
        }
        throw new IllegalArgumentException("Invalid emojicon type: " + type);
    }

    public Emojicon(int icon, char value, String emoji) {
        this.icon = icon;
        this.value = value;
        this.emoji = emoji;
    }

    public Emojicon(Parcel in) {
        this.icon = in.readInt();
        this.value = (char)in.readInt();
        this.emoji = in.readString();
    }

    private Emojicon() {
    }

    public Emojicon(String emoji) {
        this.emoji = emoji;
    }

    public static Emojicon fromResource(int icon, int value) {
        Emojicon emoji = new Emojicon();
        emoji.icon = icon;
        emoji.value = (char)value;
        return emoji;
    }

    public static Emojicon fromCodePoint(int codePoint) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = Emojicon.newString(codePoint);
        return emoji;
    }

    public static Emojicon fromChar(char ch) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = Character.toString(ch);
        return emoji;
    }

    public static Emojicon fromChars(String chars) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = chars;
        return emoji;
    }

    public static final String newString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf(codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.icon);
        dest.writeInt((int)this.value);
        dest.writeString(this.emoji);
    }

    public char getValue() {
        return this.value;
    }

    public int getIcon() {
        return this.icon;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public boolean equals(Object o) {
        return o instanceof Emojicon && this.emoji.equals(((Emojicon)o).emoji);
    }

    public int hashCode() {
        return this.emoji.hashCode();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    public static @interface Alignment {
    }
}

