/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.widget.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.text.ClipboardManager;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.TextView;
import com.xdja.emoji.R;
import com.xdja.widget.emoji.Emojicon;
import com.xdja.widget.emoji.EmojiconHandler;

public class EmojiconEditText
extends AppCompatEditText {
    private int mEmojiconSize;
    private int mEmojiconAlignment;
    private int mEmojiconTextSize;

    public EmojiconEditText(Context context) {
        super(context);
        this.mEmojiconSize = (int)this.getTextSize();
        this.mEmojiconTextSize = (int)this.getTextSize();
    }

    public EmojiconEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiconEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Emojicon);
        this.mEmojiconSize = (int)a.getDimension(R.styleable.Emojicon_emojiconSize, this.getTextSize());
        this.mEmojiconAlignment = a.getInt(R.styleable.Emojicon_emojiconAlignment, 1);
        a.recycle();
        this.mEmojiconTextSize = (int)this.getTextSize();
        this.setText((CharSequence)this.getText());
    }

    public void setEmojiconSize(int pixels) {
        this.mEmojiconSize = pixels;
        this.updateText();
    }

    public boolean onTextContextMenuItem(int id2) {
        switch (id2) {
            case 0x1020022: {
                ClipboardManager cmb = (ClipboardManager)this.getContext().getSystemService("clipboard");
                if (cmb == null || cmb.getText() == null) {
                    return false;
                }
                CharSequence pasteContent = cmb.getText();
                if (TextUtils.isEmpty((CharSequence)pasteContent)) break;
                try {
                    SpannableString pasteSpan = EmojiconHandler.getEmojiFormatContent(this.getContext(), pasteContent, this.mEmojiconSize, this.mEmojiconAlignment, this.mEmojiconTextSize);
                    if (!TextUtils.isEmpty((CharSequence)pasteSpan)) {
                        this.getText().insert(this.getSelectionStart(), (CharSequence)pasteSpan);
                        this.setFocusable(true);
                        return false;
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return super.onTextContextMenuItem(id2);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.updateText();
    }

    private void updateText() {
        Editable text = this.getText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            EmojiconHandler.addEmojis(this.getContext(), (Spannable)this.getText(), this.mEmojiconSize, this.mEmojiconAlignment, this.mEmojiconTextSize);
        }
    }

    public void insertEmojicon(Emojicon emojicon) {
        if (emojicon == null || TextUtils.isEmpty((CharSequence)emojicon.getEmoji())) {
            return;
        }
        try {
            String emojiText = emojicon.getEmoji();
            SpannableString pasteSpan = EmojiconHandler.getEmojiFormatContent(this.getContext(), emojiText, this.mEmojiconSize, this.mEmojiconAlignment, this.mEmojiconTextSize);
            if (!TextUtils.isEmpty((CharSequence)pasteSpan)) {
                this.getText().insert(this.getSelectionStart(), (CharSequence)pasteSpan);
                this.setFocusable(true);
                return;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackSpace() {
        KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
        this.dispatchKeyEvent(event);
    }

    public class EmojiInputConnection
    extends InputConnectionWrapper {
        public EmojiInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean commitText(CharSequence pasteContent, int newCursorPosition) {
            if (TextUtils.isEmpty((CharSequence)pasteContent)) {
                return super.commitText(pasteContent, newCursorPosition);
            }
            Editable edit = EmojiconEditText.this.getEditableText();
            SpannableString pasteSpan = EmojiconHandler.getEmojiFormatContent(EmojiconEditText.this.getContext(), pasteContent, EmojiconEditText.this.mEmojiconSize, EmojiconEditText.this.mEmojiconAlignment, EmojiconEditText.this.mEmojiconTextSize);
            if (!TextUtils.isEmpty((CharSequence)pasteSpan)) {
                edit.insert(EmojiconEditText.this.getSelectionStart(), (CharSequence)pasteSpan);
                return false;
            }
            return super.commitText(pasteContent, newCursorPosition);
        }
    }
}

