/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.widget.emoji;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.xdja.widget.emoji.EmojiconSpan;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiconHandler {
    private ArrayMap<CharSequence, String> sEmojisCustomMap = new ArrayMap();
    private static final String EMOJI_RES_PATH = "sticker/emotion/";
    public static final String EMOJI_CUSTOM_REGEX = "\\[emoji_[0-9]{3}\\]";

    private EmojiconHandler() {
        this.sEmojisCustomMap.put((Object)"[emoji_000]", (Object)"sticker/emotion/emoji_000.png");
        this.sEmojisCustomMap.put((Object)"[emoji_001]", (Object)"sticker/emotion/emoji_001.png");
        this.sEmojisCustomMap.put((Object)"[emoji_002]", (Object)"sticker/emotion/emoji_002.png");
        this.sEmojisCustomMap.put((Object)"[emoji_003]", (Object)"sticker/emotion/emoji_003.png");
        this.sEmojisCustomMap.put((Object)"[emoji_004]", (Object)"sticker/emotion/emoji_004.png");
        this.sEmojisCustomMap.put((Object)"[emoji_005]", (Object)"sticker/emotion/emoji_005.png");
        this.sEmojisCustomMap.put((Object)"[emoji_006]", (Object)"sticker/emotion/emoji_006.png");
        this.sEmojisCustomMap.put((Object)"[emoji_007]", (Object)"sticker/emotion/emoji_007.png");
        this.sEmojisCustomMap.put((Object)"[emoji_008]", (Object)"sticker/emotion/emoji_008.png");
        this.sEmojisCustomMap.put((Object)"[emoji_009]", (Object)"sticker/emotion/emoji_009.png");
        this.sEmojisCustomMap.put((Object)"[emoji_010]", (Object)"sticker/emotion/emoji_010.png");
        this.sEmojisCustomMap.put((Object)"[emoji_011]", (Object)"sticker/emotion/emoji_011.png");
        this.sEmojisCustomMap.put((Object)"[emoji_012]", (Object)"sticker/emotion/emoji_012.png");
        this.sEmojisCustomMap.put((Object)"[emoji_013]", (Object)"sticker/emotion/emoji_013.png");
        this.sEmojisCustomMap.put((Object)"[emoji_014]", (Object)"sticker/emotion/emoji_014.png");
        this.sEmojisCustomMap.put((Object)"[emoji_015]", (Object)"sticker/emotion/emoji_015.png");
        this.sEmojisCustomMap.put((Object)"[emoji_016]", (Object)"sticker/emotion/emoji_016.png");
        this.sEmojisCustomMap.put((Object)"[emoji_017]", (Object)"sticker/emotion/emoji_017.png");
        this.sEmojisCustomMap.put((Object)"[emoji_018]", (Object)"sticker/emotion/emoji_018.png");
        this.sEmojisCustomMap.put((Object)"[emoji_019]", (Object)"sticker/emotion/emoji_019.png");
        this.sEmojisCustomMap.put((Object)"[emoji_020]", (Object)"sticker/emotion/emoji_020.png");
        this.sEmojisCustomMap.put((Object)"[emoji_021]", (Object)"sticker/emotion/emoji_021.png");
        this.sEmojisCustomMap.put((Object)"[emoji_022]", (Object)"sticker/emotion/emoji_022.png");
        this.sEmojisCustomMap.put((Object)"[emoji_023]", (Object)"sticker/emotion/emoji_023.png");
        this.sEmojisCustomMap.put((Object)"[emoji_024]", (Object)"sticker/emotion/emoji_024.png");
        this.sEmojisCustomMap.put((Object)"[emoji_025]", (Object)"sticker/emotion/emoji_025.png");
        this.sEmojisCustomMap.put((Object)"[emoji_026]", (Object)"sticker/emotion/emoji_026.png");
        this.sEmojisCustomMap.put((Object)"[emoji_027]", (Object)"sticker/emotion/emoji_027.png");
        this.sEmojisCustomMap.put((Object)"[emoji_028]", (Object)"sticker/emotion/emoji_028.png");
        this.sEmojisCustomMap.put((Object)"[emoji_029]", (Object)"sticker/emotion/emoji_029.png");
        this.sEmojisCustomMap.put((Object)"[emoji_030]", (Object)"sticker/emotion/emoji_030.png");
        this.sEmojisCustomMap.put((Object)"[emoji_031]", (Object)"sticker/emotion/emoji_031.png");
        this.sEmojisCustomMap.put((Object)"[emoji_032]", (Object)"sticker/emotion/emoji_032.png");
        this.sEmojisCustomMap.put((Object)"[emoji_033]", (Object)"sticker/emotion/emoji_033.png");
        this.sEmojisCustomMap.put((Object)"[emoji_034]", (Object)"sticker/emotion/emoji_034.png");
        this.sEmojisCustomMap.put((Object)"[emoji_035]", (Object)"sticker/emotion/emoji_035.png");
        this.sEmojisCustomMap.put((Object)"[emoji_036]", (Object)"sticker/emotion/emoji_036.png");
        this.sEmojisCustomMap.put((Object)"[emoji_037]", (Object)"sticker/emotion/emoji_037.png");
        this.sEmojisCustomMap.put((Object)"[emoji_038]", (Object)"sticker/emotion/emoji_038.png");
        this.sEmojisCustomMap.put((Object)"[emoji_039]", (Object)"sticker/emotion/emoji_039.png");
        this.sEmojisCustomMap.put((Object)"[emoji_040]", (Object)"sticker/emotion/emoji_040.png");
        this.sEmojisCustomMap.put((Object)"[emoji_041]", (Object)"sticker/emotion/emoji_041.png");
        this.sEmojisCustomMap.put((Object)"[emoji_042]", (Object)"sticker/emotion/emoji_042.png");
        this.sEmojisCustomMap.put((Object)"[emoji_043]", (Object)"sticker/emotion/emoji_043.png");
        this.sEmojisCustomMap.put((Object)"[emoji_044]", (Object)"sticker/emotion/emoji_044.png");
        this.sEmojisCustomMap.put((Object)"[emoji_045]", (Object)"sticker/emotion/emoji_045.png");
        this.sEmojisCustomMap.put((Object)"[emoji_046]", (Object)"sticker/emotion/emoji_046.png");
        this.sEmojisCustomMap.put((Object)"[emoji_047]", (Object)"sticker/emotion/emoji_047.png");
        this.sEmojisCustomMap.put((Object)"[emoji_048]", (Object)"sticker/emotion/emoji_048.png");
        this.sEmojisCustomMap.put((Object)"[emoji_049]", (Object)"sticker/emotion/emoji_049.png");
        this.sEmojisCustomMap.put((Object)"[emoji_050]", (Object)"sticker/emotion/emoji_050.png");
        this.sEmojisCustomMap.put((Object)"[emoji_051]", (Object)"sticker/emotion/emoji_051.png");
        this.sEmojisCustomMap.put((Object)"[emoji_052]", (Object)"sticker/emotion/emoji_052.png");
        this.sEmojisCustomMap.put((Object)"[emoji_053]", (Object)"sticker/emotion/emoji_053.png");
        this.sEmojisCustomMap.put((Object)"[emoji_054]", (Object)"sticker/emotion/emoji_054.png");
        this.sEmojisCustomMap.put((Object)"[emoji_055]", (Object)"sticker/emotion/emoji_055.png");
        this.sEmojisCustomMap.put((Object)"[emoji_056]", (Object)"sticker/emotion/emoji_056.png");
        this.sEmojisCustomMap.put((Object)"[emoji_057]", (Object)"sticker/emotion/emoji_057.png");
        this.sEmojisCustomMap.put((Object)"[emoji_058]", (Object)"sticker/emotion/emoji_058.png");
        this.sEmojisCustomMap.put((Object)"[emoji_059]", (Object)"sticker/emotion/emoji_059.png");
        this.sEmojisCustomMap.put((Object)"[emoji_060]", (Object)"sticker/emotion/emoji_060.png");
        this.sEmojisCustomMap.put((Object)"[emoji_061]", (Object)"sticker/emotion/emoji_061.png");
        this.sEmojisCustomMap.put((Object)"[emoji_062]", (Object)"sticker/emotion/emoji_062.png");
        this.sEmojisCustomMap.put((Object)"[emoji_063]", (Object)"sticker/emotion/emoji_063.png");
        this.sEmojisCustomMap.put((Object)"[emoji_064]", (Object)"sticker/emotion/emoji_064.png");
        this.sEmojisCustomMap.put((Object)"[emoji_065]", (Object)"sticker/emotion/emoji_065.png");
        this.sEmojisCustomMap.put((Object)"[emoji_066]", (Object)"sticker/emotion/emoji_066.png");
        this.sEmojisCustomMap.put((Object)"[emoji_067]", (Object)"sticker/emotion/emoji_067.png");
        this.sEmojisCustomMap.put((Object)"[emoji_068]", (Object)"sticker/emotion/emoji_068.png");
        this.sEmojisCustomMap.put((Object)"[emoji_069]", (Object)"sticker/emotion/emoji_069.png");
        this.sEmojisCustomMap.put((Object)"[emoji_070]", (Object)"sticker/emotion/emoji_070.png");
        this.sEmojisCustomMap.put((Object)"[emoji_071]", (Object)"sticker/emotion/emoji_071.png");
    }

    public static EmojiconHandler getEmojiconHandler() {
        return EmojiconHandlerHolder.emojiconHandler;
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize) {
        if (text == null) {
            return;
        }
        Matcher emojiCustomMatcher = Pattern.compile(EMOJI_CUSTOM_REGEX).matcher((CharSequence)text);
        while (emojiCustomMatcher.find()) {
            String emojiCustomText = emojiCustomMatcher.group(0);
            int emojiCustomStart = emojiCustomMatcher.start();
            int emojiCustomEnd = emojiCustomStart + emojiCustomText.length();
            String emojiPath = EmojiconHandler.getCustomEmojiPath(emojiCustomText);
            if (TextUtils.isEmpty((CharSequence)emojiPath)) continue;
            text.setSpan((Object)new EmojiconSpan(context, emojiPath, emojiSize, emojiAlignment, textSize), emojiCustomStart, emojiCustomEnd, 33);
        }
    }

    public static SpannableString getEmojiFormatContent(Context context, CharSequence emojiContent, int emojiSize, int emojiAlignment, int textSize) {
        SpannableString spanContent = new SpannableString(emojiContent);
        Matcher emojiCustomMatcher = Pattern.compile(EMOJI_CUSTOM_REGEX).matcher(emojiContent);
        while (emojiCustomMatcher.find()) {
            String emojiCustomText = emojiCustomMatcher.group(0);
            int emojiCustomStart = emojiCustomMatcher.start();
            int emojiCustomEnd = emojiCustomStart + emojiCustomText.length();
            String emojiPath = EmojiconHandler.getCustomEmojiPath(emojiCustomText);
            if (TextUtils.isEmpty((CharSequence)emojiPath)) continue;
            spanContent.setSpan((Object)new EmojiconSpan(context, emojiPath, emojiSize, emojiAlignment, textSize), emojiCustomStart, emojiCustomEnd, 33);
        }
        return spanContent;
    }

    private static String getCustomEmojiPath(CharSequence emojiCustomText) {
        String emojiPath = null;
        if (!TextUtils.isEmpty((CharSequence)emojiCustomText)) {
            emojiPath = (String)EmojiconHandler.getEmojiconHandler().sEmojisCustomMap.get((Object)emojiCustomText);
        }
        return emojiPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawableFromAssets(Context context, String emojiPath) {
        Drawable drawable2 = null;
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().getAssets().open(emojiPath);
            drawable2 = Drawable.createFromStream((InputStream)inputStream, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return drawable2;
    }

    public static class EmojiconHandlerHolder {
        static final EmojiconHandler emojiconHandler = new EmojiconHandler();
    }
}

