/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.widget.emoji;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.style.DynamicDrawableSpan;
import com.xdja.widget.emoji.EmojiconHandler;
import java.lang.ref.WeakReference;

public class EmojiconSpan
extends DynamicDrawableSpan {
    private final Context mContext;
    private final int mResourceId;
    private final String mResourcePath;
    private final int mSize;
    private final int mTextSize;
    private int mHeight;
    private int mWidth;
    private int mTop;
    private Drawable mDrawable;
    private WeakReference<Drawable> mDrawableRef;

    public EmojiconSpan(Context context, int resourceId, int size, int alignment, int textSize) {
        this(context, resourceId, null, size, alignment, textSize);
    }

    public EmojiconSpan(Context context, int resourceId, String resourcePath, int size, int alignment, int textSize) {
        super(alignment);
        this.mContext = context;
        this.mResourceId = resourceId;
        this.mResourcePath = resourcePath;
        this.mHeight = this.mSize = size;
        this.mWidth = this.mSize;
        this.mTextSize = textSize;
    }

    public EmojiconSpan(Context context, String resourcePath, int size, int alignment, int textSize) {
        this(context, 0, resourcePath, size, alignment, textSize);
    }

    public Drawable getDrawable() {
        if (this.mDrawable == null) {
            try {
                if (this.mResourceId > 0) {
                    this.mDrawable = this.mContext.getResources().getDrawable(this.mResourceId);
                } else if (!TextUtils.isEmpty((CharSequence)this.mResourcePath)) {
                    this.mDrawable = EmojiconHandler.getDrawableFromAssets(this.mContext, this.mResourcePath);
                }
                this.mHeight = this.mSize;
                this.mWidth = this.mHeight * this.mDrawable.getIntrinsicWidth() / this.mDrawable.getIntrinsicHeight();
                this.mTop = (this.mTextSize - this.mHeight) / 2;
                this.mDrawable.setBounds(0, this.mTop, this.mWidth, this.mTop + this.mHeight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mDrawable;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        canvas.save();
        Drawable b = this.getCachedDrawable();
        int transY = bottom - b.getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            transY = top + (bottom - top) / 2 - (b.getBounds().bottom - b.getBounds().top) / 2 - this.mTop;
        }
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        if (this.mDrawableRef == null || this.mDrawableRef.get() == null) {
            this.mDrawableRef = new WeakReference<Drawable>(this.getDrawable());
        }
        return (Drawable)this.mDrawableRef.get();
    }
}

