/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.widget.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.xdja.emoji.R;
import com.xdja.widget.emoji.EmojiconHandler;

public class EmojiconTextView
extends AppCompatTextView {
    private int mEmojiconSize;
    private int mEmojiconAlignment;
    private int mEmojiconTextSize;
    private SpannableString textSpan;

    public EmojiconTextView(Context context) {
        super(context);
        this.init(null);
    }

    public EmojiconTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiconTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mEmojiconTextSize = (int)this.getTextSize();
        if (attrs == null) {
            this.mEmojiconSize = (int)this.getTextSize();
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Emojicon);
            this.mEmojiconSize = (int)a.getDimension(R.styleable.Emojicon_emojiconSize, this.getTextSize());
            this.mEmojiconAlignment = a.getInt(R.styleable.Emojicon_emojiconAlignment, 1);
            a.recycle();
        }
        this.setText(this.getText());
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            SpannableString spannableString = EmojiconHandler.getEmojiFormatContent(this.getContext(), text, this.mEmojiconSize, this.mEmojiconAlignment, this.mEmojiconTextSize);
            text = spannableString;
            this.textSpan = spannableString;
        }
        super.setText(text, type);
    }

    public void setEmojiconSize(int pixels) {
        this.mEmojiconSize = pixels;
        super.setText(this.getText());
    }
}

