package com.xdja.eoa.commonwidget.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.eoa.commonwidget.R;
import com.xdja.eoa.commonwidget.bean.PathInfo;
import com.xdja.eoa.commonwidget.listener.OnRecycleViewItemClickListener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

import skin.support.content.res.SkinCompatResources;

/**
 * 支持层级路径跳转Adapter
 *
 * @param <D>
 */
public class CommonPathViewAdapter<D> extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private OnRecycleViewItemClickListener<PathInfo<D>> itemClickListener;
    private List<PathInfo<D>> mList = new ArrayList<>();
    private Context context;
    private boolean isCanBackToRoot;
    private static final String ELLIPSIS_NORMAL = "\u2026";

    public CommonPathViewAdapter(Context context) {
        this.context = context;
    }

    public void setItemClickListener(OnRecycleViewItemClickListener<PathInfo<D>> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public void setCanBackToRoot(boolean canBackToRoot) {
        this.isCanBackToRoot = canBackToRoot;
    }

    public PathInfo<D> findPathInfoByData(D data) {
        if (data == null || mList == null || mList.isEmpty()) {
            return null;
        }
        for (PathInfo<D> pathInfo : mList) {
            if (Objects.equals(pathInfo.getData(), data)) {
                return pathInfo;
            }
        }
        return null;
    }

    public void setRoot(String rootName) {
        PathInfo<D> pathInfo = new PathInfo<>();
        pathInfo.setType(PathInfo.TYPE_ROOT);
        pathInfo.setPathName(rootName);
        mList.add(0, pathInfo);
        notifyDataSetChanged();
    }

    public void addData(String pathName, D data) {
        PathInfo<D> pathInfo = new PathInfo<>();
        pathInfo.setPathName(pathName);
        pathInfo.setData(data);
        pathInfo.setType(PathInfo.TYPE_DATA);
        mList.add(pathInfo);
        notifyDataSetChanged();
        /*  int position = mList.indexOf(data);
      notifyItemInserted(position);
        notifyItemRangeChanged(position, mList.size() - position);*/
    }

    public boolean back() {
        if (mList == null || mList.isEmpty() || mList.size() == (isCanBackToRoot ? 1 : 2)) {
            return false;
        }
        int index = mList.size() - 1;
        mList.remove(index);
        notifyDataSetChanged();
      /*  notifyItemRemoved(index);
        notifyItemChanged(index - 1);*/
        return true;
    }

    public void back2Root() {
        if (mList == null || mList.isEmpty()) {
            return;
        }
        Iterator<PathInfo<D>> iterator = mList.iterator();
        for (int i = 0; iterator.hasNext(); i++) {
            iterator.next();
            if (isCanBackToRoot && i == 0) {
                continue;
            }
            iterator.remove();
        }
        notifyDataSetChanged();
    }

    public PathInfo<D> jump2Position(String pathName, PathInfo<D> departmentBean) {
        if (mList == null || mList.isEmpty()) {
            return null;
        }
        int position = -1;
        for (int i = 0; i < mList.size(); i++) {
            PathInfo<D> pathInfo = mList.get(i);
            if (pathInfo != null && pathInfo.getId() == departmentBean.getId()) {
                position = i;
                break;
            }
        }
        if (position < 0) {
            addData(pathName, departmentBean.getData());
            return departmentBean;
        }
        for (int i = mList.size() - 1; i >= 0; i--) {
            if (i > position) {
                mList.remove(i);
                notifyDataSetChanged();
               /* notifyItemRemoved(i);
                notifyItemChanged(i - 1);*/
            }
        }
        return departmentBean;

    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(context);
        View itemView = inflater.inflate(R.layout.common_widget_item_level_form_contact_path, parent, false);
        return new DepartmentViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        if (holder == null) {
            return;
        }
        final PathInfo<D> pathInfo = mList.get(position);
        boolean isLastOne = isLastOne(position, pathInfo);

        DepartmentViewHolder rootViewHolder = (DepartmentViewHolder) holder;
        if (pathInfo != null) {
            rootViewHolder.setName(pathInfo.getPathName(), isLastOne);
        }

        rootViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isLastOne(position, pathInfo)) {
                    return;
                }
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(v, pathInfo, position);
                }
                jump2Position(pathInfo.getPathName(), pathInfo);
                return;
            }
        });
    }

    private boolean isLastOne(int position, PathInfo<D> departmentBean) {
        return (mList.size() == 1 && departmentBean.getType() == PathInfo.TYPE_ROOT) || (position + 1 == mList.size() && departmentBean.getType() == PathInfo.TYPE_DATA);
    }


    @Override
    public int getItemCount() {
        return mList.size();
    }


    public PathInfo<D> getData(int position) {
        return mList.get(position);
    }

    private class DepartmentViewHolder extends RecyclerView.ViewHolder {
        private TextView departmentNameTv;
        private ImageView dividerIv;

        public DepartmentViewHolder(View itemView) {
            super(itemView);
            departmentNameTv = itemView.findViewById(R.id.level_form_contact_department_name);
            dividerIv = itemView.findViewById(R.id.level_form_contact_department_path_divider);
        }


        public void setName(String pathName, boolean isLastOne) {
            if (TextUtils.isEmpty(pathName)) {
                pathName = "";
            }
            if (pathName.length() > 18) {
                departmentNameTv.setText(pathName.subSequence(0, 17) + ELLIPSIS_NORMAL);
            } else {
                departmentNameTv.setText(pathName);
            }
            dividerIv.setVisibility(isLastOne ? View.GONE : View.VISIBLE);
            if (isLastOne) {
                departmentNameTv.setTextColor(SkinCompatResources.getColor(context, R.color.common_widget_text_colorC3_3));
            } else {
                departmentNameTv.setTextColor(SkinCompatResources.getColor(context, R.color.skinable_theme_color_C1_1));
            }
        }
    }
}
