package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.xdja.eoa.commonwidget.R;

/**
 * @author jarlen
 * @date 2019/9/2
 * 带边框的TextView
 */
public class BorderTextView extends android.support.v7.widget.AppCompatTextView {

    private int mCornersRadius;
    private int mBorderWidth;
    private int mBorderColor;
    private int mSolidColor;
    private GradientDrawable gradientDrawable;

    public BorderTextView(Context context) {
        super(context, null);
    }

    public BorderTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BorderTextView);
        mCornersRadius = typedArray.getDimensionPixelSize(R.styleable.BorderTextView_btv_corners_radius, 0);
        mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.BorderTextView_btv_border_width, 0);
        mBorderColor = typedArray.getColor(R.styleable.BorderTextView_btv_border_color, Color.TRANSPARENT);
        mSolidColor = typedArray.getColor(R.styleable.BorderTextView_btv_solid_color, Color.TRANSPARENT);
        typedArray.recycle();
        gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(mSolidColor);
        gradientDrawable.setShape(GradientDrawable.RECTANGLE);
        gradientDrawable.setCornerRadius(mCornersRadius);
        gradientDrawable.setStroke(mBorderWidth, mBorderColor);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (gradientDrawable == null) {
            return;
        }
        setBackground(gradientDrawable);
    }

    public void setCornersRadius(int cornersRadius) {
        if (mCornersRadius == cornersRadius) {
            return;
        }
        mCornersRadius = cornersRadius;
        refreshDrawable();
    }

    public void setBorderWidth(int borderWidth) {
        if (mBorderWidth == borderWidth) {
            return;
        }
        mBorderWidth = borderWidth;
        refreshDrawable();
    }

    public void setBorderColor(int borderColor) {
        if (mBorderColor == borderColor) {
            return;
        }
        mBorderColor = borderColor;
        refreshDrawable();
    }

    public void setSolidColor(int solidColor) {
        if (mSolidColor == solidColor) {
            return;
        }
        mSolidColor = solidColor;
        refreshDrawable();
    }

    private void refreshDrawable() {
        if (gradientDrawable != null) {
            gradientDrawable.setStroke(mBorderWidth, mBorderColor);
            gradientDrawable.setColor(mSolidColor);
            gradientDrawable.setCornerRadius(mCornersRadius);
        }
        invalidate();
    }
}
