package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.xdja.eoa.commonwidget.R;


/**
 * Created by ldy on 2017/6/3.
 */
public class CircleProgress extends View {
    public static final int START_ANGLE = -90;
    @ColorInt
    private int ringColor = 0xffcccccc;

    @ColorInt
    private int progressColor = 0xff00b1ff;
    private final float density;
    private Paint paint;
    private int percent = 25;
    private RectF mRectF = new RectF();
    private int ringWidth;

    public CircleProgress(Context context) {
        this(context, null);
    }

    public CircleProgress(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        density = context.getResources().getDisplayMetrics().density;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs,
                    R.styleable.CircleProgress);
            if (a != null) {
                int n = a.getIndexCount();
                for (int i = 0; i < n; i++) {
                    int attr = a.getIndex(i);
                    if (attr == R.styleable.CircleProgress_ringColor) {
                        ColorStateList colorStateList = a.getColorStateList(attr);
                        ringColor = colorStateList.getDefaultColor();
                    } else if (attr == R.styleable.CircleProgress_progressColor) {
                        ColorStateList colorStateList = a.getColorStateList(attr);
                        progressColor = colorStateList.getDefaultColor();
                    } else if (attr == R.styleable.CircleProgress_strokeWidth) {
                        ringWidth = (int) a.getDimension(attr, 1 * density);
                    }
                }
                a.recycle();
            }
        }
        this.paint = new Paint();

        //设置圆环宽度
        if (ringWidth <= 0) {
            ringWidth = (int) (1 * density);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int width = getWidth();
        int center = width / 2;
        int radius = width / 2 - ringWidth / 2; //设置半径

        int degree = (int) (((float) percent / 100) * 360);


        //绘制圆环
        paint.reset();
        paint.setAntiAlias(true); //消除锯齿
        paint.setStyle(Paint.Style.STROKE); //绘制空心圆
        paint.setColor(ringColor);
        paint.setStrokeWidth(ringWidth);
        canvas.drawCircle(center, center, radius, paint);

        // 位置
        mRectF.left = ringWidth / 2; // 左上角x
        mRectF.top = ringWidth / 2; // 左上角y
        mRectF.right = width - ringWidth / 2; // 左下角x
        mRectF.bottom = width - ringWidth / 2; // 右下角y

        paint.setColor(progressColor);
        canvas.drawArc(mRectF, START_ANGLE, degree, false, paint);

    }

    public void setPercent(int percent) {
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        this.percent = percent;
        invalidate();
    }


}
