package com.xdja.eoa.commonwidget.widget;


import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;

import com.xdja.eoa.commonwidget.R;

import skin.support.widget.SkinCompatButton;


/**
 * created on 2018/5/2.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:通用button
 */
public class CommonButton extends SkinCompatButton {

    private float enableAlpha = 0.4f;
    private float pressAlpha = 0.7f;

    public CommonButton(Context context) {
        this(context, null);
    }

    private void init() {
        setStateListAnimator(null);
        setEnable();
    }

    public CommonButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CommonButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CommonButton);
        this.enableAlpha = typedArray.getFloat(R.styleable.CommonButton_alpha_enable, 0.4f);
        this.pressAlpha = typedArray.getFloat(R.styleable.CommonButton_alpha_press, 0.7f);
        typedArray.recycle();
        init();
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        setPress();
        setEnable();
        invalidate();
    }

    /**
     * 设置enable属性
     */
    private void setEnable() {
        boolean enabled = isEnabled();
        if (getAlpha() != 0) {
            setAlpha(enabled ? 1f : enableAlpha);
        }
    }

    /**
     * 设置press属性
     */
    private void setPress() {
        boolean pressed = isPressed();
        Drawable backgroundDrawable = getBackground();
        if (null != backgroundDrawable) {
            backgroundDrawable.setAlpha(pressed ? (int) (255 * pressAlpha) : 255);
        }
        ColorStateList colorStateList = getTextColors();
        if (null != colorStateList) {
            colorStateList = colorStateList.withAlpha(pressed ? (int) (255 * pressAlpha) : 255);
            setTextColor(colorStateList);
        }
    }
}
