package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.xdja.eoa.commonwidget.R;

/**
 * Created by zhuruyi on 2019/10/23
 */
public class EoaDialogHelper {
	/**
	 * 默认申请权限对话框
	 *
	 * @param context
	 * @param save
	 * @param cancel
	 */
	public static void showDefaultPermissionDialog(Context context, View.OnClickListener save, View.OnClickListener cancel) {
		showPermissionDialog(context, context.getString(R.string.common_permission_title), context.getString(R.string.common_permission_msg), context.getString(R.string.common_permission_pos), context.getString(R.string.common_permission_nega), save, cancel);
	}

	/**
	 * 创建对话框
	 *
	 * @param context
	 * @param title
	 * @param msg
	 * @param posBtn
	 * @param negaBtn
	 * @param save
	 * @param cancel
	 */
	public static void showPermissionDialog(Context context, String title, String msg, String posBtn, String negaBtn, final View.OnClickListener save, final View.OnClickListener cancel) {
		final CustomDialog draftDialog = new CustomDialog(context);
		if (!TextUtils.isEmpty(title)) {
		    draftDialog.setTitle(title);
		}
		if (!TextUtils.isEmpty(msg)) {
		    draftDialog.setMessage(msg);
		}
		draftDialog.setOkButton(negaBtn, new View.OnClickListener() {
		    @Override
		    public void onClick(View v) {
		        draftDialog.dismiss();
		        if (cancel != null) {
		            cancel.onClick(v);
		        }
		    }
		});
		draftDialog.setCancelButton(posBtn, new View.OnClickListener() {
		    @Override
		    public void onClick(View v) {
		        draftDialog.dismiss();
		        if (save != null) {
		            save.onClick(v);
		        }
		    }
		});
		draftDialog.show();
	}
}
