package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.provider.Settings;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.eoa.commonwidget.R;

/**
 * Created by ldy on 2017/8/8.
 */

public class ErrorRetryView extends FrameLayout {
    private Context mContext;
    protected View errorView;
    private TextView errorTv;
    private TextView refreshBtn;
    private TextView settingsBtn;
    private LinearLayout operateLayout;

    public ErrorRetryView(@NonNull Context context) {
        this(context, null);
    }

    public ErrorRetryView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        errorView = LayoutInflater.from(context).inflate(R.layout.layout_error_retry, null);
        errorTv = errorView.findViewById(R.id.net_error_tip);
        operateLayout = errorView.findViewById(R.id.ll_operate);
        refreshBtn = errorView.findViewById(R.id.btn_refresh);
        settingsBtn = errorView.findViewById(R.id.btn_setting);
        settingsBtn.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(Settings.ACTION_WIFI_SETTINGS);
                mContext.startActivity(intent);
            }
        });
        errorView.setVisibility(View.GONE);
        addView(errorView);
    }

    public void setErrorView(@DrawableRes int errorDrawableRes, @StringRes int errorStringRes, @Nullable OnClickListener listener) {
        Drawable drawableTop = getContext().getResources().getDrawable(errorDrawableRes);
        drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        errorTv.setCompoundDrawables(null, drawableTop, null, null);
        errorTv.setText(errorStringRes);
        errorTv.setOnClickListener(listener);
        errorView.setVisibility(View.VISIBLE);
    }

    public void setErrorView(@DrawableRes int errorDrawableRes, String errorString, @Nullable OnClickListener listener) {
        Drawable drawableTop = getContext().getResources().getDrawable(errorDrawableRes);
        drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        errorTv.setCompoundDrawables(null, drawableTop, null, null);
        errorTv.setText(errorString);
        errorTv.setOnClickListener(listener);
        errorView.setVisibility(View.VISIBLE);
    }

    public void setErrorTextColor(@ColorInt int color) {
        errorTv.setTextColor(color);
    }

    public void setErrorView(@StringRes int errorStringRes, @Nullable OnClickListener listener) {
        setErrorView(R.drawable.ic_data_failure, errorStringRes, listener);
    }

    public void setErrorView(String errorString, @Nullable OnClickListener listener) {
        setErrorView(R.drawable.ic_data_failure, errorString, listener);
    }

    public void setErrorView(@StringRes int errorStringRes) {
        setErrorView(errorStringRes, null);
    }

    public void setErrorView(String errorString) {
        setErrorView(errorString, null);
    }

    public void showRefreshView(@StringRes int refreshStringRes, @Nullable OnClickListener listener) {
        operateLayout.setVisibility(View.VISIBLE);
        refreshBtn.setText(refreshStringRes);
        refreshBtn.setVisibility(View.VISIBLE);
        refreshBtn.setOnClickListener(listener);
        errorView.setVisibility(View.VISIBLE);
    }

    public void showRefreshView(@Nullable OnClickListener listener) {
        showRefreshView(R.string.common_refresh, listener);
    }

    public void hideOperateView() {
        operateLayout.setVisibility(View.GONE);
    }

    public void hideRefreshView() {
        refreshBtn.setVisibility(View.GONE);
        refreshBtn.setOnClickListener(null);
    }


    public void showSettingsView(@StringRes int settingsStringRes, @Nullable OnClickListener listener) {
        operateLayout.setVisibility(View.VISIBLE);
        settingsBtn.setText(settingsStringRes);
        settingsBtn.setVisibility(View.VISIBLE);
//        settingsBtn.setOnClickButtonListener(listener);
        errorView.setVisibility(View.VISIBLE);
    }

    public void showSettingsView(@StringRes int settingsStringRes) {
        showSettingsView(settingsStringRes, null);
    }

    public void showSettingsView() {
        showSettingsView(R.string.common_set_net);
    }

    public void hideSettingsView() {
        settingsBtn.setVisibility(View.GONE);
        settingsBtn.setOnClickListener(null);
    }

    public static ErrorRetryView addErrorRetryView(ViewGroup viewGroup, OnClickListener onClickListener) {
        ErrorRetryView errorRetryView = new ErrorRetryView(viewGroup.getContext());
        errorRetryView.setErrorView(R.string.common_net_error);
        errorRetryView.showRefreshView(onClickListener);
        errorRetryView.showSettingsView();
        viewGroup.addView(errorRetryView, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        return errorRetryView;
    }

    public static ErrorRetryView addErrorRetryView(ViewGroup viewGroup) {
        ErrorRetryView errorRetryView = new ErrorRetryView(viewGroup.getContext());
        errorRetryView.setErrorView(R.string.common_net_error);
        errorRetryView.showSettingsView();
        viewGroup.addView(errorRetryView, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        return errorRetryView;
    }

    public void retrySuccess(ViewGroup viewGroup) {
        setVisibility(GONE);
        viewGroup.removeView(this);
        viewGroup.invalidate();
    }
}
