package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.xdja.eoa.commonwidget.R;

import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;


/**
 * <p>summary:</p>
 * <p>description:</p>
 * <p>author:fanjiandong</p>
 * <p>time:2015/3/30 16:55</p>
 */
public class FlipPoint extends LinearLayout implements SkinCompatSupportable {
    /**
     * 当前显示的所引致
     */
    private int index;
    /**
     * 总共多少个点
     */
    private int total;
    /**
     * 打开的宽度
     */
    private int onWidth;

    /**
     * 关闭的宽度
     */
    private int offWidth;
    /**
     * 打开的高度
     */
    private int onHeight;

    /**
     * 关闭的高度
     */
    private int offHeight;
    /**
     * 点与点之间的间距
     */
    private int divider;
    /**
     * 每个点选中的显示内容
     */
    private int pointSelectedResId;
    /**
     * 未选中的点的显示内容
     */
    private int pointNoneSelectedResId;

    private ImageView[] points;

    public FlipPoint(Context context) {
        super(context);
        this.setOrientation(HORIZONTAL);
    }

    public FlipPoint(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(attrs);
    }

    public FlipPoint(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        this.setOrientation(HORIZONTAL);
        TypedArray a = getContext().obtainStyledAttributes(attrs,
                R.styleable.FlipPoint);
        index = a.getInteger(R.styleable.FlipPoint_index, 0);
        total = a.getInteger(R.styleable.FlipPoint_total, 0);
        onWidth = a.getDimensionPixelOffset(R.styleable.FlipPoint_pointOnWidth, LayoutParams.WRAP_CONTENT);
        offWidth = a.getDimensionPixelOffset(R.styleable.FlipPoint_pointOffWidth, LayoutParams.WRAP_CONTENT);
        onHeight = a.getDimensionPixelOffset(R.styleable.FlipPoint_pointOnHeight, LayoutParams.WRAP_CONTENT);
        offHeight = a.getDimensionPixelOffset(R.styleable.FlipPoint_pointOffHeight, LayoutParams.WRAP_CONTENT);
        divider = a.getDimensionPixelOffset(R.styleable.FlipPoint_pointMargin, 32);
        pointSelectedResId = a.getResourceId(R.styleable.FlipPoint_pointSelcted, SkinCompatHelper.INVALID_ID);
        pointNoneSelectedResId = a.getResourceId(R.styleable.FlipPoint_pointNoneSelected, SkinCompatHelper.INVALID_ID);
        refreshView();
        a.recycle();
    }

    private void refreshView() {
        if (this.getChildCount() != 0) {
            this.removeAllViews();
        }
        points = new ImageView[total];
        for (int i = 0; i < total; i++) {
            ImageView view = new ImageView(getContext());
//            view.setBackground(pointNoneSelectedResId);

            LinearLayout.LayoutParams onll = new LinearLayout.LayoutParams(onWidth, onHeight);
            LinearLayout.LayoutParams offll = new LinearLayout.LayoutParams(offWidth, offHeight);
            if (i != 0) {
                onll.setMargins(divider, 0, 0, 0);
                offll.setMargins(divider, 0, 0, 0);
            } else {
                onll.setMargins(0, 0, 0, 0);
                offll.setMargins(0, 0, 0, 0);
            }
            if (i == index) {
                view.setLayoutParams(onll);
                view.setImageDrawable(SkinCompatResources.getDrawable(getContext(), pointSelectedResId));
            } else {
                view.setImageDrawable(SkinCompatResources.getDrawable(getContext(), pointNoneSelectedResId));
                view.setLayoutParams(offll);
            }
            this.addView(view);
            this.setGravity(Gravity.CENTER);
            points[i] = view;
        }
        invalidate();
    }

    /**
     * @param index {@link}
     */
    public void setIndex(int index) {
        this.index = index;
        try {
            refreshView();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getIndex() {
        return index;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
        refreshView();
    }


    public int getDivider() {
        return divider;
    }

    public void setDivider(int divider) {
        this.divider = divider;
    }

    @Override
    public void applySkin() {
        if (points == null || points.length < 1) {
            return;
        }
        for (int i = 0; i < points.length; i++) {
            ImageView pointView = points[i];
            if (i == index) {
                pointView.setImageDrawable(SkinCompatResources.getDrawable(getContext(), pointSelectedResId));
            } else {
                pointView.setImageDrawable(SkinCompatResources.getDrawable(getContext(), pointNoneSelectedResId));
            }
        }
    }
}
