package com.xdja.eoa.commonwidget.widget.IconTextView;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.eoa.commonwidget.R;


/**
 * Created by ldy on 2016/11/22.
 */

public class IconTextView extends LinearLayout {

    private ImageView imageView;
    private TextView textView;
    float density = 1;

    public IconTextView(Context context) {
        this(context, null);
    }

    public IconTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        density = context.getResources().getDisplayMetrics().density;

        setOrientation(HORIZONTAL);
        setGravity(Gravity.CENTER);

        imageView = new ImageView(context, attrs);
        textView = new TextView(context, attrs);

        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.setMargins((int) (6 * density), 0, 0, 0);

        TypedArray a = context.obtainStyledAttributes(attrs,
                R.styleable.IconTextView);
        if (a != null) {
            int n = a.getIndexCount();
            for (int i = 0; i < n; i++) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.IconTextView_space) {
                    params.setMargins((int) a.getDimension(attr, 6 * density), 0, 0, 0);
                }
            }
            a.recycle();
        }
        addView(imageView);
        addView(textView, params);
    }

    public void setText(String string) {
        textView.setText(string);
    }

    public void setTextColor(@ColorRes int colorId) {
        textView.setTextColor(getResources().getColor(colorId));
    }

    public void setSpace(float dp) {
        ((LinearLayout.LayoutParams) textView.getLayoutParams()).setMargins((int) (density * dp), 0, 0, 0);
    }

    public void setTextSize(float sp) {
        textView.setTextSize(sp);
    }

    public void setImageResource(@DrawableRes int resId) {
        imageView.setImageResource(resId);
    }
}
