package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;

import com.xdja.eoa.commonwidget.R;

/**
 * Created by @author zhuruyi on 2019/11/26
 */
public class PlaceHolderLayout extends FrameLayout {
	private View targetView;
	private ViewStub emptyViewStub;
	private ViewStub errorViewStub;
	private ViewStub loadingViewStub;

	private View emptyView;
	private View errorView;
	private View loadingView;

	public PlaceHolderLayout(@NonNull Context context) {
		super(context);
	}

	public PlaceHolderLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
		this(context, attrs, 0);
	}

	public PlaceHolderLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
		this(context, attrs, defStyleAttr, 0);
	}

	public PlaceHolderLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
		super(context, attrs, defStyleAttr, defStyleRes);
		init(attrs, defStyleAttr, defStyleRes);
	}

	private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
		errorViewStub = new ViewStub(getContext());
		emptyViewStub = new ViewStub(getContext());
		loadingViewStub = new ViewStub(getContext());

		TypedArray array = getContext().obtainStyledAttributes(attrs, R.styleable.PlaceHolderLayout, defStyleAttr, defStyleRes);

		int emptyResId = array.getResourceId(R.styleable.PlaceHolderLayout_empty_layout, R.layout.common_errorretry);
		int errorResId = array.getResourceId(R.styleable.PlaceHolderLayout_empty_layout, R.layout.common_errorretry);
		int loadingResId = array.getResourceId(R.styleable.PlaceHolderLayout_loading_layout, R.layout.common_widget_loading);

		array.recycle();

		emptyViewStub.setLayoutResource(emptyResId);
		errorViewStub.setLayoutResource(errorResId);
		loadingViewStub.setLayoutResource(loadingResId);
	}

	@Override
	public boolean canScrollVertically(int direction) {
		try {
			return targetView.canScrollVertically(direction);
		} catch (Exception e) {
			e.printStackTrace();
			return super.canScrollVertically(direction);
		}
	}

	@Override
	public void addView(View child, int index, ViewGroup.LayoutParams params) {
		boolean isStub = child instanceof ViewStub;
		if (!isStub && targetView == null) {
			targetView = child;
		}
		super.addView(child, index, params);
	}

	@Override
	protected void onFinishInflate() {
		super.onFinishInflate();
		if (getChildCount() > 1) {
			throw new IllegalStateException("PlaceHolderLayout can host only one direct child");
		}

		addView(emptyViewStub, LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		addView(errorViewStub, LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
		addView(loadingViewStub, LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
	}

	/**
	 * 初始化empty view， 通过viewstub初始化
	 *
	 * @param callback 通过callback将empty view丢回去，由外界自己设置提示
	 */
	public void showEmpty(@NonNull Callback callback) {
		hideErrorView();
		hideTargetView();
		hideLoadingView();
		if (emptyView == null) {
			if (emptyViewStub.getLayoutResource() == -1) {
				throw new IllegalStateException("you must set empty_layout");
			}

			emptyView = emptyViewStub.inflate();
		} else {
			emptyView.setVisibility(View.VISIBLE);
		}

		callback.call(emptyView);
	}

	/**
	 * 初始化error view， 通过view stub初始化
	 *
	 * @param callback 通过callback将error view丢回去，由外界自己设置提示
	 */
	public void showError(@NonNull Callback callback) {
		hideEmptyView();
		hideTargetView();
		hideLoadingView();
		if (errorView == null) {
			if (errorViewStub.getLayoutResource() == -1) {
				throw new IllegalStateException("you must set error_layout");
			}

			errorView = errorViewStub.inflate();
		} else {
			errorView.setVisibility(View.VISIBLE);
		}

		callback.call(errorView);
	}

	public void hideAll() {
		hideEmptyView();
		hideErrorView();
		hideLoadingView();
		hideTargetView();
	}

	public void hideTargetView(){
		hideView(targetView);
	}

	public void showTargetView(){
		hideEmptyView();
		hideErrorView();
		hideLoadingView();
		if(targetView != null && targetView.getVisibility() == View.GONE){
			targetView.setVisibility(View.VISIBLE);
		}
	}

	public void showloading(@NonNull Callback callback) {
		hideEmptyView();
		hideErrorView();
		hideTargetView();
		if (loadingView == null) {
			if (loadingViewStub.getLayoutResource() == -1) {
				throw new IllegalStateException("you must set error_layout");
			}

			loadingView = loadingViewStub.inflate();
		} else {
			loadingView.setVisibility(View.VISIBLE);
		}

		callback.call(loadingView);
	}

	public void hideEmptyView() {
		hideView(emptyView);
	}

	public void hideErrorView() {
		hideView(errorView);
	}

	public void hideLoadingView() {
		hideView(loadingView);
	}

	private void hideView(View v) {
		if (v != null && v.getVisibility() == View.VISIBLE) {
			v.setVisibility(View.GONE);
		}
	}

	public interface Callback {
		void call(View v);
	}

	public static Callback emptyCallback = new Callback() {
		@Override
		public void call(View v) {

		}
	};
}
