package com.xdja.eoa.commonwidget.widget;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lujianchao on 2017/7/28.
 *
 * @author wangkezhi
 */

public class PraiseTextView extends TextView {

    //色值
    public static final String cor1 = "#333333";
    public static final String cor2 = "#666666";
    public static final String cor3 = "#999999";
    public static final String cor4 = "#cccccc";
    public static final String cor5 = "#e5e5e5";
    public static final String cor6 = "#00b1ff";
    public static final String cor7 = "#ffffff";
    public static final String cor8 = "#d9414e";
    public static final String cor9 = "#f0f0f0";
    //字体
    public static final int size1 = 18;
    public static final int size2 = 16;
    public static final int size3 = 14;
    public static final int size4 = 12;
    public static final int size5 = 15;

    private List<PraiseInfo> mPraiseInfos = new ArrayList<>();

    private onPraiseClickListener mListener;

    private static final int defaultValue = -1;

    /**
     * 名字文字颜色
     * 分割文本用textview默认的，自行设置即可
     */
    private String mNameTextColor;

    /**
     * 名字文字大小
     */
    private int mNameTextSize = defaultValue;

    /**
     * 分割符文本
     */
    private String mMiddleStr = "，";

    /**
     * 分隔符颜色
     */
    private String mMiddleColor;

    /**
     * 分隔符大小
     */
    private int mMiddleSize = defaultValue;

    public PraiseTextView(Context context) {
        super(context);
    }

    public PraiseTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public String getmNameTextColor() {
        return mNameTextColor;
    }

    public int getmNameTextSize() {
        return mNameTextSize;
    }

    public String getmMiddleColor() {
        return mMiddleColor;
    }

    public int getmMiddleSize() {
        return mMiddleSize;
    }

    public String getMiddleStr() {
        return mMiddleStr;
    }

    public List<PraiseInfo> getList() {
        return mPraiseInfos;
    }

    public PraiseTextView setmNameTextColor(String mNameTextColor) {
        this.mNameTextColor = mNameTextColor;
        return this;
    }

    public PraiseTextView setmNameTextSize(int mNameTextSize) {
        this.mNameTextSize = mNameTextSize;
        return this;
    }

    public PraiseTextView setmMiddleStr(String mMiddleStr) {
        this.mMiddleStr = mMiddleStr;
        return this;
    }

    public PraiseTextView setmMiddleColor(String mMiddleColor) {
        this.mMiddleColor = mMiddleColor;
        return this;
    }

    public PraiseTextView setmMiddleSize(int mMiddleSize) {
        this.mMiddleSize = mMiddleSize;
        return this;
    }

    public PraiseTextView setonPraiseListener(onPraiseClickListener mListener) {
        this.mListener = mListener;
        return this;
    }

    /**
     * 添加单条数据
     *
     * @param index 插入点
     * @param info  单条数据
     * @return
     */
    public PraiseTextView addData(int index, PraiseInfo info) {
        this.mPraiseInfos.add(index, info);
        return this;
    }

    /**
     * 添加多条数据
     *
     * @param index 插入点
     * @param list  数据列表
     * @return
     */
    public PraiseTextView addData(int index, List<PraiseInfo> list) {
        this.mPraiseInfos.addAll(index, list);
        return this;
    }

    /**
     * 设置数据列表
     * 设置前，清空原有数据
     *
     * @param list 数据
     * @return
     */
    public PraiseTextView addNewData(List<PraiseInfo> list) {
        this.mPraiseInfos.clear();
        this.mPraiseInfos = list;
        return this;
    }

    /**
     * 刷新数据
     */
    public void apply() {
        this.setHighlightColor(Color.TRANSPARENT);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setText(getPraiseString());
    }

    private SpannableStringBuilder getPraiseString() {
        SpannableStringBuilder mBuilder = new SpannableStringBuilder();
        for (int mI = 0; mI < mPraiseInfos.size(); mI++) {
            //判断null
            if (TextUtils.isEmpty(mPraiseInfos.get(mI).getNickname())) {
                return mBuilder;
            }
            //拼接文本
            mBuilder.append(mPraiseInfos.get(mI).getNickname() + mMiddleStr);
            //设置点击文本
            final int finalMI = mI;
            mBuilder.setSpan(new ClickableSpan() {
                @Override
                public void onClick(final View mView) {
                    if (mListener != null) {
                        mListener.onClick(finalMI, mPraiseInfos.get(finalMI));
                    }
                }

                @Override
                public void updateDrawState(final TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setUnderlineText(false);
                    if (!TextUtils.isEmpty(mNameTextColor)) {
                        ds.setColor(Color.parseColor(mNameTextColor));
                    }
                    if (mNameTextSize != -1) {
                        ds.setTextSize(sp2px(mNameTextSize));
                    }
                }
            }, mBuilder.length() - mPraiseInfos.get(mI).getNickname().length() - mMiddleStr.length(), mBuilder.length() - mMiddleStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            //设置分割符文本
            //if (mBuilder.length() - mMiddleColor.length() < 0) continue;
//            Log.v("=====","mBuilder:"+mBuilder.toString()+"  mBuilder.length() - mMiddleColor.length()"+(mBuilder.length() - mMiddleStr.length())+"  mBuilder.length()"+mBuilder.length()+"    mMiddleColor.length()"+ mMiddleStr.length()+"    mMiddleColor "+ mMiddleStr.toString());
            mBuilder.setSpan(new ClickableSpan() {
                @Override
                public void onClick(final View mView) {
                }

                @Override
                public void updateDrawState(final TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setUnderlineText(false);
                    if (!TextUtils.isEmpty(mMiddleColor)) {
                        ds.setColor(Color.parseColor(mMiddleColor));
                    }
                    if (mMiddleSize != -1) {
                        ds.setTextSize(sp2px(mMiddleSize));
                    }
                }
            }, mBuilder.length() - mMiddleStr.length(), mBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);

        }
        //去除末尾
        mBuilder = new SpannableStringBuilder(mBuilder, 0, mBuilder.length() - mMiddleStr.length());
        return mBuilder;
    }

    private int sp2px(float spValue) {
        final float fontScale = getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int) (spValue * fontScale + 0.5f);
    }

    public interface onPraiseClickListener {
        void onClick(int position, PraiseInfo mPraiseInfo);
    }

    public static class PraiseInfo {
        private long id;
        private String nickname;

        public PraiseInfo() {
        }

        public PraiseInfo(long id, String nickname) {
            this.id = id;
            this.nickname = nickname;
        }

        @Override
        public String toString() {
            return "PraiseInfo{" +
                    "id=" + id +
                    ", nickname='" + nickname + '}';
        }

        public long getId() {
            return id;
        }

        public PraiseInfo setId(final long mId) {
            id = mId;
            return this;
        }

        public String getNickname() {
            return nickname;
        }

        public PraiseInfo setNickname(final String mNickname) {
            nickname = mNickname;
            return this;
        }
    }
}
