package com.xdja.eoa.commonwidget.widget.infinitepager;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;

/**
 * Created by ldy on 2017/7/11.
 */

public abstract class InfiniteAdapter extends FragmentPagerAdapter implements ViewPager.OnPageChangeListener {
    public static final int START_POSITION = Integer.MAX_VALUE / 2;

    public InfiniteAdapter(FragmentManager fm) {
        super(fm);
    }

    @Override
    public int getCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Fragment getItem(int position) {
        return getItemByDiff(getDiff(position));
    }

    public int getDiff(int position) {
        return position - START_POSITION;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
        onPageSelectedByDiff(getDiff(position));
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    /**
     * 获取对应位置的fragment
     *
     * @param diffPosition 与初始位置的差异
     */
    protected abstract Fragment getItemByDiff(int diffPosition);

    /**
     * 对应差异位置的page被滑动到
     */
    protected void onPageSelectedByDiff(int diffPosition) {

    }
}
