package com.xdja.eoa.commonwidget.widget.ninegridlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntDef;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.xdja.eoa.commonwidget.R;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MediaImageView extends ImageView {

    private BitmapDrawable flagDrawable;

    private
    int flagGravity = Gravity.CENTER;

    private Point flagLocation;

    private float flagMargin = 10;

    public MediaImageView(Context context) {
        this(context, null);
    }

    public MediaImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MediaImageView);
            this.flagDrawable = (BitmapDrawable) typedArray.getDrawable(R.styleable.MediaImageView_miv_flagDrawable);
            this.flagGravity = typedArray.getInt(R.styleable.MediaImageView_miv_flagGravity, Gravity.CENTER);
            this.flagMargin = typedArray.getDimensionPixelSize(R.styleable.MediaImageView_miv_flagMargin, 10);
            typedArray.recycle();
        }
    }

    public void setFlagResource(@DrawableRes int flagRes) {
        setFlagDrawable((BitmapDrawable) getContext().getResources().getDrawable(flagRes));
    }

    public void setFlagDrawable(BitmapDrawable flagDrawable) {
        this.flagDrawable = flagDrawable;
        invalidate();
    }

    public void setFlagGravity(int flagGravity) {
        this.flagGravity = flagGravity;
        invalidate();
    }

    public void setFlagMargin(@DimenRes int mFlagMargin) {
        this.flagMargin = getResources().getDimensionPixelSize(mFlagMargin);
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (getDrawable() == null) {
            return;
        }
        if (flagDrawable != null) {
//            canvas.drawColor(Color.GRAY, PorterDuff.Mode.MULTIPLY);
            Bitmap flagBitMap = flagDrawable.getBitmap();
            Point location = getFlagBitmap(flagBitMap, flagGravity);
            canvas.drawBitmap(flagBitMap, location.x, location.y, null);
        }
    }

    private Point getFlagBitmap(Bitmap bit, int gravity) {
        if (this.flagLocation == null) {
            this.flagLocation = new Point();
        }

        switch (gravity) {
            case Gravity.CENTER:
                flagLocation.x = (getWidth() - bit.getWidth()) / 2;
                flagLocation.y = (getHeight() - bit.getHeight()) / 2;
                break;

            case Gravity.TOP_LEFT:
                flagLocation.x = (int) flagMargin;
                flagLocation.y = (int) flagMargin;
                break;
            case Gravity.TOP_RIGHT:
                flagLocation.x = (int) (getWidth() - bit.getWidth() - flagMargin);
                flagLocation.y = (int) flagMargin;
                break;
            case Gravity.BOTTOM_RIGHT:
                flagLocation.x = (int) (getWidth() - bit.getWidth() - flagMargin);
                flagLocation.y = (int) (getHeight() - bit.getHeight() - flagMargin);
                break;

            case Gravity.BOTTOM_LEFT:
                flagLocation.x = (int) flagMargin;
                flagLocation.y = (int) (getHeight() - bit.getHeight() - flagMargin);
                break;
            default:
                flagLocation.x = (getWidth() - bit.getWidth()) / 2;
                flagLocation.y = (getHeight() - bit.getHeight()) / 2;
                break;
        }

        return flagLocation;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        setImageDrawable(null);
    }

    public static class Gravity {

        @IntDef({CENTER,
                BOTTOM_RIGHT,
                BOTTOM_LEFT,
                TOP_RIGHT,
                TOP_LEFT
        })
        @Retention(RetentionPolicy.SOURCE)

        public @interface type {
        }

        public static final int CENTER = 0;
        public static final int BOTTOM_RIGHT = 1;

        public static final int BOTTOM_LEFT = 2;

        public static final int TOP_RIGHT = 3;

        public static final int TOP_LEFT = 4;
    }
}