package com.xdja.eoa.commonwidget.widget.refreshloading;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.xdja.eoa.commonwidget.widget.utils.WidgetUtils;

/**
 * Created by hjl on 2017/5/10.
 */

public abstract class BaseLoadingMoreFooter extends LinearLayout {

    public final static int STATE_LOADING = 0;
    public final static int STATE_COMPLETE = 1;
    public final static int STATE_NOMORE = 2;
    public final static int STATE_LOADING_FAILURE = 3;

    View mContainer;

    public BaseLoadingMoreFooter(Context context) {
        this(context, null);
    }

    public BaseLoadingMoreFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContainer = LayoutInflater.from(getContext()).inflate(getHeaderResId(), null);
        LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        setLayoutParams(lp);
        addView(mContainer, new LayoutParams(LayoutParams.MATCH_PARENT, WidgetUtils.dp2px(context, 48)));
        setGravity(Gravity.CENTER);
        initView();
    }


    public void setState(int state) {
        switch (state) {
            case STATE_LOADING:
                onShowLoading();
                mContainer.setVisibility(View.VISIBLE);
                this.setVisibility(View.VISIBLE);
                break;
            case STATE_COMPLETE:
                onShowLoadingDone();
                mContainer.setVisibility(View.GONE);
                this.setVisibility(View.GONE);
                break;
            case STATE_NOMORE:
                onShowNoMore();
                mContainer.setVisibility(View.VISIBLE);
                this.setVisibility(View.VISIBLE);
                break;
            case STATE_LOADING_FAILURE:
                onShowLoadFailure();
                mContainer.setVisibility(View.VISIBLE);
                this.setVisibility(View.VISIBLE);
                break;
            default:
                this.setVisibility(View.GONE);
                break;
        }
    }

    protected abstract void onShowLoading();

    protected abstract void onShowNoMore();

    protected abstract void onShowLoadingDone();

    protected abstract void onShowLoadFailure();

    protected abstract void initView();

    protected abstract
    @LayoutRes
    int getHeaderResId();
}
