package com.xdja.eoa.commonwidget.widget.refreshloading;

import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.LayoutRes;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

/**
 * Created by hjl on 2017/5/9.
 */

public abstract class BaseRefreshHeader extends LinearLayout implements IRefreshHeader {

    View mContainer;


    private int mState = STATE_NORMAL;
    public int mMeasuredHeight;

    public BaseRefreshHeader(Context context) {
        this(context, null);
    }

    public BaseRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContainer = LayoutInflater.from(getContext()).inflate(getHeaderResId(), null);
        LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        lp.setMargins(0, 0, 0, 0);
        this.setLayoutParams(lp);
        this.setPadding(0, 0, 0, 0);
        addView(mContainer, new LayoutParams(LayoutParams.MATCH_PARENT, 0));
        setGravity(Gravity.BOTTOM);
        initView();
        measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mMeasuredHeight = getMeasuredHeight();
    }


    @Override
    public void onMove(float delta) {
        if (getVisibleHeight() > 0 || delta > 0) {
            setVisibleHeight((int) delta + getVisibleHeight());
            if (mState <= STATE_RELEASE_TO_REFRESH) {
                if (getVisibleHeight() > mMeasuredHeight) {
                    setState(STATE_RELEASE_TO_REFRESH);
                } else {
                    setState(STATE_NORMAL);
                }
            }
        }
    }

    @Override
    public void setState(int state) {
        if (state == mState) {
            return;
        }

        switch (state) {
            case STATE_NORMAL:
                onPreReFresh();
                break;
            case STATE_RELEASE_TO_REFRESH:
                onRelease2ReFresh();
                break;
            case STATE_REFRESHING:
                onReFreshing();
                smoothScrollTo(mMeasuredHeight);
                break;
            case STATE_DONE:
                onReFreshDone();
                break;
            default:
                onPreReFresh();
                break;
        }

        mState = state;
    }

    @Override
    public boolean releaseAction() {
        boolean isOnRefresh = false;
        int height = getVisibleHeight();
        if (height == 0)
            isOnRefresh = false;

        if (getVisibleHeight() > mMeasuredHeight && mState < STATE_REFRESHING) {
            smoothScrollTo(mMeasuredHeight - getVisibleHeight());
            setState(STATE_REFRESHING);
            isOnRefresh = true;
        }
        // refreshing and header isn't shown fully. do nothing.
        if (mState == STATE_REFRESHING && height <=  mMeasuredHeight) {
            //return;
        }
        if (mState != STATE_REFRESHING) {
            smoothScrollTo(0);
        }
        return isOnRefresh;
    }

    @Override
    public void refreshComplete() {
        setState(STATE_DONE);
        new Handler().postDelayed(new Runnable(){
            public void run() {
                reset();
            }
        }, 200);
    }

    public void reset() {
        smoothScrollTo(0);
        new Handler().postDelayed(new Runnable() {
            public void run() {
                setState(STATE_NORMAL);
            }
        }, 500);
    }

    private void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt(getVisibleHeight(), destHeight);
        animator.setDuration(300).start();
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                setVisibleHeight((int) animation.getAnimatedValue());
            }
        });
        animator.start();
    }

    public void setVisibleHeight(int height) {
        if (height < 0) height = 0;
        LayoutParams lp = (LayoutParams) mContainer.getLayoutParams();
        lp.height = height;
        mContainer.setLayoutParams(lp);
    }

    public int getVisibleHeight() {
        LayoutParams lp = (LayoutParams) mContainer.getLayoutParams();
        return lp.height;
    }

    protected View getContainView() {
        return mContainer;
    }

    public int getState() {
        return mState;
    }

    protected abstract @LayoutRes int getHeaderResId();

    /**
     * 刷新准备
     */
    protected abstract void onPreReFresh();

    /**
     * 可以RELEASE刷新
     */
    protected abstract void onRelease2ReFresh();

    /**
     * 正在刷新
     */
    protected abstract void onReFreshing();


    /**
     * 刷新结束
     */
    protected abstract void onReFreshDone();

    protected abstract void initView();
}
