package com.xdja.eoa.commonwidget.widget.refreshloading;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;

/**
 * Created by hjl on 2017/5/10.
 */

public class CustomRefreshHeader extends BaseRefreshHeader {

    private ImageView headPbar;
    private AnimationDrawable animationDrawable;

    public CustomRefreshHeader(Context context) {
        this(context,null);
    }

    public CustomRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected int getHeaderResId() {
//        return R.layout.layout_list_refresh_header;
        return 0;
    }

    @Override
    protected void onPreReFresh() {
        if (animationDrawable.isRunning()){
            animationDrawable.stop();
        }
    }

    @Override
    protected void onRelease2ReFresh() {
        if(!animationDrawable.isRunning()){
            animationDrawable.start();
        }

    }

    @Override
    protected void onReFreshing() {
        if (!animationDrawable.isRunning()){
            animationDrawable.start();
        }
    }

    @Override
    protected void onReFreshDone() {
        if (animationDrawable.isRunning()){
            animationDrawable.stop();
        }
    }

    @Override
    protected void initView() {
//        headPbar = findViewById(R.id.iv_head_pbar);
        animationDrawable = (AnimationDrawable) headPbar.getDrawable();
    }
}
