package com.xdja.eoa.commonwidget.widget.utils;

import android.content.Context;


/**
 * @author jarlen
 * @date 2020/1/6
 * UI组件工具类
 */
public class WidgetUtils {
    /**
     * 将dip或dp值转换为px值，保证尺寸大小不变
     *
     * @param dipValue
     * @return
     */
    public static int dp2px(Context context, float dipValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    public static int px2dp(Context context, int dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue / scale);
    }
}
