package com.xdja.widget.datetimepicker;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.bigkoo.pickerview.listener.CustomListener;
import com.bigkoo.pickerview.listener.ISelectTimeCallback;
import com.contrarywind.view.WheelView;
import com.xdja.widget.datetimepicker.utils.CalendarUtils;
import com.xdja.widget.datetimepicker.view.TimeSelectView;

import java.lang.reflect.Field;
import java.util.Calendar;

/**
 * Created by wangkezhi on 2018/1/30.
 * 封装日期选择器
 * 可自定义起止日期，当前日期，父view，年月日，上午下午
 */
public class DateAmPmPickerDialog extends DialogFragment {
    private OnPickerListener onPickerListener;//选择日期回调
    private TimeSelectView pvTime = null;
    private boolean isYear, isMonth, isDay = true;//是否使用年月日
    private boolean isAmpm = false;//是否使用上午下午
    private Long startDate, endDate, selectDate = null;//开始，结束，当前日期
    private ViewGroup parentView = null;
    private RadioGroup radioGroup = null;
    private Boolean isAm;//上下午初始化，true上午，false下午，null不设置

    @Override
    public void onStart() {
        super.onStart();
        Window win = getDialog().getWindow();
        // 一定要设置Background，如果不设置，window属性设置无效
        win.setBackgroundDrawable(new ColorDrawable(getResources().getColor(R.color.datetimepicker_transport)));
        DisplayMetrics dm = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        WindowManager.LayoutParams params = win.getAttributes();
        params.gravity = Gravity.BOTTOM;
        // 使用ViewGroup.LayoutParams，以便Dialog 宽度充满整个屏幕
        params.width = ViewGroup.LayoutParams.MATCH_PARENT;
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        win.setAttributes(params);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return initTimePicker(selectDate, startDate, endDate, parentView);
    }

    /**
     * 初始化参数
     *
     * @param selectDate 当前日期,如果为null，则默认为当前日期
     * @param startDate  开始日期，null则不限制
     * @param endDate    结束日期，null则不限制
     * @return
     */
    public DateAmPmPickerDialog setParam(Long selectDate, Long startDate, Long endDate) {
        this.selectDate = selectDate;
        this.startDate = startDate;
        this.endDate = endDate;
        return this;
    }

    /**
     * 创建dialogView
     *
     * @param selectdate 当前日期,如果为null，则默认为当前日期
     * @param startdate  开始日期，null则不限制
     * @param enddate    结束日期，null则不限制
     * @param parentView 动态添加到父布局
     */
    private View initTimePicker(Long selectdate, Long startdate, Long enddate, ViewGroup parentView) {
        Calendar selectedDate = CalendarUtils.getCalendar();
        if (selectdate == null) {
            selectedDate.setTimeInMillis(System.currentTimeMillis());
        } else {
            selectedDate.setTimeInMillis(selectdate);
        }
        Calendar startDate = CalendarUtils.getCalendar();
        if (startdate == null) {
            startDate = null;
        } else {
            startDate.setTimeInMillis(startdate);
        }
        Calendar endDate = CalendarUtils.getCalendar();
        if (enddate == null) {
            endDate = null;
        } else {
            endDate.setTimeInMillis(enddate);
        }

        //时间选择器
        pvTime = new TimeSelectView.Builder(getContext()).setLayoutRes(R.layout.datetimepicker_dialog_datepicker_ampm, new CustomListener() {
            @Override
            public void customLayout(View v) {//初始化调用
                //是否显示上午下午
                if (isAmpm) {
                    if (radioGroup == null) {
                        radioGroup = v.findViewById(R.id.rg_contanior);
                    }
                    initRadioGroup(isAm);
                    radioGroup.setVisibility(View.VISIBLE);
                } else {
                    if (radioGroup != null) {
                        radioGroup.setVisibility(View.GONE);
                    }
                }
                //绑定确定事件
                TextView tv_ampm_dialog_cancel = v.findViewById(R.id.tv_ampm_dialog_cancel);
                tv_ampm_dialog_cancel.setTag("cancel");
                tv_ampm_dialog_cancel.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                    }
                });
                TextView tv_ampm_dialog_certain = v.findViewById(R.id.tv_ampm_dialog_certain);
                tv_ampm_dialog_certain.setTag("submit");
                tv_ampm_dialog_certain.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (onPickerListener != null) {
                            Calendar calendar = CalendarUtils.getCalendar();
                            calendar.setTime(pvTime.getTime());
                            onPickerListener.datePicker(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH) + 1, calendar.get(Calendar.DAY_OF_MONTH), isSelectAm());
                        }
                    }
                });
            }
        }).setType(new boolean[]{isYear, isMonth, isDay, false, false, false})
                .setLabel("年", "月", "日", "", "", "")
                .isCenterLabel(false)
                .setDividerColor(Color.DKGRAY)
                .setDate(selectedDate)
//                .isDialog(true)
                .setRangDate(startDate, endDate)
//                .setTextXOffset()
//                .setBackgroundId(0x00FFFFFF) //设置外部遮罩颜色
                .selectTimecallBack(new ISelectTimeCallback() {
                    @Override
                    public void onTimeSelectChanged() {

                    }
                })
                .setDecorView(parentView)
                .build();
        return pvTime.getTimePickerView();
    }

    //设置最大可见条目
    private void setHookItemVisible(WheelView year) {
        try {
            Class<?> clazz = year.getClass();// 获取到对象对应的class对象
            Field typeField = clazz.getDeclaredField("itemsVisible");
            typeField.setAccessible(true);
            typeField.set(year, 7);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取选择上午状态
     *
     * @return true为上午，false为下午，null为没有选择
     */
    private Boolean isSelectAm() {
        if (radioGroup == null) {
            return null;
        }
        int radioButtonId = radioGroup.getCheckedRadioButtonId();
        if (radioButtonId == R.id.radio_datetimepicker_am) {
            return Boolean.TRUE;
        } else if (radioButtonId == R.id.radio_datetimepicker_pm) {
            return Boolean.FALSE;
        } else {
            return null;
        }
    }

    /**
     * 初始化上下午选择状态
     *
     * @param isAm true为上午，false为下午，null为默认
     */
    private void initRadioGroup(Boolean isAm) {
        if (isAm == null || radioGroup == null) {
            return;
        }
        radioGroup.clearCheck();
        if (isAm) {
            radioGroup.check(R.id.radio_datetimepicker_am);
        } else {
            radioGroup.check(R.id.radio_datetimepicker_pm);
        }
    }

    /**
     * 创建并展示dialog
     */
    public void show(Activity activity) {
        FragmentManager manager = ((FragmentActivity) activity).getSupportFragmentManager();
        Fragment fragment = manager.findFragmentByTag("DateAmPmPickerDialog");
        if (fragment == null) {
            manager.beginTransaction().add(this, "DateAmPmPickerDialog").show(this).commitAllowingStateLoss();
        } else {
            manager.beginTransaction().show(fragment).commitAllowingStateLoss();
        }
    }

    /**
     * 设置起止时间
     *
     * @param startdate 开始时间
     * @param enddate   结束时间
     * @return
     */
    public DateAmPmPickerDialog setDateRange(Long startdate, Long enddate) {
        this.startDate = startdate;
        this.endDate = enddate;
        return this;
    }

    /**
     * 是否使用年月日
     *
     * @param year  年
     * @param month 月份
     * @param day   每月的天数
     * @param ampm  上午,下午
     * @return
     */
    public DateAmPmPickerDialog setSelectEnable(boolean year, boolean month, boolean day, boolean ampm) {
        isYear = year;
        isMonth = month;
        isDay = day;
        isAmpm = ampm;
        return this;
    }

    /**
     * 设置父布局
     *
     * @param parentView 默认null
     */
    public DateAmPmPickerDialog setParentView(ViewGroup parentView) {
        this.parentView = parentView;
        return this;
    }

    /**
     * 设置当前日期
     *
     * @param currentDate null时，默认当前日期
     */
    public DateAmPmPickerDialog setCurrentDate(Long currentDate) {
        this.selectDate = currentDate;
        return this;
    }

    /**
     * 设置上下午
     *
     * @param am true上午，false下午，null默认上午
     */
    public void setAm(Boolean am) {
        isAm = am;
    }

    /**
     * 设置确定时回调
     *
     * @param onPickerListener
     * @return
     */
    public DateAmPmPickerDialog setOnPickerListener(OnPickerListener onPickerListener) {
        this.onPickerListener = onPickerListener;
        return this;
    }

    /**
     * 选择器变动监听
     */
    public interface OnPickerListener {
        /**
         * 年月日，为null则代表没有选择
         *
         * @param am true为上午，false为下午，null为没有选择
         */
        void datePicker(Integer year, Integer month, Integer day, Boolean am);
    }
}
