package com.xdja.widget.datetimepicker;

import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bigkoo.pickerview.listener.ISelectTimeCallback;
import com.contrarywind.listener.OnItemSelectedListener;
import com.xdja.widget.datetimepicker.fragment.AmPmFragment;
import com.xdja.widget.datetimepicker.fragment.CalendarFragment;
import com.xdja.widget.datetimepicker.fragment.TimeFragment;
import com.xdja.widget.datetimepicker.utils.CalendarUtils;
import com.xdja.widget.datetimepicker.view.calendarview.Calendar;
import com.xdja.widget.datetimepicker.view.calendarview.CalendarView;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * created on 2018/6/27.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:仿钉钉日期选择 日期+时间选择 日期+上下午选择
 */
public class DateAmPmTimePickDialog extends DialogFragment {
    private List<Fragment> fragmentList = new ArrayList<>();
    private CalendarFragment calendarFragment;
    private TimeFragment timeFragment;
    private RelativeLayout rl_tab1;
    private TextView tv_tab1;
    private View view_line1;
    private RelativeLayout rl_tab2;
    private TextView tv_tab2;
    private View view_line2;
    private Button btn_confirm;
    private FragmentManager manager;
    private AmPmFragment amPmFragment;


    /**
     * 显示内容类型
     */
    public static final String PARMS_TYPE = "PARMS_TYPE";
    public static final int PARMS_TYPE_1 = 1;//时间类型1-年月日 时分(24小时制)
    public static final int PARMS_TYPE_2 = 2;//时间类型2- 年月日
    public static final int PARMS_TYPE_3 = 3;//时间类型3- 年月日 Am|Pm
    public static final int PARMS_TYPE_4 = 4;//时间类型4-年月日 AM|PM 时分(12小时制)

    /**
     * 默认 日期时间
     */
    public static final String PARMS_DATE_TIME = "PARMS_DATE_TIME";

    /**
     * 默认 上午下午
     */
    public static final String PARMS_APM = "PARMS_APM";

    /**
     * 默认日期 格式化
     */
    public static final String PARMS_DATE_FORMATE = "PARAM_DATE_FORMAT";

    /**
     * 默认时间 格式化
     */
    public static final String PARMS_TIME_FORMATE = "PARMS_TIME_FORMATE";

    //默认上下午显示
    public static final String[] TITLE_APM = new String[]{"上午", "下午"};

    //默认年月日 显示形式
    private String DATE_FORMATE_DEFAULT = "yyyy-MM-dd";
    //默认时分 显示形式
    private String TIME_FORMATE_DEFAULT = "HH:mm";

    /**
     * 确定时结果回调
     */
    private OnResultListener onResultListener;

    public void setOnResultListener(OnResultListener onResultListener) {
        this.onResultListener = onResultListener;
    }

    /**
     * 创建dialog对象
     * 默认选中系统时间
     *
     * @param type        1-年月日   时分(24小时制) 2;年月日; 3- 年月日 Am|Pm
     * @param dateFormate 年月日tab显示格式,null则为"yyyy-MM-dd"
     * @param timeFormate 时分tab显示格式，null则为"HH:mm"
     * @return
     */
    public static DateAmPmTimePickDialog INSTANCE(int type, String dateFormate, String timeFormate) {
        DateAmPmTimePickDialog obj = new DateAmPmTimePickDialog();
        Bundle bundle = new Bundle();
        bundle.putInt(PARMS_TYPE, type);
        if (!TextUtils.isEmpty(dateFormate)) {
            bundle.putString(PARMS_DATE_FORMATE, dateFormate);
        }
        if (!TextUtils.isEmpty(timeFormate)) {
            bundle.putString(PARMS_TIME_FORMATE, timeFormate);
        }
        obj.setArguments(bundle);
        return obj;
    }

    /**
     * 创建dialog对象
     *
     * @param type        1-年月日   时分(24小时制) 2;年月日; 3- 年月日 Am|Pm
     * @param dataTime    默认选中年月日时分,null则为系统当前时间
     * @param dateFormate 年月日tab显示格式,null则为"yyyy-MM-dd"
     * @param timeFormate 时分tab显示格式，null则为"HH:mm"
     * @param apm         0为上午 1为下午，null则为系统当前状态
     * @return
     */
    public static DateAmPmTimePickDialog INSTANCE(int type, Long dataTime, String dateFormate, String timeFormate, Integer apm) {
        DateAmPmTimePickDialog obj = new DateAmPmTimePickDialog();
        Bundle bundle = new Bundle();
        bundle.putInt(PARMS_TYPE, type);
        if (dataTime != null) {
            bundle.putLong(PARMS_DATE_TIME, dataTime);
        }
        if (!TextUtils.isEmpty(dateFormate)) {
            bundle.putString(PARMS_DATE_FORMATE, dateFormate);
        }
        if (!TextUtils.isEmpty(timeFormate)) {
            bundle.putString(PARMS_TIME_FORMATE, timeFormate);
        }
        if (apm != null) {
            bundle.putInt(PARMS_APM, apm);
        }
        obj.setArguments(bundle);
        return obj;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.datetimepicker_dialog_dateampm_time_picker, null);
        initUi(view);
        initTab();
        initFragment();
        showCalendar();
        return view;
    }

    @Override
    public void onStart() {
        super.onStart();
        Window win = getDialog().getWindow();
        // 一定要设置Background，如果不设置，window属性设置无效
        win.setBackgroundDrawable(new ColorDrawable(getResources().getColor(R.color.datetimepicker_transport)));
        DisplayMetrics dm = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        WindowManager.LayoutParams params = win.getAttributes();
        params.gravity = Gravity.BOTTOM;
        // 使用ViewGroup.LayoutParams，以便Dialog 宽度充满整个屏幕
        params.width = ViewGroup.LayoutParams.MATCH_PARENT;
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        win.setAttributes(params);
    }

    //显示日历fragment
    private void showCalendar() {
        setCurrentItem(0);
    }

    //显示时分fragment
    private void showTime() {
        setCurrentItem(1);
    }

    //显示上下午fragment
    private void showAmPm() {
        setCurrentItem(1);
    }

    private void initUi(View dialog) {
        //注册view
        rl_tab1 = (RelativeLayout) dialog.findViewById(R.id.rl_tab1);
        tv_tab1 = (TextView) dialog.findViewById(R.id.tv_tab1);
        view_line1 = dialog.findViewById(R.id.view_line1);
        rl_tab2 = (RelativeLayout) dialog.findViewById(R.id.rl_tab2);
        tv_tab2 = (TextView) dialog.findViewById(R.id.tv_tab2);
        view_line2 = dialog.findViewById(R.id.view_line2);
        btn_confirm = (Button) dialog.findViewById(R.id.btn_confirm);
        btn_confirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onResultListener != null) {
                    onResultListener.onResult(DateAmPmTimePickDialog.this, getReturnDate(), getReturnTime(), getReturnApm(), getReturnType());
                }
            }
        });

        rl_tab1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCalendar();
                switch (getType()) {
                    case PARMS_TYPE_3:
                    case PARMS_TYPE_1: {
                        selectTab1Both();
                        break;
                    }
                    case PARMS_TYPE_2: {
                        rl_tab1.setVisibility(View.VISIBLE);
                        rl_tab2.setVisibility(View.GONE);
                        rl_tab1.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_select));
                        view_line1.setVisibility(View.VISIBLE);
                        break;
                    }
                    case PARMS_TYPE_4: {

                    }
                }
            }
        });
        rl_tab2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //初始化布局
                switch (getType()) {
                    case PARMS_TYPE_3: {
                        selectTab2Both();
                        showAmPm();
                        break;
                    }
                    case PARMS_TYPE_1: {
                        selectTab2Both();
                        showTime();
                        break;
                    }
                    case PARMS_TYPE_4: {

                    }
                }
            }
        });
        //初始化布局
        switch (getType()) {
            case PARMS_TYPE_3:
            case PARMS_TYPE_1: {
                selectTab1Both();
                break;
            }
            case PARMS_TYPE_2: {
                rl_tab1.setVisibility(View.VISIBLE);
                rl_tab2.setVisibility(View.GONE);
                rl_tab1.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_select));
                view_line1.setVisibility(View.VISIBLE);
                break;
            }
            case PARMS_TYPE_4: {

            }
        }
    }

    //2选1时，选tab1
    private void selectTab1Both() {
        rl_tab1.setVisibility(View.VISIBLE);
        rl_tab2.setVisibility(View.VISIBLE);
        rl_tab1.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_select));
        view_line1.setVisibility(View.VISIBLE);
        rl_tab2.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_noselect));
        view_line2.setVisibility(View.GONE);
    }

    //2选1时，选tab2
    private void selectTab2Both() {
        rl_tab1.setVisibility(View.VISIBLE);
        rl_tab2.setVisibility(View.VISIBLE);
        rl_tab1.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_noselect));
        view_line1.setVisibility(View.GONE);
        rl_tab2.setBackgroundColor(getResources().getColor(R.color.datetimepicker_tab_bg_select));
        view_line2.setVisibility(View.VISIBLE);
    }

    private void initTab() {
        //fragment对象和tab初始化
        fragmentList.clear();
        switch (getType()) {
            case PARMS_TYPE_1: {
                tv_tab1.setText(initTab1Title());
                tv_tab2.setText(initTab2Title());

                calendarFragment = new CalendarFragment();
                fragmentList.add(calendarFragment);
                timeFragment = new TimeFragment();
                fragmentList.add(timeFragment);
                break;
            }
            case PARMS_TYPE_2: {
                tv_tab1.setText(initTab1Title());

                calendarFragment = new CalendarFragment();
                fragmentList.add(calendarFragment);
                break;
            }
            case PARMS_TYPE_3: {
                tv_tab1.setText(initTab1Title());
                tv_tab2.setText(initTab2Title());

                calendarFragment = new CalendarFragment();
                fragmentList.add(calendarFragment);
                amPmFragment = new AmPmFragment();
                fragmentList.add(amPmFragment);
                break;
            }
            case PARMS_TYPE_4: {

            }
        }
        //fragment监听及数据初始化
        if (calendarFragment != null) {
            calendarFragment.setOnDateSelectedListener(new CalendarView.OnCalendarSelectListener() {
                @Override
                public void onCalendarOutOfRange(Calendar calendar) {
                }

                @Override
                public void onCalendarSelect(Calendar calendar, boolean isClick) {
                    if (!isClick) {//未点击返回
                        return;
                    }
                    //tab1标题
                    updateTab1Title(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
                    //tab状态和跳转
                    switch (getType()) {
                        case PARMS_TYPE_1: {
                            selectTab2Both();
                            showTime();
                            break;
                        }
                        case PARMS_TYPE_3: {
                            selectTab2Both();
                            showAmPm();
                            break;
                        }
                    }
                }
            });
            //初始化年月日
            java.util.Calendar calendar = CalendarUtils.getCalendar();
            calendar.setTimeInMillis(getDateTime());
            calendarFragment.setInitDate(calendar.get(java.util.Calendar.YEAR), calendar.get(java.util.Calendar.MONTH) + 1, calendar.get(java.util.Calendar.DAY_OF_MONTH));
        }
        if (timeFragment != null) {
            timeFragment.setiSelectTimeCallback(new ISelectTimeCallback() {
                @Override
                public void onTimeSelectChanged() {
                    updateTab2TitleTime(timeFragment.getCurHour(), timeFragment.getCurMinute());
                }
            });
            //初始化时分
            java.util.Calendar calendar = CalendarUtils.getCalendar();
            calendar.setTimeInMillis(getDateTime());
            timeFragment.setInitDate(calendar.get(java.util.Calendar.HOUR_OF_DAY), calendar.get(java.util.Calendar.MINUTE));

        }
        if (amPmFragment != null) {
            amPmFragment.setOnItemSelectedListener(new OnItemSelectedListener() {
                @Override
                public void onItemSelected(int index) {
                    updateTab2TitleApm(index);
                }
            });
            //初始化上下午
            amPmFragment.setInitCurItem(getApm());
        }
    }

    //根据控件更新tab2
    private void updateTab2TitleApm(int index) {
        if (index == 0 || index == 1) {
            tv_tab2.setText(TITLE_APM[index]);
        }
    }

    //根据控件更新tab2
    private void updateTab2TitleTime(int hour, int minute) {
        java.util.Calendar calendar = CalendarUtils.getCalendar();
        Date date = new Date();
        date.setHours(hour);
        date.setMinutes(minute);
        calendar.setTime(date);
        SimpleDateFormat formatter = CalendarUtils.getDateFormat(getTimeFormate());
        String st = formatter.format(calendar.getTime());
        tv_tab2.setText(st);
    }

    //根据日历 更新tab1标题
    private void updateTab1Title(int year, int month, int day) {
        java.util.Calendar calendar = CalendarUtils.getCalendar();
        calendar.set(year, month, day);
        SimpleDateFormat formatter = CalendarUtils.getDateFormat(getDateFormate());
        String dateString = formatter.format(calendar.getTime());
        tv_tab1.setText(dateString);
    }


    private void initFragment() {
        manager = getChildFragmentManager();
        for (Fragment obj : fragmentList) {
            manager.beginTransaction().add(R.id.framlayout, obj).hide(obj).commit();
        }
    }

    private void setCurrentItem(int index) {
        for (int i = 0; i < fragmentList.size(); i++) {
            Fragment obj = fragmentList.get(i);
            if (index == i) {//同一个显示
                manager.beginTransaction().show(obj).commit();
            } else {//隐藏其他
                manager.beginTransaction().hide(obj).commit();
            }
        }
    }

    /**
     * 获取展示类型
     *
     * @return
     */
    private int getType() {
        int tmp = PARMS_TYPE_1;
        if (getArguments() != null) {
            tmp = getArguments().getInt(PARMS_TYPE, tmp);
        }
        return tmp;
    }

    /**
     * 获取默认时间
     *
     * @return
     */
    private long getDateTime() {
        long tmp = System.currentTimeMillis();
        if (getArguments() != null) {
            tmp = getArguments().getLong(PARMS_DATE_TIME, tmp);
        }
        return tmp;
    }

    /**
     * 获取日期显示形式
     *
     * @return
     */
    private String getDateFormate() {
        String tmp = DATE_FORMATE_DEFAULT;
        if (getArguments() != null) {
            tmp = getArguments().getString(PARMS_DATE_FORMATE, tmp);
        }
        return tmp;
    }

    /**
     * 获取时分显示形式
     *
     * @return
     */
    private String getTimeFormate() {
        String tmp = TIME_FORMATE_DEFAULT;
        if (getArguments() != null) {
            tmp = getArguments().getString(PARMS_TIME_FORMATE, tmp);
        }
        return tmp;
    }

    /**
     * 获取上下午
     *
     * @return
     */
    private int getApm() {
        int tmp = -1;
        if (getArguments() != null) {
            tmp = getArguments().getInt(PARMS_APM, tmp);
        }
        return tmp;
    }

    /**
     * 初始化tab1标题
     *
     * @return
     */
    private String initTab1Title() {
        java.util.Calendar calendar = CalendarUtils.getCalendar();
        calendar.setTimeInMillis(getDateTime());
        SimpleDateFormat formatter = CalendarUtils.getDateFormat(getDateFormate());
        String st = formatter.format(calendar.getTimeInMillis());
        return st;
    }

    /**
     * 初始化tab2标题
     *
     * @return
     */
    private String initTab2Title() {
        switch (getType()) {
            case PARMS_TYPE_1: {
                java.util.Calendar calendar = CalendarUtils.getCalendar();
                calendar.setTimeInMillis(getDateTime());
                SimpleDateFormat formatter = CalendarUtils.getDateFormat(getTimeFormate());
                String st = formatter.format(calendar.getTimeInMillis());
                return st;
            }
            case PARMS_TYPE_3: {
                int tmp = getApm();
                if (tmp != 0 && tmp != 1) {//未指定，返回当前状态
                    java.util.Calendar calendar = CalendarUtils.getCalendar();
                    calendar.setTimeInMillis(getDateTime());
                    tmp = calendar.get(java.util.Calendar.AM_PM);
                }
                if (tmp == 0 || tmp == 1) {
                    return TITLE_APM[tmp];
                }
            }
            case PARMS_TYPE_2: {
                break;
            }
            case PARMS_TYPE_4: {
                break;
            }
        }
        return "";
    }

    /**
     * 获取返回的日期
     *
     * @return
     */
    public String getReturnDate() {
        if (getType() != PARMS_TYPE_1 && getType() != PARMS_TYPE_2 && getType() != PARMS_TYPE_3) {
            return null;
        }
        java.util.Calendar calendar = CalendarUtils.getCalendar();
        calendar.set(calendarFragment.getCurrentYear(), calendarFragment.getCurrentMonth() - 1, calendarFragment.getCurrentDay());
        SimpleDateFormat formatter = CalendarUtils.getDateFormat(getDateFormate());
        String dateString = formatter.format(calendar.getTime());
        return dateString;
    }

    /**
     * 获取返回的时分
     *
     * @return
     */
    public String getReturnTime() {
        if (getType() != PARMS_TYPE_1) {
            return null;
        }
        java.util.Calendar calendar = CalendarUtils.getCalendar();
        Date date = new Date();
        date.setHours(timeFragment.getCurHour());
        date.setMinutes(timeFragment.getCurMinute());
        calendar.setTime(date);
        SimpleDateFormat formatter = CalendarUtils.getDateFormat(getTimeFormate());
        String st = formatter.format(calendar.getTime());
        return st;
    }

    /**
     * 获取返回的上下午
     *
     * @return
     */
    public Integer getReturnApm() {
        if (getType() != PARMS_TYPE_3) {
            return null;
        }
        return amPmFragment.getItem() + 1;
    }

    /**
     * 获取返回的当前类型
     *
     * @return
     */
    public int getReturnType() {
        return getType();
    }

    public interface OnResultListener {
        /**
         * 返回值
         *
         * @param date
         * @param time
         * @param apm
         * @param type
         */
        void onResult(DateAmPmTimePickDialog dialog, String date, String time, Integer apm, int type);
    }
}
