package com.xdja.widget.datetimepicker;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

/**
 * created on 2018/6/27.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:
 */
public class TestActivity extends FragmentActivity {

    private Button btn_show;
    private Button btn_dismiss;
    private DateAmPmTimePickDialog dialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.datetimepicker_activity_test);
        btn_show = findViewById(R.id.btn_show);
        btn_dismiss = findViewById(R.id.btn_dismiss);
        btn_show.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                show();
            }
        });
        btn_dismiss.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dissmiss();
            }
        });
    }

    private void dissmiss() {
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    private void show() {
        if (dialog == null) {
            dialog = new DateAmPmTimePickDialog();
            dialog.setOnResultListener(new DateAmPmTimePickDialog.OnResultListener() {
                @Override
                public void onResult(DateAmPmTimePickDialog dialog, String date, String time, Integer apm, int type) {
                    Toast.makeText(TestActivity.this, "date:" + date + "time:" + time + "apm:" + apm + "type:" + type, Toast.LENGTH_SHORT).show();
                    dialog.dismiss();
                }
            });
        }
        if (dialog != null) {
            dialog.show(getSupportFragmentManager(), "dialog");
        }
    }

}
