package com.xdja.widget.datetimepicker.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.bigkoo.pickerview.adapter.ArrayWheelAdapter;
import com.contrarywind.listener.OnItemSelectedListener;
import com.contrarywind.view.WheelView;
import com.xdja.widget.datetimepicker.R;
import com.xdja.widget.datetimepicker.utils.CalendarUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * created on 2018/6/27.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:上午下午fragment
 */
public class AmPmFragment extends Fragment {

    public static final String[] TITLE = new String[]{"上午", "下午"};
    public static final int TITLE_AM = 0;
    public static final int TITLE_PM = 1;

    private WheelView wv_ampm;
    private int initIndex = -1;

    private OnItemSelectedListener onItemSelectedListener;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.datetimepicker_fragment_ampm, container, false);
        initView(view);
        return view;
    }

    private void initView(View view) {
        wv_ampm = view.findViewById(R.id.wv_ampm);
        List<String> list = new ArrayList<>();
        list.add(TITLE[TITLE_AM]);
        list.add(TITLE[TITLE_PM]);
        wv_ampm.setCyclic(false);
        wv_ampm.setLineSpacingMultiplier(2.0f);
        wv_ampm.setAdapter(new ArrayWheelAdapter(list));
        if (initIndex < 0) {//如果未传值，则给当前系统值
            Calendar calendar = CalendarUtils.getCalendar();
            calendar.setTimeInMillis(System.currentTimeMillis());
            initIndex = calendar.get(Calendar.AM_PM);
        }
        if (onItemSelectedListener != null) {
            wv_ampm.setOnItemSelectedListener(onItemSelectedListener);
        }
        setCurItem(initIndex);
    }

    /**
     * item变化监听
     *
     * @param listener
     */
    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.onItemSelectedListener = listener;
    }

    /**
     * 初始化item位置
     *
     * @param initIndex
     */
    public void setInitCurItem(int initIndex) {
        this.initIndex = initIndex;
    }

    /**
     * 获取item位置
     *
     * @return 0为am，1为pm
     */
    public int getItem() {
        return wv_ampm.getCurrentItem();
    }

    /**
     * 选择am
     * 显示界面调用，否则会npe
     */
    public void selectAm() {
        setCurItem(TITLE_AM);
    }

    /**
     * 选择pm
     * 显示界面调用，否则会npe
     */
    public void selectPm() {
        setCurItem(TITLE_PM);
    }

    private void setCurItem(int index) {
        wv_ampm.setCurrentItem(index);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

}
