package com.xdja.widget.datetimepicker.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.widget.datetimepicker.R;
import com.xdja.widget.datetimepicker.view.calendarview.CalendarView;

/**
 * created on 2018/6/27.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:日历fragment
 */
public class CalendarFragment extends Fragment {

    private CalendarView mCalendarBaseView;
    private CalendarView.OnYearChangeListener onYearChangeListener;
    private CalendarView.OnCalendarSelectListener onDateSelectedListener;
    private int year, month, day;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.datetimepicker_fragment_calendar, container, false);
        initView(view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    private void initView(View view) {
        mCalendarBaseView = view.findViewById(R.id.calendarView);
        if (onDateSelectedListener != null) {
            mCalendarBaseView.setOnCalendarSelectListener(onDateSelectedListener);
        }
        if (onYearChangeListener != null) {
            mCalendarBaseView.setOnYearChangeListener(onYearChangeListener);
        }
        if (year > 0 && month > 0 && day > 0) {
            scrollToDate(year, month, day);
        }
    }

    /**
     * 选择年监听
     *
     * @param listener
     */
    public void setOnYearChangeListener(CalendarView.OnYearChangeListener listener) {
        this.onYearChangeListener = listener;
    }

    /**
     * 选择日期监听
     *
     * @param listener
     */
    public void setOnDateSelectedListener(CalendarView.OnCalendarSelectListener listener) {
        this.onDateSelectedListener = listener;
    }

    /**
     * 设置初始化日期
     * 有一个小于0则不生效
     *
     * @param year
     * @param month
     * @param day
     */
    public void setInitDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    /**
     * 强制回退到某个日期
     *
     * @param year
     * @param month
     * @param day
     */
    public void setConstraintSelectDate(int year, int month, int day) {
        setInitDate(year, month, day);
        scrollToDate(year, month, day);
    }

    private void scrollToCurrentDate() {
        mCalendarBaseView.scrollToCurrent();
    }

    private void scrollToDate(int year, int month, int day) {
        mCalendarBaseView.scrollToCalendar(year, month, day);
    }

    public int getCurrentYear() {
        return mCalendarBaseView.getSelectedCalendar().getYear();
    }

    public int getCurrentMonth() {
        return mCalendarBaseView.getSelectedCalendar().getMonth();
    }

    public int getCurrentDay() {
        return mCalendarBaseView.getSelectedCalendar().getDay();
    }
}
