package com.xdja.widget.datetimepicker.fragment;

import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.bigkoo.pickerview.listener.ISelectTimeCallback;
import com.xdja.widget.datetimepicker.utils.CalendarUtils;
import com.xdja.widget.datetimepicker.view.TimeSelectView;

import java.util.Calendar;
import java.util.Date;

/**
 * created on 2018/6/27.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:小时分钟fragment
 */
public class TimeFragment extends Fragment {

    private TimeSelectView view;
    private int hour, minute = -1;
    private ISelectTimeCallback iSelectTimeCallback;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        //data
        Date now = new Date();
        Calendar calendar = CalendarUtils.getCalendar();
        calendar.setTime(now);
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, minute);
        //
        view = new TimeSelectView.Builder(getContext())
                .setType(new boolean[]{false, false, false, true, true, false})
                .setLabel("", "", "", "时", "分", "")
                .isCenterLabel(false)
                .setDividerColor(Color.DKGRAY)
//                .setContentTextSize(18)
                .setDate(calendar)
                .selectTimecallBack(iSelectTimeCallback)
//                .isDialog(true)
//                .setRangDate(startDate, endDate)
//                .setTextXOffset()
//                .setBackgroundId(0x00FFFFFF)
                .build();
        return view.getTimePickerView();
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    /**
     * 小时分钟监听
     *
     * @param iSelectTimeCallback
     */
    public void setiSelectTimeCallback(ISelectTimeCallback iSelectTimeCallback) {
        this.iSelectTimeCallback = iSelectTimeCallback;
    }

    /**
     * 设置初始 时分
     *
     * @param hour
     * @param minute
     */
    public void setInitDate(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    /**
     * 获取选择小时
     *
     * @return
     */
    public int getCurHour() {
        return view.getTime().getHours();
    }

    /**
     * 获取选择分钟
     *
     * @return
     */
    public int getCurMinute() {
        return view.getTime().getMinutes();
    }
}
