package com.xdja.widget.datetimepicker.timewheel;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.contrarywind.view.WheelView;

import java.util.List;

/**
 * Created by ldy on 2016/11/4.
 */

public class WheelGroupContainer extends LinearLayout {

    private List<WheelView> wheelViewList;

    public WheelGroupContainer(Context context) {
        this(context, null);
    }

    public WheelGroupContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        setOrientation(HORIZONTAL);
    }

    public void init(WheelGroupView wheelGroupDelegate) {
        wheelViewList = wheelGroupDelegate.getWheelViewList();
        LayoutParams layoutParams = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT);
        layoutParams.weight = 1;
        for (int i = 0; i < wheelViewList.size(); i++) {
            WheelView wheelView = wheelViewList.get(i);
            addView(wheelView, layoutParams);
//            LayoutInflater.from(getContext()).inflate(R.layout.view_wheel,this);
        }
    }
}
