package com.xdja.widget.datetimepicker.timewheel;

import android.app.DialogFragment;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.contrarywind.view.WheelView;
import com.xdja.widget.datetimepicker.R;

import java.util.ArrayList;
import java.util.List;


/**
 * desc:支持多个滚轮
 * author: lyl
 * 2019/4/12
 */
public class WheelGroupFragmentDialog extends DialogFragment implements View.OnClickListener {
    private WheelGroupContainer wheelGroup;
    private TextView tvWheelGroupCancel;
    private TextView tvWheelGroupCertain;
    private OnClickCertainListener onClickCertainListener;
    private WheelGroupView wheelGroupView;

    public WheelGroupView getWheelGroupDelegate() {
        return wheelGroupView;
    }

    public void setWheelGroupView(WheelGroupView wheelGroupView) {
        this.wheelGroupView = wheelGroupView;
    }

    public void setOnClickCertainListener(OnClickCertainListener onClickCertainListener) {
        this.onClickCertainListener = onClickCertainListener;
    }

    public static WheelGroupFragmentDialog newInstance() {
        WheelGroupFragmentDialog pickDialog = new WheelGroupFragmentDialog();
        return pickDialog;
    }

    public WheelGroupFragmentDialog setWheelItemAndData(WheelGroupView wheelGroup) {
        this.wheelGroupView = wheelGroup;
        return this;
    }

    @Override
    public void onStart() {
        super.onStart();
        Window win = getDialog().getWindow();
        win.setBackgroundDrawable(new ColorDrawable(getResources().getColor(R.color.datetimepicker_transport)));
        DisplayMetrics dm = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        WindowManager.LayoutParams params = win.getAttributes();
        params.gravity = Gravity.BOTTOM;
        params.width = ViewGroup.LayoutParams.MATCH_PARENT;
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        win.setAttributes(params);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.datetimepicker_fragment_wheel_group, container, false);
        initView(view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    private void initView(View view) {
        wheelGroup = view.findViewById(R.id.wp_wheel_group);
        tvWheelGroupCancel = view.findViewById(R.id.tv_wheel_group_cancel);
        tvWheelGroupCertain = view.findViewById(R.id.tv_wheel_group_certain);
        tvWheelGroupCancel.setOnClickListener(this);
        tvWheelGroupCertain.setOnClickListener(this);
        if (wheelGroupView != null) {
            wheelGroup.init(wheelGroupView);
        }
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (R.id.tv_wheel_group_cancel == viewId) {
            dismiss();
            wheelGroup.removeAllViews();
        } else if (R.id.tv_wheel_group_certain == viewId) {
            if (onClickCertainListener != null && wheelGroup.getChildCount() != 0) {
                dismiss();
                onClickCertainListener.onClickResult(getCurrentPosition());
            }
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        wheelGroup.removeAllViews();
    }

    public ArrayList<Integer> getCurrentPosition() {
        ArrayList<Integer> positionResult = new ArrayList<>();
        for (WheelView wheelView : wheelGroupView.getWheelViewList()) {
            positionResult.add(wheelView.getCurrentItem());
        }
        return positionResult;
    }

    public String getSelectTexts() {
        StringBuilder selectResult = new StringBuilder();
        for (WheelView wheelView : wheelGroupView.getWheelViewList()) {
            selectResult.append(wheelView.getCurrentItem());
        }
        return selectResult.toString();
    }

    /**
     * 数据回调
     */
    public interface OnClickCertainListener {
        void onClickResult(List<Integer> resultPositionList);
    }
}
