package com.xdja.widget.datetimepicker.timewheel;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;

import com.contrarywind.view.WheelView;
import com.xdja.widget.datetimepicker.R;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by ldy on 2016/11/4.
 */

public abstract class WheelGroupView {

    private final Context context;

    public WheelGroupView(Context context) {
        this.context = context;
    }

    @NonNull
    public abstract List<WheelView> getWheelViewList();

    public WheelView createWheelView() {
        return (WheelView) LayoutInflater.from(context).inflate(R.layout.datetimepicker_view_wheel, null);
    }

    protected ArrayList<String> getListFromInt(int start, int end) {
        ArrayList<String> list = new ArrayList<>();
        for (int i = start; i <= end; i++) {
            list.add(String.valueOf(i));
        }
        return list;
    }
}
