package com.xdja.widget.datetimepicker.utils;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

/**
 * created on 2018/10/30.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:
 */
public class CalendarUtils {

    /**
     * 默认语言 中文
     */
    public static Locale LOCALE_DEFAULT = Locale.SIMPLIFIED_CHINESE;

    /**
     * 默认时区 东八区
     */
    public static TimeZone TIMEZONE_DEFAULT = TimeZone.getTimeZone("GMT+8");

    /**
     * 获取东八区对象
     * 全局的
     *
     * @return
     */
    public static java.util.Calendar getCalendar() {
//        return java.util.Calendar.getInstance(TIMEZONE_DEFAULT, LOCALE_DEFAULT);
        return java.util.Calendar.getInstance();
    }

    /**
     * 获取东八区对象
     *
     * @param pattern
     * @return
     */
    public static SimpleDateFormat getDateFormat(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, LOCALE_DEFAULT);
        simpleDateFormat.setTimeZone(TIMEZONE_DEFAULT);
        return simpleDateFormat;
    }
}
