package com.xdja.widget.datetimepicker.view;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.bigkoo.pickerview.listener.CustomListener;
import com.bigkoo.pickerview.listener.ISelectTimeCallback;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.WheelTime;
import com.contrarywind.view.WheelView;
import com.xdja.widget.datetimepicker.R;
import com.xdja.widget.datetimepicker.utils.CalendarUtils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

/**
 * 时间选择器
 * 用于生成view布局对象
 * Created by wangkezhi on 18/6/26.
 */
public class TimeSelectView extends BasePickerView {
    public static String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";

    private int layoutRes;
    private CustomListener customListener;

    WheelTime wheelTime; //自定义控件
    private int gravity = Gravity.CENTER;//内容显示位置 默认居中
    private boolean[] type;// 显示类型

    private int Color_Background_Wheel;//滚轮背景颜色
    private int Color_Background_Title;//标题背景颜色


    private int Size_Content;//内容字体大小

    private Calendar date;//当前选中时间
    private Calendar startDate;//开始时间
    private Calendar endDate;//终止时间
    private int startYear;//开始年份
    private int endYear;//结尾年份

    private boolean cyclic;//是否循环
    private boolean cancelable;//是否能取消
    private boolean isCenterLabel;//是否只显示中间的label
    private boolean isLunarCalendar;//是否显示农历

    private int textColorOut; //分割线以外的文字颜色
    private int textColorCenter; //分割线之间的文字颜色
    private int dividerColor; //分割线的颜色

    // 条目间距倍数 默认1.6
    private float lineSpacingMultiplier = 2F;
    private String label_year, label_month, label_day, label_hours, label_mins, label_seconds;
    private int xoffset_year, xoffset_month, xoffset_day, xoffset_hours, xoffset_mins, xoffset_seconds;
    private WheelView.DividerType dividerType;//分隔线类型

    private View rootView;
    private ISelectTimeCallback iSelectTimeCallback;

    //构造方法
    public TimeSelectView(Builder builder) {
        super(builder.context);
        this.iSelectTimeCallback = builder.iSelectTimeCallback;
        this.gravity = builder.gravity;
        this.type = builder.type;
        this.Color_Background_Wheel = builder.Color_Background_Wheel;
        this.Color_Background_Title = builder.Color_Background_Title;
        this.Size_Content = builder.Size_Content;
        this.startYear = builder.startYear;
        this.endYear = builder.endYear;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.date = builder.date;
        this.cyclic = builder.cyclic;
        this.isCenterLabel = builder.isCenterLabel;
        this.isLunarCalendar = builder.isLunarCalendar;
        this.cancelable = builder.cancelable;
        this.label_year = builder.label_year;
        this.label_month = builder.label_month;
        this.label_day = builder.label_day;
        this.label_hours = builder.label_hours;
        this.label_mins = builder.label_mins;
        this.label_seconds = builder.label_seconds;
        this.xoffset_year = builder.xoffset_year;
        this.xoffset_month = builder.xoffset_month;
        this.xoffset_day = builder.xoffset_day;
        this.xoffset_hours = builder.xoffset_hours;
        this.xoffset_mins = builder.xoffset_mins;
        this.xoffset_seconds = builder.xoffset_seconds;
        this.textColorCenter = builder.textColorCenter;
        this.textColorOut = builder.textColorOut;
        this.dividerColor = builder.dividerColor;
        this.customListener = builder.customListener;
        this.layoutRes = builder.layoutRes;
        this.lineSpacingMultiplier = builder.lineSpacingMultiplier;
        this.dividerType = builder.dividerType;
        initView(builder.context);
    }

    /**
     * 获取rootview
     * 必须在build后调用否则会npe
     *
     * @return
     */
    public View getTimePickerView() {
        return rootView;
    }

    //建造器
    public static class Builder {
        private int layoutRes = R.layout.datetimepicker_time_select;
        private CustomListener customListener;
        private Context context;
        private boolean[] type = new boolean[]{true, true, true, true, true, true};//显示类型 默认全部显示
        private int gravity = Gravity.CENTER;//内容显示位置 默认居中

        private int Color_Background_Wheel;//滚轮背景颜色
        private int Color_Background_Title;//标题背景颜色

        private int Size_Submit_Cancel = 17;//确定取消按钮大小
        private int Size_Title = 18;//标题字体大小
        private int Size_Content = 18;//内容字体大小
        private Calendar date;//当前选中时间
        private Calendar startDate;//开始时间
        private Calendar endDate;//终止时间
        private int startYear;//开始年份
        private int endYear;//结尾年份

        private boolean cyclic = false;//是否循环
        private boolean cancelable = true;//是否能取消

        private boolean isCenterLabel = true;//是否只显示中间的label
        private boolean isLunarCalendar = false;//是否显示农历
        public ViewGroup decorView;//显示pickerview的根View,默认是activity的根view

        private int textColorOut; //分割线以外的文字颜色
        private int textColorCenter; //分割线之间的文字颜色
        private int dividerColor; //分割线的颜色
        private int backgroundId; //显示时的外部背景色颜色,默认是灰色
        private WheelView.DividerType dividerType;//分隔线类型
        // 条目间距倍数 默认1.6
        private float lineSpacingMultiplier = 2.0F;

        private String label_year, label_month, label_day, label_hours, label_mins, label_seconds;//单位
        private int xoffset_year, xoffset_month, xoffset_day, xoffset_hours, xoffset_mins, xoffset_seconds;//单位

        private ISelectTimeCallback iSelectTimeCallback;

        public Builder selectTimecallBack(ISelectTimeCallback callback) {
            this.iSelectTimeCallback = callback;
            return this;
        }

        //Required
        public Builder(Context context) {
            this.context = context;
        }

        //Option
        public Builder setType(boolean[] type) {
            this.type = type;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        /**
         * 必须是viewgroup
         * 设置要将pickerview显示到的容器id
         *
         * @param decorView
         * @return
         */
        public Builder setDecorView(ViewGroup decorView) {
            this.decorView = decorView;
            return this;
        }

        public Builder setBgColor(int Color_Background_Wheel) {
            this.Color_Background_Wheel = Color_Background_Wheel;
            return this;
        }

        public Builder setTitleBgColor(int Color_Background_Title) {
            this.Color_Background_Title = Color_Background_Title;
            return this;
        }

        public Builder setSubCalSize(int Size_Submit_Cancel) {
            this.Size_Submit_Cancel = Size_Submit_Cancel;
            return this;
        }

        public Builder setTitleSize(int Size_Title) {
            this.Size_Title = Size_Title;
            return this;
        }

        public Builder setContentSize(int Size_Content) {
            this.Size_Content = Size_Content;
            return this;
        }

        /**
         * 因为系统Calendar的月份是从0-11的,所以如果是调用Calendar的set方法来设置时间,月份的范围也要是从0-11
         *
         * @param date
         * @return
         */
        public Builder setDate(Calendar date) {
            this.date = date;
            return this;
        }

        public Builder setLayoutRes(int res, CustomListener customListener) {
            this.layoutRes = res;
            this.customListener = customListener;
            return this;
        }

        public Builder setRange(int startYear, int endYear) {
            this.startYear = startYear;
            this.endYear = endYear;
            return this;
        }

        /**
         * 设置起始时间
         * 因为系统Calendar的月份是从0-11的,所以如果是调用Calendar的set方法来设置时间,月份的范围也要是从0-11
         *
         * @return
         */

        public Builder setRangDate(Calendar startDate, Calendar endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
            return this;
        }


        /**
         * 设置间距倍数,但是只能在1.2-2.0f之间
         *
         * @param lineSpacingMultiplier
         */
        public Builder setLineSpacingMultiplier(float lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            return this;
        }

        /**
         * 设置分割线的颜色
         *
         * @param dividerColor
         */
        public Builder setDividerColor(int dividerColor) {
            this.dividerColor = dividerColor;
            return this;
        }

        /**
         * 设置分割线的类型
         *
         * @param dividerType
         */
        public Builder setDividerType(WheelView.DividerType dividerType) {
            this.dividerType = dividerType;
            return this;
        }

        /**
         * 设置分割线之间的文字的颜色
         *
         * @param textColorCenter
         */
        public Builder setTextColorCenter(int textColorCenter) {
            this.textColorCenter = textColorCenter;
            return this;
        }

        /**
         * 设置分割线以外文字的颜色
         *
         * @param textColorOut
         */
        public Builder setTextColorOut(int textColorOut) {
            this.textColorOut = textColorOut;
            return this;
        }

        public Builder isCyclic(boolean cyclic) {
            this.cyclic = cyclic;
            return this;
        }

        public Builder setOutSideCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setLunarCalendar(boolean lunarCalendar) {
            isLunarCalendar = lunarCalendar;
            return this;
        }

        public Builder setLabel(String label_year, String label_month, String label_day, String label_hours, String label_mins, String label_seconds) {
            this.label_year = label_year;
            this.label_month = label_month;
            this.label_day = label_day;
            this.label_hours = label_hours;
            this.label_mins = label_mins;
            this.label_seconds = label_seconds;
            return this;
        }

        /**
         * 设置X轴倾斜角度[ -90 , 90°]
         *
         * @param xoffset_year    年
         * @param xoffset_month   月
         * @param xoffset_day     日
         * @param xoffset_hours   时
         * @param xoffset_mins    分
         * @param xoffset_seconds 秒
         * @return
         */
        public Builder setTextXOffset(int xoffset_year, int xoffset_month, int xoffset_day, int xoffset_hours, int xoffset_mins, int xoffset_seconds) {
            this.xoffset_year = xoffset_year;
            this.xoffset_month = xoffset_month;
            this.xoffset_day = xoffset_day;
            this.xoffset_hours = xoffset_hours;
            this.xoffset_mins = xoffset_mins;
            this.xoffset_seconds = xoffset_seconds;
            return this;
        }

        public Builder isCenterLabel(boolean isCenterLabel) {
            this.isCenterLabel = isCenterLabel;
            return this;
        }


        public TimeSelectView build() {
            return new TimeSelectView(this);
        }
    }


    private void initView(Context context) {
//        setDialogOutSideCancelable(cancelable);
//        initViews(backgroundId);
//        init();
//        initEvents();
        if (customListener == null) {
            rootView = LayoutInflater.from(context).inflate(R.layout.datetimepicker_time_select, contentContainer);
//            RelativeLayout rv_top_bar = (RelativeLayout) findViewById(com.bigkoo.pickerview.R.id.rv_topbar);
//            rv_top_bar.setBackgroundColor(Color_Background_Title == 0 ? 0xFFf5f5f5 : Color_Background_Title);
        } else {
            customListener.customLayout(rootView = LayoutInflater.from(context).inflate(layoutRes, contentContainer));
        }
        // 时间转轮 自定义控件
        LinearLayout timePickerView = (LinearLayout) rootView.findViewById(R.id.timepicker);

        timePickerView.setBackgroundColor(Color_Background_Wheel == 0 ? 0xFFFFFFFF : Color_Background_Wheel);

        wheelTime = new WheelTime(timePickerView, type, gravity, Size_Content);
//        wheelTime.setLunarMode(isLunarCalendar);
        if (iSelectTimeCallback != null) {
            wheelTime.setSelectChangeCallback(iSelectTimeCallback);
        }

        setRange();
        setRangDate();
        setTime();

        wheelTime.setLabels(label_year, label_month, label_day, label_hours, label_mins, label_seconds);
        wheelTime.setTextXOffset(xoffset_year, xoffset_month, xoffset_day, xoffset_hours, xoffset_mins, xoffset_seconds);

        setOutSideCancelable(cancelable);
        wheelTime.setCyclic(cyclic);
        wheelTime.setDividerColor(dividerColor);
        wheelTime.setDividerType(dividerType);
        wheelTime.setLineSpacingMultiplier(lineSpacingMultiplier);
        wheelTime.setTextColorOut(textColorOut);
        wheelTime.setTextColorCenter(textColorCenter);
        wheelTime.isCenterLabel(isCenterLabel);
    }


    /**
     * 设置默认时间
     */
    public void setDate(Calendar date) {
        this.date = date;
        setRangDate();
        setTime();
    }

    /**
     * 设置可以选择的时间范围, 要在setTime之前调用才有效果
     */
    private void setRange() {
        if (startYear != 0 && endYear != 0 && startYear <= endYear) {
            wheelTime.setStartYear(startYear);
            wheelTime.setEndYear(endYear);
        }
    }

    /**
     * 设置可以选择的时间范围, 要在setTime之前调用才有效果
     */
    private void setRangDate() {
        //如果设置了时间范围
        if (startDate != null && endDate != null) {
            if (startDate.getTimeInMillis() <= endDate.getTimeInMillis()) {
                wheelTime.setRangDate(startDate, endDate);
                //判断一下默认时间是否设置了，或者是否在起始终止时间范围内
                if (date == null || date.getTimeInMillis() < startDate.getTimeInMillis()
                        || date.getTimeInMillis() > endDate.getTimeInMillis()) {
                    date = startDate;
                }
            }
        } else if (startDate != null) {
            wheelTime.setRangDate(startDate, endDate);
            //没有设置默认选中时间,那就拿开始时间当默认时间
            if (date == null || date.getTimeInMillis() < startDate.getTimeInMillis()) {
                date = startDate;
            }
        } else if (endDate != null) {
            wheelTime.setRangDate(startDate, endDate);
            if (date == null || date.getTimeInMillis() > endDate.getTimeInMillis()) {
                date = endDate;
            }
        }
    }

    /**
     * 设置选中时间,默认选中当前时间
     */
    private void setTime() {
        int year, month, day, hours, minute, seconds;

        Calendar calendar = CalendarUtils.getCalendar();

        if (date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            year = calendar.get(Calendar.YEAR);
            month = calendar.get(Calendar.MONTH);
            day = calendar.get(Calendar.DAY_OF_MONTH);
            hours = calendar.get(Calendar.HOUR_OF_DAY);
            minute = calendar.get(Calendar.MINUTE);
            seconds = calendar.get(Calendar.SECOND);
        } else {
            year = date.get(Calendar.YEAR);
            month = date.get(Calendar.MONTH);
            day = date.get(Calendar.DAY_OF_MONTH);
            hours = date.get(Calendar.HOUR_OF_DAY);
            minute = date.get(Calendar.MINUTE);
            seconds = date.get(Calendar.SECOND);
        }

        wheelTime.setPicker(year, month, day, hours, minute, seconds);
    }

    public void setLunarCalendar(boolean lunar) {
        try {
            int year, month, day, hours, minute, seconds;
            Calendar calendar = CalendarUtils.getCalendar();
            calendar.setTime(CalendarUtils.getDateFormat(DATE_FORMAT_PATTERN).parse(wheelTime.getTime()));
            year = calendar.get(Calendar.YEAR);
            month = calendar.get(Calendar.MONTH);
            day = calendar.get(Calendar.DAY_OF_MONTH);
            hours = calendar.get(Calendar.HOUR_OF_DAY);
            minute = calendar.get(Calendar.MINUTE);
            seconds = calendar.get(Calendar.SECOND);

            wheelTime.setLunarMode(lunar);
            wheelTime.setLabels(label_year, label_month, label_day, label_hours, label_mins, label_seconds);
            wheelTime.setPicker(year, month, day, hours, minute, seconds);
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public boolean isLunarCalendar() {
        return wheelTime.isLunarMode();
    }

    public Date getTime() {
        try {
            return CalendarUtils.getDateFormat(DATE_FORMAT_PATTERN).parse(wheelTime.getTime());
        } catch (ParseException e) {
            e.printStackTrace();
            return new Date(System.currentTimeMillis());
        }
    }
}
