package com.xdja.widget.datetimepicker.view.calendarview.simple;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.view.ScrollingView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import com.xdja.widget.datetimepicker.view.calendarview.CalendarLayout;

/**
 * 如果嵌套各种View出现事件冲突，可以实现这个方法即可
 */
public class CalendarLinearLayout extends LinearLayout implements CalendarLayout.CalendarScrollView {

    private ScrollingView mScrollingView;

    public CalendarLinearLayout(Context context) {
        super(context);
    }

    public CalendarLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (mScrollingView == null) {
            int childCount = getChildCount();
            for (int index = 0; index < childCount; index++) {
                View childView = getChildAt(index);
                if (childView instanceof ScrollingView) {
                    mScrollingView = (ScrollingView) childView;
                    break;
                }
            }
        }
    }

    /**
     * 如果你想让下拉无效，return false
     *
     * @return isScrollToTop
     */
    @Override
    public boolean isScrollToTop() {
        return mScrollingView != null && mScrollingView.computeVerticalScrollOffset() == 0;
    }
}
