package com.xdja.location;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;

import com.amap.api.maps2d.AMapOptions;
import com.amap.api.maps2d.MapView;

/**
 * desc: 重写地图展示View
 * author: jarlen
 * date: 2018/12/28 17:40
 */
public class EoaMapView extends MapView {
    public EoaMapView(Context context) {
        super(context);
        init(context);
    }

    public EoaMapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        init(context);
    }

    public EoaMapView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        init(context);
    }

    public EoaMapView(Context context, AMapOptions aMapOptions) {
        super(context, aMapOptions);
        init(context);
    }

    private void init(Context context) {
        getViewTreeObserver().addOnGlobalLayoutListener(
                new ViewTreeObserver.OnGlobalLayoutListener() {
                    @Override
                    public void onGlobalLayout() {
                        ViewGroup childView = (ViewGroup) getChildAt(0);
                        if (childView != null) {
                            View view = childView.getChildAt(2);
                            if (view != null) {
                                view.setVisibility(View.GONE);
                            }
                        }
                    }
                });
    }


}
