package com.xdja.location;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.TextView;

import com.amap.api.services.core.PoiItem;

import java.util.ArrayList;
import java.util.List;


public class PoiSearchAdapter extends BaseAdapter {
    private List<PoiItem> items = new ArrayList<>();
    private Context mContext;
    private LayoutInflater inflater;


    public PoiSearchAdapter(Context context) {
        mContext = context;
        inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    public void setData(List<PoiItem> items) {
        this.items = items;
    }

    public List<PoiItem> getData() {
        return items;
    }

    @Override
    public int getCount() {
        return items.size();
    }

    @Override
    public Object getItem(int position) {
        return items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        PoiItem item = items.get(position);
        ViewHolder holder = null;
        if (null == convertView) {
            convertView = inflater.inflate(R.layout.location_item_layout, null);
            holder = new ViewHolder();
            holder.addressTv = convertView.findViewById(R.id.address);
            holder.titleTv = convertView.findViewById(R.id.location_title);
            holder.radioButton = convertView.findViewById(R.id.radioBtn);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        String title = "";
        String snippet = "";
        if (null != item) {
            if (!TextUtils.isEmpty(item.getTitle())) {
                title = item.getTitle();
            }
            if (!TextUtils.isEmpty(item.getSnippet())) {
                snippet = item.getSnippet();
            } else {
                snippet = title;
            }
        }
        holder.titleTv.setText(title);
        holder.addressTv.setText(snippet);

        if (item == LocationActivity.selectedItem) {
            holder.radioButton.setChecked(true);
            holder.radioButton.setVisibility(View.VISIBLE);
        } else {
            holder.radioButton.setChecked(false);
            holder.radioButton.setVisibility(View.GONE);
        }

        return convertView;
    }

    static class ViewHolder {
        TextView titleTv;
        TextView addressTv;
        CheckBox radioButton;
    }
}
