package com.xdja.location.params;

import android.os.Parcel;
import android.os.Parcelable;

public class LocationDetailParams implements Parcelable {
    public double latitude;
    public double longitude;
    public String desc;
    private int type;//1 百度2 高德 3 google 4 gis 5 其他

    public LocationDetailParams() {
    }

    protected LocationDetailParams(Parcel in) {
        latitude = in.readDouble();
        longitude = in.readDouble();
        desc = in.readString();
        type = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(latitude);
        dest.writeDouble(longitude);
        dest.writeString(desc);
        dest.writeInt(type);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<LocationDetailParams> CREATOR = new Creator<LocationDetailParams>() {
        @Override
        public LocationDetailParams createFromParcel(Parcel in) {
            return new LocationDetailParams(in);
        }

        @Override
        public LocationDetailParams[] newArray(int size) {
            return new LocationDetailParams[size];
        }
    };

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
}
