package com.xdja.location.params;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author mob-wan
 * @date 2019/10/21
 * <p>
 * 打卡范围
 */
public class RuleAddress implements Parcelable {

    /**
     * 经度
     */
    private double longitude;
    /**
     * 纬度
     */
    private double latitude;
    /**
     * 打卡范围 以米为单位
     */
    private long distanceRange;

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public long getDistanceRange() {
        return distanceRange;
    }

    public void setDistanceRange(long distanceRange) {
        this.distanceRange = distanceRange;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.latitude);
        dest.writeLong(this.distanceRange);
    }

    public RuleAddress() {
    }

    protected RuleAddress(Parcel in) {
        this.longitude = in.readDouble();
        this.latitude = in.readDouble();
        this.distanceRange = in.readLong();
    }

    public static final Creator<RuleAddress> CREATOR = new Creator<RuleAddress>() {
        @Override
        public RuleAddress createFromParcel(Parcel source) {
            return new RuleAddress(source);
        }

        @Override
        public RuleAddress[] newArray(int size) {
            return new RuleAddress[size];
        }
    };
}
