/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import com.blankj.utilcode.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class BitmapUtils {
    private static final int itemh = 360;
    private static final int itemw = 360;
    private static final int miniMapMaxSize = 8192;
    private static final int scaleSize = 102400;
    private static final String TAG = "Util";
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_UP = 2;
    public static final int DIRECTION_DOWN = 3;
    public static String fileFolder = Environment.getExternalStorageDirectory().getPath() + "/jingxin/cache/file_scale/";

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", -1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                case 1: {
                    degree = 0;
                    break;
                }
                case 0: {
                    degree = 0;
                    break;
                }
                case -1: {
                    degree = 0;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap adjustPhotoRotation(Bitmap bm, int orientationDegree) {
        float targetY;
        float targetX;
        Matrix m = new Matrix();
        m.setRotate((float)orientationDegree, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
        if (orientationDegree == 90) {
            targetX = bm.getHeight();
            targetY = 0.0f;
        } else {
            targetX = bm.getHeight();
            targetY = bm.getWidth();
        }
        float[] values = new float[9];
        m.getValues(values);
        float x1 = values[2];
        float y1 = values[5];
        m.postTranslate(targetX - x1, targetY - y1);
        Bitmap bm1 = Bitmap.createBitmap((int)bm.getHeight(), (int)bm.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bm1);
        canvas.drawBitmap(bm, m, paint);
        bm.recycle();
        bm = null;
        return bm1;
    }

    public static void startPhotoZoom(Uri uri, Activity context, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(uri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 360);
        intent.putExtra("outputY", 360);
        intent.putExtra("return-data", true);
        context.startActivityForResult(intent, requestCode);
    }

    public static Bitmap big(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postScale(1.5f, 1.5f);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizeBmp;
    }

    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizeBmp;
    }

    public static Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        }
        return null;
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        return BitmapUtils.Bitmap2Bytes(bm, 100);
    }

    public static byte[] Bitmap2Bytes(Bitmap bm, int level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, level, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap getZoomedDrawable(String filePath, int zoom) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while (mWidth / s > 720 * zoom || mHeight / s > 720 * zoom) {
            s *= 2;
        }
        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bm != null) {
            float fs;
            int h = bm.getHeight();
            int w = bm.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bm;
        }
        return null;
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        int x = bitmap.getWidth();
        canvas.drawCircle((float)(x / 2), (float)(x / 2), (float)(x / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap getBitmap(String path, int width, int heigh) {
        if (!FileUtils.isFileExists((String)path)) {
            return null;
        }
        Bitmap bt = null;
        BitmapFactory.Options op = new BitmapFactory.Options();
        try {
            if (!path.contains("scale")) {
                op.inJustDecodeBounds = true;
                bt = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
                int xScale = op.outWidth / width;
                int yScale = op.outHeight / heigh;
                op.inSampleSize = xScale > yScale ? xScale : yScale;
                op.inJustDecodeBounds = false;
                bt = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
            } else {
                op.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
                op.inJustDecodeBounds = true;
                bt = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
                int xScale = op.outWidth / width;
                int yScale = op.outHeight / heigh;
                int scaleFactor = xScale > yScale ? xScale : yScale;
                bt = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(op.outWidth / scaleFactor), (int)(op.outHeight / scaleFactor), (boolean)false);
            }
            if (null != bt) {
                Log.i((String)"renjw", (String)("miniMap size = " + bt.getByteCount()));
            }
            return bt;
        }
        catch (Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getBitmapBase64Str(Bitmap miniMap) {
        String miniMapStr_Base64 = "";
        int curCompressLevel = 100;
        if (null == miniMap) {
            return "";
        }
        byte[] curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
        if (curMiniMapBytes.length > 8192) {
            byte[] lastMiniMapBytes = curMiniMapBytes;
            byte[] lastButOneMiniMapBytes = null;
            int maxCompressLevel = 99;
            int minCompressLevel = 1;
            int lastCompressLevel = curCompressLevel;
            int tempCompressLevel = 0;
            curCompressLevel = 100 - 819200 / curMiniMapBytes.length;
            curCompressLevel = curCompressLevel == lastCompressLevel ? curCompressLevel - 1 : curCompressLevel;
            curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
            while (Math.abs(curCompressLevel - lastCompressLevel) > 1 && curMiniMapBytes.length != 8192) {
                lastButOneMiniMapBytes = lastMiniMapBytes;
                lastMiniMapBytes = curMiniMapBytes;
                tempCompressLevel = curCompressLevel;
                if (curMiniMapBytes.length > 8192) {
                    maxCompressLevel = curCompressLevel;
                    curCompressLevel = curCompressLevel > lastCompressLevel ? (curCompressLevel -= (curCompressLevel - lastCompressLevel) / 2) : minCompressLevel + (curCompressLevel - minCompressLevel) / 2;
                } else {
                    minCompressLevel = curCompressLevel;
                    curCompressLevel = curCompressLevel > lastCompressLevel ? maxCompressLevel - (maxCompressLevel - curCompressLevel) / 2 : (curCompressLevel += (lastCompressLevel - curCompressLevel) / 2);
                }
                if (curCompressLevel == (lastCompressLevel = tempCompressLevel)) continue;
                curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
            }
            miniMapStr_Base64 = curMiniMapBytes.length > 8192 && lastMiniMapBytes.length > 8192 ? (null != lastButOneMiniMapBytes ? Base64.encodeToString((byte[])lastButOneMiniMapBytes, (int)2) : Base64.encodeToString((byte[])curMiniMapBytes, (int)0)) : (curMiniMapBytes.length < 8192 && lastMiniMapBytes.length < 8192 ? Base64.encodeToString((byte[])curMiniMapBytes, (int)2) : (curMiniMapBytes.length > 8192 ? Base64.encodeToString((byte[])lastMiniMapBytes, (int)2) : Base64.encodeToString((byte[])curMiniMapBytes, (int)2)));
            lastMiniMapBytes = null;
            lastButOneMiniMapBytes = null;
        } else {
            miniMapStr_Base64 = Base64.encodeToString((byte[])curMiniMapBytes, (int)0);
        }
        curMiniMapBytes = null;
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u7ed3\u675f"));
        return miniMapStr_Base64;
    }

    public static String getMiniMap(String pictureFilePath) {
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u5f00\u59cb"));
        Bitmap miniMap = BitmapUtils.getBitmap(pictureFilePath, 360, 360);
        if (miniMap == null) {
            return "";
        }
        return BitmapUtils.getBitmapBase64Str(miniMap);
    }

    public static String getMiniMap2(Bitmap scaleBitmap) {
        int yScale;
        int scaleFactor;
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u5f00\u59cb"));
        if (scaleBitmap == null) {
            return "";
        }
        int xScale = scaleBitmap.getWidth() / 360;
        int n = scaleFactor = xScale > (yScale = scaleBitmap.getHeight() / 360) ? xScale : yScale;
        if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        scaleBitmap = Bitmap.createScaledBitmap((Bitmap)scaleBitmap, (int)(scaleBitmap.getWidth() / scaleFactor), (int)(scaleBitmap.getHeight() / scaleFactor), (boolean)false);
        return BitmapUtils.getBitmapBase64Str(scaleBitmap);
    }

    public static String saveMyBitmapWithCompress(String sourcePath, String destPath, Bitmap mBitmap, int compress) {
        String newFileName = System.currentTimeMillis() + (long)new Random().nextInt(512) + ".png";
        File file = new File(destPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        File f = new File(destPath + "/" + newFileName);
        try {
            f.createNewFile();
            FileOutputStream fOut = new FileOutputStream(f);
            mBitmap.compress(Bitmap.CompressFormat.JPEG, compress, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return sourcePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return sourcePath;
        }
        return destPath + "/" + newFileName;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap) {
        File file = new File(Environment.getExternalStorageDirectory().getPath() + "/mob/");
        if (!file.exists()) {
            file.mkdirs();
        }
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(file.getAbsolutePath(), System.currentTimeMillis() + ".png"));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getImageFromAssets(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        InputStream is = null;
        try {
            is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }
}

